/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4j.filter.Filter;

public class StringFilter
implements Filter {
    private final Operator operator;
    private final String constValue;

    public StringFilter(String newOperator, String constValue) {
        this.operator = Operator.getInstance(newOperator);
        this.constValue = constValue;
    }

    public StringFilter(Operator newOperator, String constValue) {
        this.operator = newOperator;
        this.constValue = constValue;
    }

    @Override
    public final boolean complies(Object value) {
        if (value == null) {
            return this.constValue == null;
        }
        String str = (String)value;
        if (this.operator == Operator.EQ_RELAXED) {
            int valLen = this.constValue.length();
            if (str.length() > valLen) {
                str = str.substring(0, valLen);
            }
            return str.compareTo(this.constValue) == 0;
        }
        return this.simpleCompareTo(str);
    }

    private boolean simpleCompareTo(String str) {
        int result = str.compareTo(this.constValue);
        if (this.operator == Operator.GT) {
            return result > 0;
        }
        if (this.operator == Operator.GTE) {
            return result > 0 || result == 0;
        }
        if (this.operator == Operator.EQ) {
            return result == 0;
        }
        if (this.operator == Operator.LT) {
            return result < 0;
        }
        if (this.operator == Operator.LTE) {
            return result < 0 || result == 0;
        }
        throw new IllegalStateException("Unknown operator '" + String.valueOf(this.operator) + "'!");
    }

    public final String toString() {
        return " " + String.valueOf(this.operator) + " '" + this.constValue + "'";
    }

    public final Operator getOperator() {
        return this.operator;
    }

    public final String getOperatorName() {
        return String.valueOf(this.operator);
    }

    public final String getConstValue() {
        return this.constValue;
    }

    public static final class Operator {
        public static final Operator LT = new Operator("LT", "<");
        public static final Operator LTE = new Operator("LTE", "<=");
        public static final Operator EQ = new Operator("EQ", "=");
        public static final Operator EQ_RELAXED = new Operator("EQ_RELAXED", "~");
        public static final Operator GT = new Operator("GT", ">");
        public static final Operator GTE = new Operator("GTE", ">=");
        public static final List<Operator> INSTANCES = Operator.asList(LT, LTE, EQ, EQ_RELAXED, GT, GTE);
        private final String id;
        private final String sign;

        private Operator(String id, String sign) {
            Utils4J.checkNotNull("id", id);
            Utils4J.checkNotNull("sign", sign);
            this.id = id;
            this.sign = sign;
        }

        public final String getId() {
            return this.id;
        }

        public final String getSign() {
            return this.sign;
        }

        public static boolean isValid(String id) {
            Utils4J.checkNotNull("id", id);
            for (Operator op : INSTANCES) {
                if (!op.getId().equals(id)) continue;
                return true;
            }
            return false;
        }

        public static Operator getInstance(String id) {
            Utils4J.checkNotNull("id", id);
            for (Operator op : INSTANCES) {
                if (!op.getId().equals(id)) continue;
                return op;
            }
            throw new IllegalArgumentException("The id '" + id + "' is unknown!");
        }

        public final String toString() {
            return this.sign;
        }

        private static List<Operator> asList(Operator ... operators) {
            ArrayList<Operator> list = new ArrayList<Operator>(operators.length);
            for (Operator operator : operators) {
                list.add(operator);
            }
            return Collections.unmodifiableList(list);
        }
    }
}

