/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public final class JaxbUtils {
    public static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";

    private JaxbUtils() {
        throw new UnsupportedOperationException("It's not allowed to create an instance of a utility class");
    }

    public static <T> String marshal(T data, Class<?> ... classesToBeBound) {
        return JaxbUtils.marshal(data, null, classesToBeBound);
    }

    public static <T> String marshal(T data, XmlAdapter<?, ?>[] adapters, Class<?> ... classesToBeBound) {
        if (data == null) {
            return null;
        }
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])classesToBeBound);
            return JaxbUtils.marshal(ctx, data, adapters);
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Error marshalling test data", ex);
        }
    }

    public static <T> String marshal(JAXBContext ctx, T data) {
        return JaxbUtils.marshal(ctx, data, null);
    }

    public static <T> String marshal(JAXBContext ctx, T data, XmlAdapter<?, ?>[] adapters) {
        if (data == null) {
            return null;
        }
        try {
            Marshaller marshaller = ctx.createMarshaller();
            if (adapters != null) {
                for (XmlAdapter<?, ?> adapter : adapters) {
                    marshaller.setAdapter(adapter);
                }
            }
            StringWriter writer = new StringWriter();
            marshaller.marshal(data, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Error marshalling test data", ex);
        }
    }

    public static <T> T unmarshal(String xmlData, Class<?> ... classesToBeBound) {
        return JaxbUtils.unmarshal(xmlData, null, classesToBeBound);
    }

    public static <T> T unmarshal(String xmlData, XmlAdapter<?, ?>[] adapters, Class<?> ... classesToBeBound) {
        if (xmlData == null) {
            return null;
        }
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])classesToBeBound);
            return JaxbUtils.unmarshal(ctx, xmlData, adapters);
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Error unmarshalling test data", ex);
        }
    }

    public static <T> T unmarshal(JAXBContext ctx, String xmlData, XmlAdapter<?, ?>[] adapters) {
        if (xmlData == null) {
            return null;
        }
        try {
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            if (adapters != null) {
                for (XmlAdapter<?, ?> adapter : adapters) {
                    unmarshaller.setAdapter(adapter);
                }
            }
            unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    if (event.getSeverity() > 0) {
                        Throwable ex = event.getLinkedException();
                        if (ex == null) {
                            throw new RuntimeException("Error unmarshalling the data: " + event.getMessage());
                        }
                        throw new RuntimeException("Error unmarshalling the data", ex);
                    }
                    return true;
                }
            });
            return (T)unmarshaller.unmarshal((Reader)new StringReader(xmlData));
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Error unmarshalling test data", ex);
        }
    }
}

