/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.fileprocessor;

public final class FileHandlerResult {
    public static final FileHandlerResult CONTINUE = new FileHandlerResult("CONTINUE");
    public static final FileHandlerResult SKIP_ALL = new FileHandlerResult("SKIP_ALL");
    public static final FileHandlerResult SKIP_FILES = new FileHandlerResult("SKIP_FILES");
    public static final FileHandlerResult SKIP_SUBDIRS = new FileHandlerResult("SKIP_SUBDIRS");
    public static final FileHandlerResult STOP = new FileHandlerResult("STOP");
    public static final FileHandlerResult[] INSTANCES = new FileHandlerResult[]{CONTINUE, SKIP_ALL, SKIP_FILES, SKIP_SUBDIRS, STOP};
    private final String name;

    private FileHandlerResult(String name) {
        this.name = name;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileHandlerResult other = (FileHandlerResult)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public final String toString() {
        return this.name;
    }

    public static FileHandlerResult fromName(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < INSTANCES.length; ++i) {
            if (!FileHandlerResult.INSTANCES[i].name.equals(name)) continue;
            return INSTANCES[i];
        }
        throw new IllegalArgumentException("Unknown name: " + name);
    }

    public static boolean isValid(String name) {
        if (name == null) {
            return true;
        }
        for (int i = 0; i < INSTANCES.length; ++i) {
            if (!FileHandlerResult.INSTANCES[i].name.equals(name)) continue;
            return true;
        }
        return false;
    }
}

