/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.fileprocessor;

public final class FileOrder {
    public static final FileOrder DEFAULT = new FileOrder("DEFAULT");
    public static final FileOrder FILES_FIRST = new FileOrder("FILES_FIRST");
    public static final FileOrder DIR_FIRST = new FileOrder("DIR_FIRST");
    public static final FileOrder[] INSTANCES = new FileOrder[]{DEFAULT, FILES_FIRST, DIR_FIRST};
    private final String name;

    private FileOrder(String name) {
        this.name = name;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileOrder other = (FileOrder)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public final String toString() {
        return this.name;
    }

    public static FileOrder fromName(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < INSTANCES.length; ++i) {
            if (!FileOrder.INSTANCES[i].name.equals(name)) continue;
            return INSTANCES[i];
        }
        throw new IllegalArgumentException("Unknown name: " + name);
    }

    public static boolean isValid(String name) {
        if (name == null) {
            return true;
        }
        for (int i = 0; i < INSTANCES.length; ++i) {
            if (!FileOrder.INSTANCES[i].name.equals(name)) continue;
            return true;
        }
        return false;
    }
}

