/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.filter;

import org.fuin.utils4j.Utils4J;
import org.fuin.utils4j.filter.Filter;

public abstract class ComparableFilter
implements Filter {
    private final Operator operator;
    private final Comparable constValue;

    public ComparableFilter(Operator newOperator, Comparable constValue) {
        this.operator = newOperator;
        this.constValue = constValue;
    }

    @Override
    public final boolean complies(Object value) {
        if (value == null) {
            return this.constValue == null;
        }
        return this.simpleCompareTo((Comparable)value);
    }

    public final Operator getOperator() {
        return this.operator;
    }

    public final String getOperatorName() {
        return "" + this.operator;
    }

    protected final Comparable getConstValueIntern() {
        return this.constValue;
    }

    private boolean simpleCompareTo(Comparable propValue) {
        int result = propValue.compareTo(this.constValue);
        if (this.operator == Operator.GT) {
            return result > 0;
        }
        if (this.operator == Operator.GTE) {
            return result >= 0;
        }
        if (this.operator == Operator.EQ) {
            return result == 0;
        }
        if (this.operator == Operator.LT) {
            return result < 0;
        }
        if (this.operator == Operator.LTE) {
            return result <= 0;
        }
        throw new IllegalStateException("Unknown operator '" + this.operator + "'!");
    }

    public final String toString() {
        return " " + this.operator + " " + this.constValue;
    }

    public static final class Operator {
        public static final Operator LT = new Operator("LT", "<");
        public static final Operator LTE = new Operator("LTE", "<=");
        public static final Operator EQ = new Operator("EQ", "=");
        public static final Operator GT = new Operator("GT", ">");
        public static final Operator GTE = new Operator("GTE", ">=");
        public static final Operator[] INSTANCES = new Operator[]{LT, LTE, EQ, GT, GTE};
        private final String id;
        private final String sign;

        private Operator(String id, String sign) {
            Utils4J.checkNotNull("id", id);
            Utils4J.checkNotNull("sign", sign);
            this.id = id;
            this.sign = sign;
        }

        public final String getId() {
            return this.id;
        }

        public final String getSign() {
            return this.id;
        }

        public static boolean isValid(String id) {
            Utils4J.checkNotNull("id", id);
            for (int i = 0; i < INSTANCES.length; ++i) {
                if (!INSTANCES[i].getId().equals(id)) continue;
                return true;
            }
            return false;
        }

        public static Operator getInstance(String id) {
            Utils4J.checkNotNull("id", id);
            for (int i = 0; i < INSTANCES.length; ++i) {
                if (!INSTANCES[i].getId().equals(id)) continue;
                return INSTANCES[i];
            }
            throw new IllegalArgumentException("The id '" + id + "' is unknown!");
        }

        public final String toString() {
            return this.sign;
        }
    }
}

