/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.mxgraph;

import org.fujion.client.IClientTransform;
import org.fujion.mxgraph.MXCellOverlay;
import org.fujion.mxgraph.MXGraph;
import org.w3c.dom.Element;

public abstract class MXCell<T extends MXCell<T>>
implements IClientTransform {
    private String value;
    private String style;
    private boolean visible = true;
    private boolean collapsed;
    private Object data;
    private boolean inserted;
    private final String id;
    private final MXGraph graph;

    protected MXCell(MXGraph graph, String value, String style) {
        this.graph = graph;
        this.id = graph.nextId();
        this.value = value;
        this.style = style;
    }

    protected MXCell(MXGraph graph, Element node) {
        this.graph = graph;
        this.id = node.getAttribute("id");
        this.value = node.getAttribute("value");
        this.style = node.getAttribute("style");
    }

    protected abstract void doInsert();

    public T insert() {
        if (!this.inserted) {
            this.doInsert();
            this.inserted = true;
        }
        return (T)this;
    }

    public Object transformForClient() {
        return this.id;
    }

    public MXGraph getGraph() {
        return this.graph;
    }

    public String getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.updateCellState("setValue", this.value);
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
        this.updateCellState("setStyle", this.style);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.updateCellState("setVisible", this.visible);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
        this.updateCellState("setCollapsed", this.collapsed);
    }

    protected void updateCellState(String method, Object value) {
        this.getGraph().invoke("setCellState", new Object[]{this, method, value});
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void addCellOverlay(MXCellOverlay overlay) {
        this.getGraph().invoke("addCellOverlay", new Object[]{this, overlay});
    }

    public void autoSize() {
        this.autoSize(true);
    }

    public void autoSize(boolean recurse) {
        this.getGraph().invoke("autoSizeCell", new Object[]{this, recurse});
    }
}

