/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.mxgraph;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fujion.ancillary.IResponseCallback;
import org.fujion.annotation.Component;
import org.fujion.common.Assert;
import org.fujion.common.MiscUtil;
import org.fujion.common.XMLUtil;
import org.fujion.component.BaseUIComponent;
import org.fujion.mxgraph.MXEdge;
import org.fujion.mxgraph.MXUtil;
import org.fujion.mxgraph.MXVertex;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Component(tag="mxgraph", widgetModule="fujion-mxgraph", widgetClass="MXGraph", parentTag={"*"}, content=Component.ContentHandling.AS_ATTRIBUTE, description="Fujion wrapper for mxGraph component.")
public class MXGraph
extends BaseUIComponent {
    private int nextId;
    private boolean readonly;
    private boolean prettyXML;
    private boolean tooltips = true;
    private boolean panning = true;
    private boolean allowDanglingEdges;
    private boolean disconnectOnMove;
    private int gridSize = 10;
    private boolean gridEnabled = true;
    private boolean portsEnabled = true;
    private final Map<String, MXEdge> edges = new HashMap<String, MXEdge>();
    private final Map<String, MXVertex> vertices = new HashMap<String, MXVertex>();

    protected String nextId() {
        return "_fujion_" + ++this.nextId;
    }

    public Map<String, MXVertex> getVertices() {
        return Collections.unmodifiableMap(this.vertices);
    }

    public Map<String, MXEdge> getEdges() {
        return Collections.unmodifiableMap(this.edges);
    }

    public MXVertex getVertex(String id) {
        return this.vertices.get(id);
    }

    public MXEdge getEdge(String id) {
        return this.edges.get(id);
    }

    public void beginUpdate() {
        this.invoke("beginUpdate", new Object[0]);
    }

    public void endUpdate() {
        this.invoke("endUpdate", new Object[0]);
    }

    public MXVertex createVertex(String value, int x, int y, int width, int height, String style, boolean relative) {
        return this.addVertex(new MXVertex(this, value, x, y, width, height, style, relative));
    }

    private MXVertex addVertex(MXVertex vertex) {
        String id = vertex.getId();
        if (id != null) {
            this.vertices.put(id, vertex);
        }
        return vertex;
    }

    public MXVertex insertVertex(String value, int x, int y, int width, int height, String style, boolean relative) {
        return (MXVertex)this.createVertex(value, x, y, width, height, style, relative).insert();
    }

    public MXEdge createEdge(String value, MXVertex source, MXVertex target, String style) {
        return this.addEdge(new MXEdge(this, value, style, source, target));
    }

    private MXEdge addEdge(MXEdge edge) {
        String id = edge.getId();
        if (id != null) {
            this.edges.put(id, edge);
        }
        return edge;
    }

    public MXEdge insertEdge(String value, MXVertex source, MXVertex target, String style) {
        return (MXEdge)this.createEdge(value, source, target, style).insert();
    }

    public void mxInvoke(String functionName, Object ... args) {
        this.invoke("mxInvoke", new Object[]{functionName, args});
    }

    public void mxInvoke(IResponseCallback<?> cb, String functionName, Object ... args) {
        this.invoke("mxInvoke", cb, new Object[]{functionName, args});
    }

    public void clear() {
        this._clear();
        this.invoke("clear", new Object[0]);
    }

    private void _clear() {
        this.vertices.clear();
        this.edges.clear();
    }

    public void refresh() {
        this.refresh(null);
    }

    public void refresh(Runnable cb) {
        this.invoke("getGraphXML", xml -> {
            this._refresh((String)xml);
            if (cb != null) {
                cb.run();
            }
        }, new Object[]{this.prettyXML});
    }

    private void _refresh(String content) {
        try {
            this.build(XMLUtil.parseXMLFromString((String)content));
            this.setContentSynced(false);
            this.setContent(content);
        }
        catch (Exception e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
        finally {
            this.setContentSynced(true);
        }
    }

    private void build(Document doc) {
        this._clear();
        Element root = doc.getDocumentElement();
        root = "root".equals(root.getTagName()) ? root : (Element)root.getElementsByTagName("root").item(0);
        Assert.notNull((Object)root, (String)"Cannot find root element", (Object[])new Object[0]);
        this.build(root);
    }

    private void build(Element ele) {
        NodeList children = ele.getChildNodes();
        int count = children.getLength();
        for (int i = 0; i < count; ++i) {
            Element child = (Element)children.item(i);
            if ("mxCell".equals(child.getTagName())) {
                if (MXUtil.get(child, "vertex", Integer.class, 0) != 0) {
                    this.addVertex(new MXVertex(this, child));
                } else if (MXUtil.get(child, "edge", Integer.class, 0) != 0) {
                    this.addEdge(new MXEdge(this, child));
                }
            }
            this.build(child);
        }
    }

    public String getContent() {
        return super.getContent();
    }

    protected void setContent(String content) {
        this._clear();
        super.setContent(content);
    }

    @Component.PropertyGetter(value="readonly", bindable=false, description="True if the graph is read-only.")
    public boolean isReadonly() {
        return this.readonly;
    }

    @Component.PropertySetter(value="readonly", bindable=false, defaultValue="false", description="True if the graph is read-only.")
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.propertyChange("readonly", this.readonly, this.readonly, true);
    }

    @Component.PropertyGetter(value="tooltips", bindable=false, description="True if tooltips are enabled.")
    public boolean getTooltips() {
        return this.tooltips;
    }

    @Component.PropertySetter(value="tooltips", bindable=false, defaultValue="true", description="True if tooltips are enabled.")
    public void setTooltips(boolean tooltips) {
        this.tooltips = tooltips;
        this.propertyChange("tooltips", this.tooltips, this.tooltips, true);
    }

    @Component.PropertyGetter(value="panning", bindable=false, description="True if panning is enabled.")
    public boolean getPanning() {
        return this.panning;
    }

    @Component.PropertySetter(value="panning", bindable=false, defaultValue="true", description="True if panning is enabled.")
    public void setPanning(boolean panning) {
        this.panning = panning;
        this.propertyChange("panning", this.panning, this.panning, true);
    }

    @Component.PropertyGetter(value="allowDanglingEdges", bindable=false, description="True if dangling edges are allowed.")
    public boolean getAllowDanglingEdges() {
        return this.allowDanglingEdges;
    }

    @Component.PropertySetter(value="allowDanglingEdges", bindable=false, defaultValue="false", description="True if dangling edges are allowed.")
    public void setAllowDanglingEdges(boolean allowDanglingEdges) {
        this.allowDanglingEdges = allowDanglingEdges;
        this.propertyChange("allowDanglingEdges", this.allowDanglingEdges, this.allowDanglingEdges, true);
    }

    @Component.PropertyGetter(value="disconnectOnMove", bindable=false, description="True if disconnect on move is allowed.")
    public boolean getDisconnectOnMove() {
        return this.disconnectOnMove;
    }

    @Component.PropertySetter(value="disconnectOnMove", bindable=false, defaultValue="false", description="True if disconnect on move is allowed.")
    public void setDisconnectOnMove(boolean disconnectOnMove) {
        this.disconnectOnMove = disconnectOnMove;
        this.propertyChange("disconnectOnMove", this.disconnectOnMove, this.disconnectOnMove, true);
    }

    @Component.PropertyGetter(value="prettyXML", bindable=false, description="True if XML to be returned in pretty format.")
    public boolean isPrettyXML() {
        return this.prettyXML;
    }

    @Component.PropertySetter(value="prettyXML", bindable=false, defaultValue="false", description="True if XML to be returned in pretty format.")
    public void setPrettyXML(boolean prettyXML) {
        this.prettyXML = prettyXML;
        this.propertyChange("prettyXML", this.prettyXML, this.prettyXML, false);
    }

    @Component.PropertyGetter(value="gridSize", bindable=false, description="The grid size in pixels.")
    public int getGridSize() {
        return this.gridSize;
    }

    @Component.PropertySetter(value="gridSize", bindable=false, defaultValue="10", description="The grid size in pixels.")
    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
        this.propertyChange("gridSize", this.gridSize, this.gridSize, true);
    }

    @Component.PropertyGetter(value="gridEnabled", bindable=false, description="If true, the grid is enabled.")
    public boolean getGridEnabled() {
        return this.gridEnabled;
    }

    @Component.PropertySetter(value="gridEnabled", bindable=false, defaultValue="true", description="If true, the grid is enabled.")
    public void setGridEnabled(boolean gridEnabled) {
        this.gridEnabled = gridEnabled;
        this.propertyChange("gridEnabled", this.gridEnabled, this.gridEnabled, true);
    }

    @Component.PropertyGetter(value="portsEnabled", bindable=false, description="If true, ports are enabled.")
    public boolean isPortsEnabled() {
        return this.portsEnabled;
    }

    @Component.PropertySetter(value="portsEnabled", bindable=false, defaultValue="true", description="If true, ports are enabled.")
    public void setPortsEnabled(boolean portsEnabled) {
        this.portsEnabled = portsEnabled;
        this.propertyChange("portsEnabled", this.portsEnabled, this.portsEnabled, true);
    }
}

