/*
 * Decompiled with CFR 0.152.
 */
package org.fulib;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fulib.Fulib;
import org.fulib.classmodel.ClassModel;
import org.fulib.classmodel.Clazz;
import org.fulib.util.Generator4TableClassFile;
import org.fulib.yaml.YamlIdMap;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

public class TablesGenerator {
    private static Logger logger = Logger.getLogger(TablesGenerator.class.getName());
    private String customTemplateFile = null;

    public void generate(ClassModel model) {
        ClassModel oldModel = this.loadOldClassModel(model.getPackageSrcFolder());
        if (oldModel != null) {
            Fulib.generator().markModifiedElementsInOldModel(oldModel, model);
            this.generateClasses(oldModel);
        }
        this.generateClasses(model);
        this.saveClassmodel(model);
    }

    private void generateClasses(ClassModel model) {
        for (Clazz clazz : model.getClasses()) {
            new Generator4TableClassFile().setCustomTemplatesFile(this.getCustomTemplateFile()).generate(clazz);
        }
        Generator4TableClassFile generator4TableClassFile = new Generator4TableClassFile().setCustomTemplatesFile(this.getCustomTemplateFile());
        this.generatePrimitivTable(model, generator4TableClassFile, "int", "Integer");
        this.generatePrimitivTable(model, generator4TableClassFile, "long", "Long");
        this.generatePrimitivTable(model, generator4TableClassFile, "double", "Double");
        this.generatePrimitivTable(model, generator4TableClassFile, "float", "Float");
        STGroup group = generator4TableClassFile.createSTGroup("templates/StringTable.stg");
        ST st = group.getInstanceOf("StringTable");
        st.add("packageName", (Object)(model.getPackageName() + ".tables"));
        String result = st.render();
        this.writeFile(model.getPackageSrcFolder() + "/tables/StringTable.java", result);
    }

    private void generatePrimitivTable(ClassModel model, Generator4TableClassFile generator4TableClassFile, String primitivType, String objectType) {
        STGroup group = generator4TableClassFile.createSTGroup("templates/intTable.stg");
        ST st = group.getInstanceOf("intTable");
        st.add("packageName", (Object)(model.getPackageName() + ".tables"));
        st.add("primitiveType", (Object)primitivType);
        st.add("objectType", (Object)objectType);
        String result = st.render();
        this.writeFile(model.getPackageSrcFolder() + "/tables/" + primitivType + "Table.java", result);
    }

    public void writeFile(String fileName, String content) {
        try {
            Path path = Paths.get(fileName, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ClassModel loadOldClassModel(String modelFolder) {
        String fileName = modelFolder + "/tablesClassModel.yaml";
        try {
            Path path = Paths.get(fileName, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            byte[] bytes = Files.readAllBytes(path);
            String yamlString = new String(bytes);
            YamlIdMap idMap = new YamlIdMap(ClassModel.class.getPackage().getName());
            ClassModel model = (ClassModel)idMap.decode(yamlString);
            return model;
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, "\n   could not load " + fileName, e);
            return null;
        }
    }

    private void saveClassmodel(ClassModel model) {
        YamlIdMap idMap = new YamlIdMap(ClassModel.class.getPackage().getName());
        String yamlString = idMap.encode(model);
        try {
            String modelFolder = model.getPackageSrcFolder();
            String fileName = modelFolder + "/tablesClassModel.yaml";
            Files.createDirectories(Paths.get(modelFolder, new String[0]), new FileAttribute[0]);
            Files.write(Paths.get(fileName, new String[0]), yamlString.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getCustomTemplateFile() {
        return this.customTemplateFile;
    }

    public TablesGenerator setCustomTemplatesFile(String customFileName) {
        this.customTemplateFile = customFileName;
        return this;
    }

    static {
        logger.setLevel(Level.SEVERE);
    }
}

