/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.classmodel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import org.fulib.StrUtil;
import org.fulib.classmodel.Clazz;

public class ClassModel {
    public static final ArrayList<Clazz> EMPTY_classes = new ArrayList<Clazz>(){

        @Override
        public boolean add(Clazz value) {
            throw new UnsupportedOperationException("No direct add! Use xy.withClasses(obj)");
        }
    };
    private ArrayList<Clazz> classes = null;
    protected PropertyChangeSupport listeners = null;
    public static final String PROPERTY_packageName = "packageName";
    private String packageName;
    public static final String PROPERTY_mainJavaDir = "mainJavaDir";
    private String mainJavaDir;
    public static final String PROPERTY_defaultRoleType = "defaultRoleType";
    private String defaultRoleType;
    public static final String PROPERTY_defaultPropertyStyle = "defaultPropertyStyle";
    private String defaultPropertyStyle = "POJO";
    public static final String PROPERTY_classes = "classes";

    public ArrayList<Clazz> getClasses() {
        if (this.classes == null) {
            return EMPTY_classes;
        }
        return this.classes;
    }

    public Clazz getClazz(String name) {
        for (Clazz clazz : this.getClasses()) {
            if (!StrUtil.stringEquals(clazz.getName(), name)) continue;
            return clazz;
        }
        return null;
    }

    public ClassModel withClasses(Object ... value) {
        if (value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withClasses(i);
                }
                continue;
            }
            if (item instanceof Clazz) {
                if (this.classes == null) {
                    this.classes = new ArrayList();
                }
                if (this.classes.contains(item)) continue;
                this.classes.add((Clazz)item);
                ((Clazz)item).setModel(this);
                this.firePropertyChange(PROPERTY_classes, null, item);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this;
    }

    public ClassModel withoutClasses(Object ... value) {
        if (this.classes == null || value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withoutClasses(i);
                }
                continue;
            }
            if (!(item instanceof Clazz) || !this.classes.contains(item)) continue;
            this.classes.remove((Clazz)item);
            ((Clazz)item).setModel(null);
            this.firePropertyChange(PROPERTY_classes, item, null);
        }
        return this;
    }

    public String getPackageSrcFolder() {
        return this.getMainJavaDir() + "/" + this.getPackageName().replaceAll("\\.", "/");
    }

    public boolean firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listeners != null) {
            this.listeners.firePropertyChange(propertyName, oldValue, newValue);
            return true;
        }
        return false;
    }

    public boolean addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(listener);
        return true;
    }

    public boolean addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyName, listener);
        return true;
    }

    public boolean removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.removePropertyChangeListener(listener);
        }
        return true;
    }

    public boolean removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.removePropertyChangeListener(propertyName, listener);
        }
        return true;
    }

    public void removeYou() {
        this.withoutClasses(this.getClasses().clone());
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ClassModel setPackageName(String value) {
        if (value == null ? this.packageName != null : !value.equals(this.packageName)) {
            String oldValue = this.packageName;
            this.packageName = value;
            this.firePropertyChange(PROPERTY_packageName, oldValue, value);
        }
        return this;
    }

    public String getMainJavaDir() {
        return this.mainJavaDir;
    }

    public ClassModel setMainJavaDir(String value) {
        if (value == null ? this.mainJavaDir != null : !value.equals(this.mainJavaDir)) {
            String oldValue = this.mainJavaDir;
            this.mainJavaDir = value;
            this.firePropertyChange(PROPERTY_mainJavaDir, oldValue, value);
        }
        return this;
    }

    public String getDefaultRoleType() {
        return this.defaultRoleType;
    }

    public ClassModel setDefaultRoleType(String value) {
        if (value == null ? this.defaultRoleType != null : !value.equals(this.defaultRoleType)) {
            String oldValue = this.defaultRoleType;
            this.defaultRoleType = value;
            this.firePropertyChange(PROPERTY_defaultRoleType, oldValue, value);
        }
        return this;
    }

    public String getDefaultPropertyStyle() {
        return this.defaultPropertyStyle;
    }

    public ClassModel setDefaultPropertyStyle(String value) {
        if (value == null ? this.defaultPropertyStyle != null : !value.equals(this.defaultPropertyStyle)) {
            String oldValue = this.defaultPropertyStyle;
            this.defaultPropertyStyle = value;
            this.firePropertyChange(PROPERTY_defaultPropertyStyle, oldValue, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" ").append(this.getPackageName());
        result.append(" ").append(this.getMainJavaDir());
        result.append(" ").append(this.getDefaultRoleType());
        result.append(" ").append(this.getDefaultPropertyStyle());
        return result.substring(1);
    }
}

