/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.diagnostic;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.tools.Diagnostic;
import org.fulib.scenarios.diagnostic.Position;

public class Marker
implements Diagnostic<String>,
Comparable<Marker> {
    public static final String BUNDLE_NAME = "org.fulib.scenarios.diagnostic.messages";
    private final Diagnostic.Kind kind;
    private final Position position;
    private final String code;
    private final Object[] args;
    private List<Marker> notes;

    public Marker(Diagnostic.Kind kind, Position position, String code, Object ... args) {
        Objects.requireNonNull(position, "position");
        this.kind = kind;
        this.position = position;
        this.code = code;
        this.args = args;
    }

    private static String localize(String key) {
        return Marker.localize(Locale.getDefault(), key);
    }

    private static String localize(Locale locale, String key) {
        return ResourceBundle.getBundle(BUNDLE_NAME, locale).getString(key);
    }

    public static String localize(String key, Object ... args) {
        return Marker.localize(Locale.getDefault(), key, args);
    }

    public static String localize(Locale locale, String key, Object ... args) {
        return String.format(Marker.localize(locale, key), args);
    }

    public static Marker error(Position position, String code, Object ... args) {
        return new Marker(Diagnostic.Kind.ERROR, position, code, args);
    }

    public static Marker warning(Position position, String code, Object ... args) {
        return new Marker(Diagnostic.Kind.WARNING, position, code, args);
    }

    public static Marker note(Position position, String code, Object ... args) {
        return new Marker(Diagnostic.Kind.NOTE, position, code, args);
    }

    @Override
    public Diagnostic.Kind getKind() {
        return this.kind;
    }

    public Position getPositionObject() {
        return this.position;
    }

    @Override
    public String getSource() {
        return this.position.getSourceName();
    }

    @Override
    public long getPosition() {
        return this.position.getStartOffset();
    }

    @Override
    public long getStartPosition() {
        return this.position.getStartOffset();
    }

    @Override
    public long getEndPosition() {
        return this.position.getEndOffset();
    }

    @Override
    public long getLineNumber() {
        return this.position.getLineNumber();
    }

    @Override
    public long getColumnNumber() {
        return this.position.getColumnNumber();
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public List<Marker> getNotes() {
        return this.notes != null ? this.notes : (this.notes = new ArrayList<Marker>());
    }

    public Marker note(Marker marker) {
        this.getNotes().add(marker);
        return this;
    }

    @Override
    public String getMessage(Locale locale) {
        return Marker.localize(locale, this.code, this.args);
    }

    public void print(PrintWriter out) {
        out.print(this.getSource());
        out.print(':');
        out.print(this.getLineNumber());
        out.print(':');
        out.print(this.getColumnNumber());
        out.print(": ");
        out.print(this.getKind().name().toLowerCase());
        out.print(": ");
        String message = this.getLocalizedMessage();
        int newlineIndex = message.indexOf(10);
        if (newlineIndex >= 0) {
            out.print(message.substring(0, newlineIndex));
        } else {
            out.print(message);
        }
        out.print(" [");
        out.print(this.code);
        out.println(']');
        if (newlineIndex >= 0) {
            out.println(message.substring(newlineIndex + 1));
        }
        if (this.notes != null) {
            for (Marker note : this.notes) {
                note.print(out);
            }
        }
    }

    @Override
    public int compareTo(Marker o) {
        return Long.compare(this.getPosition(), o.getPosition());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Marker)) {
            return false;
        }
        Marker that = (Marker)o;
        return this.kind == that.kind && this.position.equals(that.position) && this.code.equals(that.code) && Arrays.equals(this.args, that.args) && Objects.equals(this.notes, that.notes);
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = 31 * result + this.position.hashCode();
        result = 31 * result + this.code.hashCode();
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + Objects.hashCode(this.notes);
        return result;
    }
}

