/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.type.ClassType;
import org.fulib.scenarios.tool.ClassModelVisitor;
import org.fulib.scenarios.tool.ScenarioCompiler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class LibraryHelper {
    public static void loadLibraries(ScenarioCompiler compiler) {
        for (String entry : compiler.getConfig().getClasspath()) {
            LibraryHelper.loadLibrary(entry, compiler);
        }
    }

    private static void loadLibrary(String classpathEntry, ScenarioCompiler compiler) {
        if (classpathEntry.endsWith(".jar")) {
            LibraryHelper.loadJarLibrary(classpathEntry, compiler);
        } else {
            LibraryHelper.loadDirLibrary(classpathEntry, compiler);
        }
    }

    private static void loadDirLibrary(String src, ScenarioCompiler compiler) {
        for (String packageName : compiler.getConfig().getImports()) {
            String packageDir = packageName.replace('.', '/');
            File[] files = new File(src, packageDir).listFiles();
            if (files == null) {
                return;
            }
            ScenarioGroup scenarioGroup = compiler.resolveGroup(packageDir);
            for (File file : files) {
                if (!file.isFile()) continue;
                LibraryHelper.loadFile(compiler, scenarioGroup, file);
            }
        }
    }

    private static void loadFile(ScenarioCompiler compiler, ScenarioGroup scenarioGroup, File file) {
        String fileName = file.getName();
        if (fileName.endsWith(".class") && fileName.indexOf(36) < 0) {
            try (FileInputStream data = new FileInputStream(file);){
                LibraryHelper.loadClass(scenarioGroup, data);
            }
            catch (Exception e) {
                e.printStackTrace(compiler.getErr());
            }
        }
    }

    private static void loadJarLibrary(String src, ScenarioCompiler compiler) {
        try (JarFile jarFile = new JarFile(src);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                LibraryHelper.loadJarEntry(compiler, jarFile, entry);
            }
        }
        catch (IOException e) {
            e.printStackTrace(compiler.getErr());
        }
    }

    private static void loadJarEntry(ScenarioCompiler compiler, JarFile jarFile, JarEntry entry) throws IOException {
        String entryName = entry.getName();
        if (!entryName.endsWith(".class") || entryName.indexOf(36) >= 0) {
            return;
        }
        int slashIndex = entryName.lastIndexOf(47);
        if (slashIndex < 0) {
            return;
        }
        int beginIndex = entryName.charAt(0) == '/' ? 1 : 0;
        String packageDir = entryName.substring(beginIndex, slashIndex);
        String packageName = packageDir.replace('/', '.');
        if (!compiler.getConfig().getImports().contains(packageName)) {
            return;
        }
        ScenarioGroup scenarioGroup = compiler.resolveGroup(packageDir);
        try (InputStream stream = jarFile.getInputStream(entry);){
            LibraryHelper.loadClass(scenarioGroup, stream);
        }
    }

    public static void loadClass(ScenarioGroup group, InputStream data) throws IOException {
        ClassDecl classDecl = ClassDecl.of(group, null, null, new HashMap<String, AttributeDecl>(), new HashMap<String, AssociationDecl>(), new ArrayList<MethodDecl>());
        classDecl.setType(ClassType.of(classDecl));
        classDecl.setExternal(true);
        ClassReader reader = new ClassReader(data);
        reader.accept((ClassVisitor)new ClassModelVisitor(classDecl), 1);
        group.getClasses().put(classDecl.getName(), classDecl);
    }
}

