/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ParameterDecl;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.type.ClassType;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.diagnostic.Marker;
import org.fulib.scenarios.diagnostic.Position;
import org.fulib.scenarios.visitor.ExtractClassDecl;
import org.fulib.scenarios.visitor.TypeConversion;
import org.fulib.scenarios.visitor.describe.DeclDescriber;

public class DeclResolver {
    protected static final String ENCLOSING_CLASS = "<enclosing:class>";

    static ClassDecl getEnclosingClass(Scope scope) {
        return (ClassDecl)scope.resolve(ENCLOSING_CLASS);
    }

    static ClassDecl resolveClass(Scope scope, String name, Position position) {
        Decl resolved = scope.resolve(name);
        if (resolved instanceof ClassDecl) {
            return (ClassDecl)resolved;
        }
        if (resolved != null) {
            scope.report(Marker.warning(position, "class.name.shadow.other.decl", name, DeclResolver.kindString(resolved)));
        }
        ClassDecl decl = ClassDecl.of(null, name, null, new LinkedHashMap<String, AttributeDecl>(), new LinkedHashMap<String, AssociationDecl>(), new ArrayList<MethodDecl>());
        decl.setPosition(position);
        decl.setExternal(DeclResolver.getEnclosingClass(scope).getExternal());
        decl.setType(ClassType.of(decl));
        scope.add(decl);
        return decl;
    }

    private static MethodDecl getMethod(ClassDecl owner, String name) {
        for (MethodDecl decl : owner.getMethods()) {
            if (!name.equals(decl.getName())) continue;
            return decl;
        }
        return null;
    }

    static MethodDecl resolveMethod(Scope scope, Position position, ClassDecl owner, String name) {
        MethodDecl existing = DeclResolver.getMethod(owner, name);
        return existing != null ? existing : DeclResolver.createMethod(scope, position, owner, name);
    }

    private static MethodDecl createMethod(Scope scope, Position position, ClassDecl owner, String name) {
        if (owner.getExternal()) {
            scope.report(Marker.error(position, "method.unresolved.external", name, owner.getName()));
        } else if (owner.getFrozen()) {
            scope.report(Marker.error(position, "method.unresolved.frozen", name, owner.getName()));
        }
        return DeclResolver.createMethod(position, owner, name);
    }

    private static MethodDecl createMethod(Position position, ClassDecl owner, String name) {
        SentenceList body = SentenceList.of(new ArrayList<Sentence>());
        MethodDecl decl = MethodDecl.of(owner, name, new ArrayList<ParameterDecl>(), null, body);
        decl.setPosition(position);
        owner.getMethods().add(decl);
        return decl;
    }

    static Name getAttributeOrAssociation(Scope scope, Expr receiver, Name name) {
        Type type = receiver.getType();
        return DeclResolver.getAttributeOrAssociation(scope, type, name);
    }

    static Name getAttributeOrAssociation(Scope scope, Type owner, Name name) {
        if (owner == PrimitiveType.ERROR) {
            return name;
        }
        ClassDecl ownerClass = owner.accept(ExtractClassDecl.INSTANCE, null);
        if (ownerClass != null) {
            return DeclResolver.getAttributeOrAssociation(scope, ownerClass, name);
        }
        scope.report(Marker.error(name.getPosition(), "property.unresolved.primitive", owner.getDescription(), name.getValue()));
        return name;
    }

    static Name getAttributeOrAssociation(Scope scope, ClassDecl owner, Name name) {
        if (name.getDecl() != null) {
            return name;
        }
        String nameValue = name.getValue();
        Decl decl = DeclResolver.getAttributeOrAssociation(owner, nameValue);
        if (decl != null) {
            return ResolvedName.of(decl);
        }
        scope.report(Marker.error(name.getPosition(), "property.unresolved", owner.getName(), nameValue));
        return name;
    }

    static Decl getAttributeOrAssociation(ClassDecl owner, String name) {
        AttributeDecl attribute = owner.getAttributes().get(name);
        return attribute != null ? attribute : (Decl)owner.getAssociations().get(name);
    }

    static Decl resolveAttributeOrAssociation(Scope scope, ClassDecl classDecl, String attributeName, Expr rhs, Position position) {
        Type attributeType = rhs.getType();
        if (attributeType instanceof ListType) {
            Type otherType = ((ListType)attributeType).getElementType();
            if (otherType instanceof ClassType) {
                return DeclResolver.resolveAssociation(scope, classDecl, attributeName, 42, ((ClassType)otherType).getClassDecl(), position);
            }
            return DeclResolver.resolveAttribute(scope, classDecl, attributeName, attributeType, position);
        }
        if (attributeType instanceof ClassType) {
            return DeclResolver.resolveAssociation(scope, classDecl, attributeName, 1, ((ClassType)attributeType).getClassDecl(), position);
        }
        return DeclResolver.resolveAttribute(scope, classDecl, attributeName, attributeType, position);
    }

    static Decl resolveAttribute(Scope scope, ClassDecl owner, String name, Type type, Position position) {
        AttributeDecl existingAttribute = owner.getAttributes().get(name);
        if (existingAttribute != null) {
            Type existingType = existingAttribute.getType();
            if (type != PrimitiveType.ERROR && existingType != PrimitiveType.ERROR && !TypeConversion.isConvertible(type, existingType)) {
                String newDesc = DeclDescriber.describeAttribute(type);
                scope.report(DeclResolver.conflict(position, owner, name, existingAttribute, newDesc));
            }
            return existingAttribute;
        }
        AssociationDecl existingAssociation = owner.getAssociations().get(name);
        if (existingAssociation != null) {
            String newDesc = DeclDescriber.describeAttribute(type);
            scope.report(DeclResolver.conflict(position, owner, name, existingAssociation, newDesc));
            return existingAssociation;
        }
        return DeclResolver.createAttribute(scope, position, owner, name, type);
    }

    private static AttributeDecl createAttribute(Scope scope, Position position, ClassDecl owner, String name, Type type) {
        if (owner.getExternal()) {
            scope.report(Marker.error(position, "attribute.unresolved.external", name, owner.getName()));
        } else if (owner.getFrozen()) {
            scope.report(Marker.error(position, "attribute.unresolved.frozen", name, owner.getName()));
        }
        return DeclResolver.createAttribute(position, owner, name, type);
    }

    private static AttributeDecl createAttribute(Position position, ClassDecl owner, String name, Type type) {
        AttributeDecl attribute = AttributeDecl.of(owner, name, type);
        attribute.setPosition(position);
        owner.getAttributes().put(name, attribute);
        return attribute;
    }

    static AssociationDecl resolveAssociation(Scope scope, ClassDecl owner, String name, int cardinality, ClassDecl otherClass, Position position) {
        return DeclResolver.resolveAssociation(scope, owner, name, cardinality, otherClass, null, 0, position, null);
    }

    static AssociationDecl resolveAssociation(Scope scope, ClassDecl owner, String name, int cardinality, ClassDecl otherClass, String otherName, int otherCardinality, Position position, Position otherPosition) {
        AttributeDecl existingAttribute = owner.getAttributes().get(name);
        if (existingAttribute != null) {
            String newDesc = DeclDescriber.describeAssociation(cardinality, otherClass);
            scope.report(DeclResolver.conflict(position, owner, name, existingAttribute, newDesc));
            return null;
        }
        AssociationDecl existing = owner.getAssociations().get(name);
        if (existing != null) {
            if (existing.getTarget() != otherClass || existing.getCardinality() < cardinality) {
                String newDesc = DeclDescriber.describeAssociation(cardinality, otherClass);
                scope.report(DeclResolver.conflict(position, owner, name, existing, newDesc));
            } else if (otherName != null) {
                AssociationDecl other = existing.getOther();
                if (other == null) {
                    Marker error = Marker.error(otherPosition, "association.reverse.late", otherName, owner.getName(), name);
                    Marker note = DeclResolver.firstDeclaration(existing.getPosition(), owner, name);
                    scope.report(error.note(note));
                } else if (!otherName.equals(other.getName()) || otherCardinality != other.getCardinality()) {
                    String existingDesc = other.accept(DeclDescriber.INSTANCE, null);
                    String newDesc = DeclDescriber.describeAssociation(otherCardinality, owner);
                    Marker error = Marker.error(otherPosition, "association.reverse.conflict", owner.getName(), name, otherClass.getName(), other.getName(), existingDesc, otherClass.getName(), otherName, newDesc);
                    Marker note = DeclResolver.firstDeclaration(other.getPosition(), other.getOwner(), other.getName());
                    scope.report(error.note(note));
                }
            }
            return existing;
        }
        AssociationDecl association = DeclResolver.createAssociation(scope, position, owner, name, cardinality, otherClass);
        if (otherClass == owner && name.equals(otherName)) {
            if (cardinality != otherCardinality) {
                scope.report(Marker.error(position, "association.self.cardinality.mismatch", owner.getName(), name));
            }
            association.setOther(association);
        } else if (otherName != null) {
            AssociationDecl other = DeclResolver.createAssociation(scope, otherPosition, otherClass, otherName, otherCardinality, owner);
            association.setOther(other);
            other.setOther(association);
        }
        return association;
    }

    private static AssociationDecl createAssociation(Scope scope, Position position, ClassDecl owner, String name, int cardinality, ClassDecl target) {
        if (owner.getExternal()) {
            scope.report(Marker.error(position, "association.unresolved.external", name, owner.getName()));
        } else if (owner.getFrozen()) {
            scope.report(Marker.error(position, "association.unresolved.frozen", name, owner.getName()));
        }
        return DeclResolver.createAssociation(position, owner, name, cardinality, target);
    }

    private static AssociationDecl createAssociation(Position position, ClassDecl owner, String name, int cardinality, ClassDecl target) {
        Type type = DeclResolver.createType(cardinality, target);
        AssociationDecl association = AssociationDecl.of(owner, name, cardinality, target, type, null);
        association.setPosition(position);
        owner.getAssociations().put(association.getName(), association);
        return association;
    }

    private static Type createType(int cardinality, ClassDecl target) {
        return cardinality != 1 ? ListType.of(target.getType()) : target.getType();
    }

    static Marker firstDeclaration(Position position, ClassDecl owner, String name) {
        return Marker.note(position, "property.declaration.first", owner.getName(), name);
    }

    private static Marker conflict(Position position, ClassDecl owner, String name, Decl existing, String newDesc) {
        String existingDesc = existing.accept(DeclDescriber.INSTANCE, null);
        Marker error = Marker.error(position, "property.redeclaration.conflict", owner.getName(), name, existingDesc, newDesc);
        Marker note = DeclResolver.firstDeclaration(existing.getPosition(), owner, name);
        return error.note(note);
    }

    private static String kindString(Decl decl) {
        String simpleName = decl.getClass().getEnclosingClass().getSimpleName();
        String stripped = simpleName.endsWith("Decl") ? simpleName.substring(0, simpleName.length() - 4) : simpleName;
        String key = stripped.toLowerCase() + ".kind";
        return Marker.localize(key, new Object[0]);
    }
}

