/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ParameterDecl;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.ErrorExpr;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.access.ExampleAccess;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.call.CreationExpr;
import org.fulib.scenarios.ast.expr.collection.FilterExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.collection.MapAccessExpr;
import org.fulib.scenarios.ast.expr.collection.RangeExpr;
import org.fulib.scenarios.ast.expr.conditional.AttributeCheckExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperator;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperatorExpr;
import org.fulib.scenarios.ast.expr.conditional.PredicateOperatorExpr;
import org.fulib.scenarios.ast.expr.operator.BinaryExpr;
import org.fulib.scenarios.ast.expr.primary.AnswerLiteral;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.expr.primary.StringLiteral;
import org.fulib.scenarios.ast.scope.DelegatingScope;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.diagnostic.Marker;
import org.fulib.scenarios.diagnostic.Position;
import org.fulib.scenarios.visitor.ExtractClassDecl;
import org.fulib.scenarios.visitor.GetAnswerSentence;
import org.fulib.scenarios.visitor.Namer;
import org.fulib.scenarios.visitor.TypeComparer;
import org.fulib.scenarios.visitor.TypeConversion;
import org.fulib.scenarios.visitor.resolve.DeclResolver;
import org.fulib.scenarios.visitor.resolve.SentenceResolver;
import org.fulib.scenarios.visitor.resolve.TypeResolver;

public enum ExprResolver implements Expr.Visitor<Scope, Expr>
{
    INSTANCE;


    @Override
    public Expr visit(Expr expr, Scope par) {
        return expr;
    }

    @Override
    public Expr visit(AnswerLiteral answerLiteral, Scope par) {
        Decl answerVar = par.resolve("<answer-var>");
        if (answerVar == null) {
            par.report(Marker.error(answerLiteral.getPosition(), "answer.unresolved", new Object[0]));
            return ErrorExpr.of(PrimitiveType.ERROR);
        }
        return NameAccess.of(ResolvedName.of(answerVar));
    }

    @Override
    public Expr visit(NameAccess nameAccess, Scope par) {
        if (nameAccess.getName() instanceof UnresolvedName) {
            UnresolvedName unresolvedName = (UnresolvedName)nameAccess.getName();
            String unresolvedValue = unresolvedName.getValue();
            Decl target = par.resolve(unresolvedValue);
            if (target == null) {
                StringLiteral stringLiteral = StringLiteral.of(unresolvedName.getText());
                stringLiteral.setPosition(unresolvedName.getPosition());
                return stringLiteral;
            }
            nameAccess.setName(ResolvedName.of(target));
        }
        return nameAccess;
    }

    @Override
    public Expr visit(AttributeAccess attributeAccess, Scope par) {
        Expr receiver = attributeAccess.getReceiver().accept(this, par);
        attributeAccess.setReceiver(receiver);
        Type receiverType = receiver.getType();
        if (receiverType instanceof ListType) {
            Type elementType = ((ListType)receiverType).getElementType();
            Name resolvedName = DeclResolver.getAttributeOrAssociation(par, elementType, attributeAccess.getName());
            return MapAccessExpr.of(resolvedName, receiver);
        }
        attributeAccess.setName(DeclResolver.getAttributeOrAssociation(par, receiver, attributeAccess.getName()));
        return attributeAccess;
    }

    @Override
    public Expr visit(ExampleAccess exampleAccess, Scope par) {
        exampleAccess.setExpr(exampleAccess.getExpr().accept(this, par));
        return exampleAccess;
    }

    @Override
    public Expr visit(CreationExpr creationExpr, Scope par) {
        creationExpr.setType(creationExpr.getType().accept(TypeResolver.INSTANCE, par));
        ClassDecl classDecl = creationExpr.getType().accept(ExtractClassDecl.INSTANCE, null);
        for (NamedExpr namedExpr : creationExpr.getAttributes()) {
            SentenceResolver.resolveHasNamedExpr(namedExpr, classDecl, par);
        }
        return creationExpr;
    }

    @Override
    public Expr visit(CallExpr callExpr, Scope par) {
        Expr expr;
        ParameterDecl thisParameter;
        List<NamedExpr> arguments = callExpr.getArguments();
        Expr receiver = callExpr.getReceiver();
        if (receiver != null) {
            receiver = receiver.accept(this, par);
        } else {
            Decl thisDecl = par.resolve("this");
            receiver = NameAccess.of(ResolvedName.of(thisDecl));
        }
        callExpr.setReceiver(receiver);
        for (NamedExpr argument : arguments) {
            argument.setExpr(argument.getExpr().accept(this, par));
        }
        Type receiverType = callExpr.getReceiver().getType();
        ClassDecl receiverClass = receiverType.accept(ExtractClassDecl.INSTANCE, null);
        String methodName = callExpr.getName().getValue();
        Position position = callExpr.getName().getPosition();
        MethodDecl method = DeclResolver.resolveMethod(par, position, receiverClass, methodName);
        List<ParameterDecl> parameters = method.getParameters();
        final HashMap<String, ParameterDecl> decls = new HashMap<String, ParameterDecl>();
        ResolvedName resolvedName = ResolvedName.of(method);
        resolvedName.setPosition(position);
        callExpr.setName(resolvedName);
        if (method.getParameters().isEmpty()) {
            thisParameter = ParameterDecl.of(method, "this", receiverClass.getType());
            parameters.add(thisParameter);
            for (NamedExpr argument : arguments) {
                String name = argument.getName().getValue();
                Expr expr2 = argument.getExpr();
                Type type = expr2.getType();
                ParameterDecl param = ParameterDecl.of(method, name, type);
                parameters.add(param);
                argument.setName(ResolvedName.of(param));
                decls.put(name, param);
            }
        } else {
            Object args;
            thisParameter = parameters.get(0);
            for (int i = 1; i < parameters.size(); ++i) {
                ParameterDecl parameter = parameters.get(i);
                decls.put(parameter.getName(), parameter);
            }
            String params = parameters.stream().skip(1L).map(ParameterDecl::getName).collect(Collectors.joining(" "));
            if (!params.equals(args = arguments.stream().map(NamedExpr::getName).map(Name::getValue).collect(Collectors.joining(" ")))) {
                Marker error = Marker.error(callExpr.getPosition(), "call.mismatch.params.args", receiverClass.getName(), methodName, params, args);
                Marker note = DeclResolver.firstDeclaration(method.getPosition(), method.getOwner(), method.getName());
                par.report(error.note(note));
            }
            for (NamedExpr argument : arguments) {
                Type paramType;
                expr = argument.getExpr();
                Type type = expr.getType();
                String name = argument.getName().getValue();
                ParameterDecl param = (ParameterDecl)decls.get(name);
                if (param == null) continue;
                argument.setName(ResolvedName.of(param));
                if (type == PrimitiveType.ERROR || (paramType = param.getType()) == PrimitiveType.ERROR) continue;
                Expr converted = TypeConversion.convert(expr, paramType);
                if (converted != null) {
                    argument.setExpr(converted);
                    continue;
                }
                par.report(Marker.error(expr.getPosition(), "call.mismatch.type", paramType.getDescription(), type.getDescription()));
            }
        }
        decls.put("this", thisParameter);
        String receiverName = receiver.accept(Namer.INSTANCE, null);
        if (receiverName != null) {
            decls.put(receiverName, thisParameter);
        }
        for (NamedExpr argument : arguments) {
            String exprName;
            ParameterDecl param = (ParameterDecl)argument.getName().getDecl();
            if (param == null || (exprName = (expr = argument.getExpr()).accept(Namer.INSTANCE, null)) == null) continue;
            decls.put(exprName, param);
        }
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                Decl decl = (Decl)decls.get(name);
                return decl != null ? decl : super.resolve(name);
            }
        };
        callExpr.getBody().accept(SentenceResolver.INSTANCE, scope);
        ExprResolver.inferMethodType(method, callExpr, par);
        method.getBody().getItems().addAll(callExpr.getBody().getItems());
        return callExpr;
    }

    private static void inferMethodType(MethodDecl method, CallExpr callExpr, Scope par) {
        AnswerSentence answerSentence = callExpr.getBody().accept(GetAnswerSentence.INSTANCE, null);
        Type methodType = method.getType();
        if (methodType == null) {
            PrimitiveType returnType = answerSentence != null ? answerSentence.getResult().getType() : PrimitiveType.VOID;
            method.setType(returnType);
            return;
        }
        if (answerSentence == null) {
            return;
        }
        Expr result = answerSentence.getResult();
        Expr converted = TypeConversion.convert(result, methodType);
        if (converted != null) {
            answerSentence.setResult(converted);
            return;
        }
        Type resultType = result.getType();
        par.report(Marker.error(result.getPosition(), "call.return.type", resultType.getDescription(), method.getName(), methodType.getDescription()));
    }

    @Override
    public Expr visit(BinaryExpr binaryExpr, Scope par) {
        binaryExpr.setLhs(binaryExpr.getLhs().accept(this, par));
        binaryExpr.setRhs(binaryExpr.getRhs().accept(this, par));
        return binaryExpr;
    }

    @Override
    public Expr visit(AttributeCheckExpr attributeCheckExpr, Scope par) {
        Expr receiver = attributeCheckExpr.getReceiver();
        if (receiver == null) {
            Decl predicateReceiver = par.resolve("<predicate-receiver>");
            if (predicateReceiver == null) {
                par.report(Marker.error(attributeCheckExpr.getPosition(), "attribute-check.receiver.missing", new Object[0]));
                receiver = ErrorExpr.of(PrimitiveType.ERROR);
            } else {
                receiver = NameAccess.of(ResolvedName.of(predicateReceiver));
            }
        }
        Expr expected = attributeCheckExpr.getValue();
        Name attribute = attributeCheckExpr.getAttribute();
        AttributeAccess access = AttributeAccess.of(attribute, receiver);
        ConditionalOperatorExpr condOp = ConditionalOperatorExpr.of(access, ConditionalOperator.IS, expected);
        return condOp.accept(this, par);
    }

    @Override
    public Expr visit(ConditionalOperatorExpr conditionalOperatorExpr, Scope par) {
        Expr rhs = conditionalOperatorExpr.getRhs().accept(this, par);
        conditionalOperatorExpr.setRhs(rhs);
        Expr lhs = conditionalOperatorExpr.getLhs();
        if (lhs != null) {
            conditionalOperatorExpr.setLhs(lhs.accept(this, par));
        } else {
            Decl predicateReceiver = par.resolve("<predicate-receiver>");
            if (predicateReceiver == null) {
                par.report(Marker.error(conditionalOperatorExpr.getPosition(), "conditional.lhs.missing", new Object[0]));
                conditionalOperatorExpr.setLhs(ErrorExpr.of(rhs.getType()));
            } else {
                conditionalOperatorExpr.setLhs(NameAccess.of(ResolvedName.of(predicateReceiver)));
            }
        }
        return conditionalOperatorExpr;
    }

    @Override
    public Expr visit(PredicateOperatorExpr predicateOperatorExpr, Scope par) {
        Expr lhs = predicateOperatorExpr.getLhs();
        if (lhs != null) {
            predicateOperatorExpr.setLhs(lhs.accept(this, par));
        } else {
            Decl predicateReceiver = par.resolve("<predicate-receiver>");
            if (predicateReceiver == null) {
                par.report(Marker.error(predicateOperatorExpr.getPosition(), "predicate.lhs.missing", new Object[0]));
                predicateOperatorExpr.setLhs(ErrorExpr.of(PrimitiveType.ERROR));
            } else {
                predicateOperatorExpr.setLhs(NameAccess.of(ResolvedName.of(predicateReceiver)));
            }
        }
        return predicateOperatorExpr;
    }

    @Override
    public Expr visit(ListExpr listExpr, Scope par) {
        listExpr.getElements().replaceAll(it -> it.accept(this, par));
        return listExpr;
    }

    @Override
    public Expr visit(RangeExpr rangeExpr, Scope par) {
        Expr start = rangeExpr.getStart().accept(this, par);
        Expr end = rangeExpr.getEnd().accept(this, par);
        rangeExpr.setStart(start);
        rangeExpr.setEnd(end);
        Type startType = start.getType();
        Type endType = end.getType();
        if (!TypeComparer.equals(startType, endType)) {
            par.report(Marker.error(rangeExpr.getPosition(), "range.element.type.mismatch", startType.getDescription(), endType.getDescription()));
        }
        if (!PrimitiveType.isIntegral(startType)) {
            par.report(Marker.error(start.getPosition(), "range.element.type.unsupported", startType.getDescription()));
        }
        if (!PrimitiveType.isIntegral(endType)) {
            par.report(Marker.error(end.getPosition(), "range.element.type.unsupported", endType.getDescription()));
        }
        return rangeExpr;
    }

    @Override
    public Expr visit(FilterExpr filterExpr, Scope par) {
        Expr source = filterExpr.getSource().accept(this, par);
        filterExpr.setSource(source);
        Type sourceType = source.getType();
        Type elementType = ((ListType)sourceType).getElementType();
        final VarDecl it = VarDecl.of("it", elementType, null);
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                return "<predicate-receiver>".equals(name) ? it : super.resolve(name);
            }
        };
        Expr predicate = filterExpr.getPredicate().accept(this, scope);
        filterExpr.setPredicate(ExprResolver.checkConditional(predicate, par));
        return filterExpr;
    }

    static Expr checkConditional(Expr predicate, Scope par) {
        Expr converted = TypeConversion.convert(predicate, PrimitiveType.BOOLEAN);
        if (converted != null) {
            return converted;
        }
        par.report(Marker.error(predicate.getPosition(), "conditional.type", predicate.getType().getDescription()));
        return predicate;
    }
}

