/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.fulib.Generator;
import org.fulib.Parser;
import org.fulib.StrUtil;
import org.fulib.classmodel.AssocRole;
import org.fulib.classmodel.Attribute;
import org.fulib.classmodel.Clazz;
import org.fulib.classmodel.FileFragmentMap;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.StringRenderer;

public class Generator4TableClassFile {
    private String customTemplatesFile;

    public void generate(Clazz clazz) {
        String classFileName = clazz.getModel().getPackageSrcFolder() + "/tables/" + clazz.getName() + "Table.java";
        FileFragmentMap fragmentMap = Parser.parse(classFileName);
        this.generatePackageDecl(clazz, fragmentMap);
        this.generateClassDecl(clazz, fragmentMap);
        this.generateConstructor(clazz, fragmentMap);
        this.generateStandardAttributes(clazz, fragmentMap);
        this.generateAttributes(clazz, fragmentMap);
        this.generateAssociations(clazz, fragmentMap);
        this.generateSelectColumns(clazz, fragmentMap);
        this.generateAddColumn(clazz, fragmentMap);
        this.generateFilter(clazz, fragmentMap);
        this.generateToSet(clazz, fragmentMap);
        this.generateToString(clazz, fragmentMap);
        fragmentMap.add("classEnd", "}", 1);
        if (clazz.getModified() && fragmentMap.classBodyIsEmpty(fragmentMap)) {
            Path path = Paths.get(classFileName, new String[0]);
            try {
                Files.deleteIfExists(path);
                Logger.getLogger(Generator.class.getName()).info("\n   deleting empty file " + classFileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            fragmentMap.writeFile();
        }
    }

    private void generatePackageDecl(Clazz clazz, FileFragmentMap fragmentMap) {
        String result = String.format("package %s;", clazz.getModel().getPackageName() + ".tables");
        fragmentMap.add("package", result, 2);
    }

    private void generateClassDecl(Clazz clazz, FileFragmentMap fragmentMap) {
        STGroup group = this.createSTGroup("templates/classDecl.stg");
        ST st = group.getInstanceOf("classDecl");
        st.add("name", (Object)(clazz.getName() + "Table"));
        st.add("superClass", clazz.getSuperClass() != null ? clazz.getSuperClass().getName() + "Table" : null);
        String result = st.render();
        fragmentMap.add("class", result, 2);
    }

    private void generateConstructor(Clazz clazz, FileFragmentMap fragmentMap) {
        STGroup group = this.createSTGroup("templates/tableConstructor.stg");
        ST st = group.getInstanceOf("constructor");
        st.add("className", (Object)clazz.getName());
        String result = st.render();
        fragmentMap.add("constructor:" + clazz.getName() + "Table(" + clazz.getName() + "...)", result, 2, clazz.getModified());
    }

    private void generateStandardAttributes(Clazz clazz, FileFragmentMap fragmentMap) {
        STGroup group = this.createSTGroup("templates/attributes.stg");
        fragmentMap.add("import:java.util.ArrayList", "import java.util.ArrayList;", 1);
        fragmentMap.add("import:java.util.LinkedHashMap", "import java.util.LinkedHashMap;", 1);
        ArrayList<Attribute> standardAttributes = new ArrayList<Attribute>();
        standardAttributes.add(new Attribute().setName("table").setType("ArrayList<ArrayList<Object>>").setInitialization("new ArrayList<>()"));
        standardAttributes.add(new Attribute().setName("columnName").setType("String").setInitialization("null"));
        standardAttributes.add(new Attribute().setName("columnMap").setType("LinkedHashMap<String, Integer>").setInitialization("new LinkedHashMap<>()"));
        for (Attribute attr : standardAttributes) {
            ST attrTemplate = group.getInstanceOf("attrDecl");
            attrTemplate.add("type", (Object)attr.getType());
            attrTemplate.add("name", (Object)attr.getName());
            attrTemplate.add("value", (Object)attr.getInitialization());
            String result = attrTemplate.render();
            fragmentMap.add("attribute:" + attr.getName(), result, 2, clazz.getModified());
            attrTemplate = group.getInstanceOf("attrGet");
            attrTemplate.add("type", (Object)attr.getType());
            attrTemplate.add("name", (Object)attr.getName());
            result = attrTemplate.render();
            fragmentMap.add("method:get" + StrUtil.cap(attr.getName()) + "()", result, 2, attr.getModified());
            attrTemplate = group.getInstanceOf("simpleAttrSet");
            attrTemplate.add("class", (Object)(clazz.getName() + "Table"));
            attrTemplate.add("type", (Object)attr.getType());
            attrTemplate.add("name", (Object)attr.getName());
            result = attrTemplate.render();
            fragmentMap.add("method:set" + StrUtil.cap(attr.getName()) + "(" + attr.getType() + ")", result, 3, attr.getModified());
        }
    }

    private void generateAttributes(Clazz clazz, FileFragmentMap fragmentMap) {
        STGroup group = this.createSTGroup("templates/tablesAttributes.stg");
        for (Attribute attr : clazz.getAttributes()) {
            ST attrTemplate = group.getInstanceOf("expandMethod");
            attrTemplate.add("roleName", (Object)attr.getName());
            attrTemplate.add("typeName", (Object)attr.getType());
            attrTemplate.add("className", (Object)clazz.getName());
            String result = attrTemplate.render();
            fragmentMap.add("method:expand" + StrUtil.cap(attr.getName()) + "(String...)", result, 2, attr.getModified());
        }
    }

    private void generateAssociations(Clazz clazz, FileFragmentMap fragmentMap) {
        String fullClassName = clazz.getModel().getPackageName() + "." + clazz.getName();
        fragmentMap.add("import:" + fullClassName, "import " + fullClassName + ";", 1);
        STGroup group = this.createSTGroup("templates/tablesAssociations.stg");
        for (AssocRole role : clazz.getRoles()) {
            if (role.getName() == null) continue;
            String otherClassName = role.getOther().getClazz().getName();
            ST st = group.getInstanceOf("expandMethod");
            st.add("roleName", (Object)role.getName());
            st.add("toMany", (Object)(role.getCardinality() != 1 ? 1 : 0));
            st.add("className", (Object)clazz.getName());
            st.add("otherClassName", (Object)otherClassName);
            String result = st.render();
            fragmentMap.add("method:expand" + StrUtil.cap(role.getName()) + "(String...)", result, 2, role.getModified());
            st = group.getInstanceOf("hasMethod");
            st.add("roleName", (Object)role.getName());
            st.add("toMany", (Object)(role.getCardinality() != 1 ? 1 : 0));
            st.add("className", (Object)clazz.getName());
            st.add("otherClassName", (Object)otherClassName);
            result = st.render();
            fragmentMap.add("method:has" + StrUtil.cap(role.getName()) + "(" + otherClassName + "Table)", result, 2, role.getModified());
            fullClassName = clazz.getModel().getPackageName() + "." + otherClassName;
            fragmentMap.add("import:" + fullClassName, "import " + fullClassName + ";", 1);
        }
    }

    private void generateSelectColumns(Clazz clazz, FileFragmentMap fragmentMap) {
        fragmentMap.add("import:java.util.Arrays", "import java.util.Arrays;", 1);
        STGroup group = this.createSTGroup("templates/tablesSelectColumns.stg");
        ST st = group.getInstanceOf("selectColumns");
        st.add("className", (Object)clazz.getName());
        String result = st.render();
        fragmentMap.add("method:selectColumns(String...)", result, 2, clazz.getModified());
        st = group.getInstanceOf("dropColumns");
        st.add("className", (Object)clazz.getName());
        result = st.render();
        fragmentMap.add("method:dropColumns(String...)", result, 2, clazz.getModified());
    }

    private void generateAddColumn(Clazz clazz, FileFragmentMap fragmentMap) {
        STGroup group = this.createSTGroup("templates/tablesSelectColumns.stg");
        ST st = group.getInstanceOf("addColumn");
        st.add("className", (Object)clazz.getName());
        String result = st.render();
        fragmentMap.add("method:addColumn(String,java.util.function.Function<java.util.LinkedHashMap<String,Object>,Object>)", result, 2, clazz.getModified());
    }

    private void generateFilter(Clazz clazz, FileFragmentMap fragmentMap) {
        fragmentMap.add("import:java.util.function.Predicate", "import java.util.function.Predicate;", 1);
        String result = "";
        STGroup group = this.createSTGroup("templates/tablesFilter.stg");
        ST st = group.getInstanceOf("filter");
        st.add("className", (Object)clazz.getName());
        result = st.render();
        boolean modified = clazz.getModified();
        if (clazz.getSuperClass() != null) {
            modified = true;
        }
        fragmentMap.add("method:filter(Predicate< " + clazz.getName() + " >)", result, 2, modified);
        st = group.getInstanceOf("filterRow");
        st.add("className", (Object)clazz.getName());
        result = st.render();
        fragmentMap.add("method:filterRow(Predicate<LinkedHashMap<String,Object> >)", result, 2, clazz.getModified());
    }

    private void generateToSet(Clazz clazz, FileFragmentMap fragmentMap) {
        fragmentMap.add("import:java.util.LinkedHashSet", "import java.util.LinkedHashSet;", 1);
        String result = "";
        STGroup group = this.createSTGroup("templates/tablesToSet.stg");
        ST st = group.getInstanceOf("toSet");
        st.add("className", (Object)clazz.getName());
        result = st.render();
        boolean modified = clazz.getModified();
        if (clazz.getSuperClass() != null) {
            modified = true;
        }
        fragmentMap.add("method:toSet()", result, 2, modified);
    }

    private void generateToString(Clazz clazz, FileFragmentMap fragmentMap) {
        String result = "";
        STGroup group = this.createSTGroup("templates/tablesToString.stg");
        ST st = group.getInstanceOf("toString");
        result = st.render();
        fragmentMap.add("method:toString()", result, 2, clazz.getModified());
    }

    public String getCustomTemplatesFile() {
        return this.customTemplatesFile;
    }

    public Generator4TableClassFile setCustomTemplatesFile(String customTemplateFile) {
        this.customTemplatesFile = customTemplateFile;
        return this;
    }

    public STGroup createSTGroup(String origFileName) {
        STGroupFile group;
        try {
            group = new STGroupFile(this.customTemplatesFile);
            STGroupFile origGroup = new STGroupFile(origFileName);
            group.importTemplates((STGroup)origGroup);
        }
        catch (Exception e) {
            group = new STGroupFile(origFileName);
        }
        group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        return group;
    }
}

