/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fulib.yaml.EventSource;

public class EventFiler {
    String historyFileName = null;
    private EventSource eventSource;

    public EventFiler(EventSource eventSource) {
        this.eventSource = eventSource;
    }

    public EventFiler setHistoryFileName(String historyFileName) {
        this.historyFileName = historyFileName;
        return this;
    }

    public String loadHistory() {
        File historyFile = new File(this.historyFileName);
        String content = null;
        try {
            byte[] bytes = new byte[(int)historyFile.length()];
            FileInputStream inputStream = new FileInputStream(historyFile);
            int read = ((InputStream)inputStream).read(bytes);
            content = new String(bytes);
            ((InputStream)inputStream).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return content;
    }

    public boolean storeHistory() {
        File historyFile = new File(this.historyFileName);
        String yaml = this.eventSource.encodeYaml();
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.historyFileName)));
            out.print(yaml);
            out.close();
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, "could not write to historyFile " + this.historyFileName, e);
            return false;
        }
        return true;
    }

    public EventFiler startEventLogging() {
        this.eventSource.addEventListener(map -> this.storeEvent((LinkedHashMap<String, String>)map));
        return this;
    }

    public void storeEvent(LinkedHashMap<String, String> event) {
        File historyFile;
        String dirName;
        File dataDir;
        Objects.requireNonNull(this.historyFileName);
        int dirEndPos = this.historyFileName.lastIndexOf(47);
        if (dirEndPos > 0 && !(dataDir = new File(dirName = this.historyFileName.substring(0, dirEndPos))).exists()) {
            dataDir.mkdirs();
        }
        if (!(historyFile = new File(this.historyFileName)).exists()) {
            try {
                historyFile.createNewFile();
            }
            catch (IOException e) {
                Logger.getGlobal().log(Level.SEVERE, "could not create historyFile " + this.historyFileName, e);
            }
        }
        String yaml = EventSource.encodeYaml(event);
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.historyFileName, true)));
            out.print(yaml);
            out.close();
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, "could not write to historyFile " + this.historyFileName, e);
        }
    }
}

