/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;

public class Yamler {
    private String yaml;
    private StringTokenizer tokenizer;
    private String lookAheadToken;
    private String currentToken;
    private int currentPos;
    private int lookAheadPos;

    public Yamler(String yaml) {
        this.yaml = yaml;
        this.tokenizer = new StringTokenizer(yaml);
        this.lookAheadToken = null;
        this.nextToken();
        this.nextToken();
    }

    public Yamler() {
    }

    public LinkedHashMap<String, String> decode(String yaml) {
        this.yaml = yaml;
        this.tokenizer = new StringTokenizer(yaml);
        this.lookAheadToken = null;
        this.nextToken();
        this.nextToken();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        while (this.currentToken != null && this.currentToken.endsWith(":")) {
            String attrName = this.stripColon(this.currentToken);
            this.nextToken();
            String value = "";
            int valueStart = this.currentPos;
            while (this.currentToken != null && !this.currentToken.endsWith(":")) {
                value = yaml.substring(valueStart, this.currentPos + this.currentToken.length());
                this.nextToken();
            }
            result.put(attrName, value);
        }
        return result;
    }

    public ArrayList<LinkedHashMap<String, String>> decodeList(String yaml) {
        this.yaml = yaml;
        this.tokenizer = new StringTokenizer(yaml);
        this.lookAheadToken = null;
        this.nextToken();
        this.nextToken();
        ArrayList<LinkedHashMap<String, String>> result = new ArrayList<LinkedHashMap<String, String>>();
        while (this.currentToken != null && this.currentToken.equals("-")) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            result.add(map);
            this.nextToken();
            while (this.currentToken != null && this.currentToken.endsWith(":")) {
                String key = this.stripColon(this.currentToken);
                this.nextToken();
                String value = this.currentToken;
                this.nextToken();
                map.put(key, value);
            }
        }
        return result;
    }

    public String nextToken() {
        this.currentToken = this.lookAheadToken;
        this.currentPos = this.lookAheadPos;
        if (this.tokenizer.hasMoreTokens()) {
            this.lookAheadToken = this.tokenizer.nextToken();
            int currentLength = 0;
            if (this.currentToken != null) {
                currentLength = this.currentToken.length();
            }
            this.lookAheadPos = this.yaml.indexOf(this.lookAheadToken, this.lookAheadPos + currentLength);
        } else {
            this.lookAheadToken = null;
        }
        if (this.lookAheadToken != null && this.lookAheadToken.startsWith("\"")) {
            int stringStartPos = this.lookAheadPos + 1;
            String subToken = this.lookAheadToken;
            int subTokenEnd = this.lookAheadPos + subToken.length();
            while (subTokenEnd < stringStartPos + 1 || (!subToken.endsWith("\"") || subToken.endsWith("\\\"")) && this.tokenizer.hasMoreTokens()) {
                subToken = this.tokenizer.nextToken();
                subTokenEnd = this.yaml.indexOf(subToken, subTokenEnd) + subToken.length();
            }
            this.lookAheadToken = this.yaml.substring(stringStartPos, subTokenEnd - 1);
            this.lookAheadToken = this.deEncapsulate(this.lookAheadToken);
        }
        return this.currentToken;
    }

    public String stripColon(String key) {
        String id = key;
        if (key.endsWith(":")) {
            id = key.substring(0, key.length() - 1);
        } else {
            this.printError("key does not end with ':' " + key);
        }
        return id;
    }

    public String getCurrentToken() {
        return this.currentToken;
    }

    public static String encapsulate(String value) {
        if (value.matches("[a-zA-Z0-9_\\.]+")) {
            return value;
        }
        value = value.replaceAll("\"", "\\\\\"");
        return "\"" + value + "\"";
    }

    String deEncapsulate(String value) {
        value = value.replaceAll("\\\\\"", "\"");
        return value;
    }

    void printError(String msg) {
        int startPos = this.currentPos;
        startPos = startPos >= 10 ? (startPos -= 10) : 0;
        int endPos = this.currentPos + 20;
        if (endPos >= this.yaml.length()) {
            endPos = this.yaml.length();
        }
        System.err.println(this.yaml.substring(startPos, this.currentPos) + "<--" + msg + "-->" + this.yaml.substring(this.currentPos, endPos));
    }

    public String getLookAheadToken() {
        return this.lookAheadToken;
    }

    public int getCurrentPos() {
        return this.currentPos;
    }

    public int getLookAheadPos() {
        return this.lookAheadPos;
    }
}

