/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.parser;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.fulib.StrUtil;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.parser.ASTListener;
import org.fulib.scenarios.parser.ScenarioParser;

public class Identifiers {
    public static String toUpperCamelCase(String text) {
        return Identifiers.joinCaps(Identifiers.splitCaps(text));
    }

    public static String toLowerCamelCase(String text) {
        return StrUtil.downFirstChar((String)Identifiers.toUpperCamelCase(text));
    }

    public static Stream<String> splitCaps(String text) {
        return Arrays.stream(text.split("[\\W_]+"));
    }

    public static String joinCaps(Stream<String> stream) {
        return stream.map(StrUtil::cap).collect(Collectors.joining());
    }

    static String cap(Token token) {
        return StrUtil.cap((String)token.getText());
    }

    static Stream<String> splitCaps(TerminalNode token) {
        return Identifiers.splitCaps(token.getText());
    }

    static String joinCaps(ScenarioParser.SimpleNameContext context) {
        return Identifiers.joinCaps(Identifiers.splitCaps(context.WORD()));
    }

    static String joinCaps(ScenarioParser.NameContext context) {
        return Identifiers.joinCaps(context.WORD().stream().flatMap(Identifiers::splitCaps));
    }

    static String varName(ScenarioParser.NameContext context) {
        return context == null ? null : StrUtil.downFirstChar((String)Identifiers.joinCaps(context));
    }

    static String varName(ScenarioParser.SimpleNameContext context) {
        return context == null ? null : StrUtil.downFirstChar((String)Identifiers.joinCaps(context));
    }

    static Name name(ScenarioParser.SimpleNameContext simpleName) {
        return simpleName == null ? null : Identifiers.name(Identifiers.varName(simpleName), simpleName);
    }

    static Name name(ScenarioParser.NameContext multiName) {
        return multiName == null ? null : Identifiers.name(Identifiers.varName(multiName), multiName);
    }

    private static Name name(String value, ParserRuleContext rule) {
        String text = ASTListener.inputText((ParseTree)rule);
        UnresolvedName name = UnresolvedName.of(value, text);
        name.setPosition(ASTListener.position(rule));
        return name;
    }
}

