/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.preprocess;

import java.util.List;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.diagnostic.Marker;
import org.fulib.scenarios.diagnostic.Position;

class Frame {
    String key;
    List<Sentence> target;
    Frame next;

    Frame() {
    }

    boolean keyMatches(String keys) {
        return Frame.keyMatches(this.key, keys);
    }

    static boolean keyMatches(String frameKeys, String keys) {
        int end;
        int start = 0;
        while ((end = keys.indexOf(44, start)) >= 0) {
            int colon = keys.indexOf(58, start);
            assert (colon < end);
            String key = keys.substring(start, colon + 1);
            int keyPos = frameKeys.indexOf(key);
            if (keyPos >= 0 && !frameKeys.regionMatches(keyPos, keys, start, end - start + 1)) {
                return false;
            }
            start = end + 1;
        }
        return true;
    }

    String getValue(String key) {
        int index = this.key.indexOf(key);
        if (index < 0) {
            return this.next != null ? this.next.getValue(key) : null;
        }
        int end = this.key.indexOf(44, index);
        return this.key.substring(index + key.length(), end);
    }

    Frame add(Sentence sentence) {
        this.target.add(sentence);
        return this;
    }

    Frame add(Position position, String key, Sentence sentence) {
        return this.popIncompatible(position, key).add(sentence);
    }

    Frame push(String key, List<Sentence> target) {
        Frame newTop = new Frame();
        newTop.key = key;
        newTop.target = target;
        newTop.next = this;
        return newTop;
    }

    Frame pop() {
        return this.next;
    }

    Frame pop(Position position, String key) {
        Frame def = this.popToDefinition(position, key);
        return def.next != null ? def.pop() : def;
    }

    private Frame popIncompatible(Position position, String key) {
        Frame result = this;
        while (!Frame.keyMatches(key, result.key)) {
            if (result.next == null) {
                this.reportIncompatible(position, key);
                return this;
            }
            result = result.next;
        }
        return result;
    }

    private Frame popToDefinition(Position position, String key) {
        Frame result = this;
        while (!result.key.contains(key)) {
            if (result.next == null) {
                this.reportIncompatible(position, key);
                return this;
            }
            result = result.next;
        }
        return result;
    }

    private void reportIncompatible(Position position, String key) {
        if (position == null) {
            return;
        }
        int beginIndex = key.indexOf(58);
        int endIndex = key.indexOf(44, beginIndex + 1);
        String type = key.substring(0, beginIndex);
        String value = key.substring(beginIndex + 1, endIndex);
        this.report(Marker.error(position, "frame.incompatible." + type, value));
    }

    void report(Marker marker) {
        this.next.report(marker);
    }
}

