/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.codegen;

import org.fulib.classmodel.Clazz;
import org.fulib.classmodel.CollectionType;
import org.fulib.classmodel.FMethod;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.decl.ParameterDecl;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.visitor.codegen.CodeGenDTO;
import org.fulib.scenarios.visitor.codegen.ExprGenerator;
import org.fulib.scenarios.visitor.codegen.SentenceGenerator;
import org.fulib.scenarios.visitor.codegen.TypeGenerator;

public enum DeclGenerator implements Decl.Visitor<CodeGenDTO, Object>
{
    INSTANCE;


    @Override
    public Object visit(ClassDecl classDecl, CodeGenDTO par) {
        if (classDecl.getExternal()) {
            return null;
        }
        par.clazz = par.modelManager.haveClass(classDecl.getName());
        for (AttributeDecl attributeDecl : classDecl.getAttributes().values()) {
            attributeDecl.accept(this, par);
        }
        for (AssociationDecl associationDecl : classDecl.getAssociations().values()) {
            associationDecl.accept(this, par);
        }
        for (MethodDecl method : classDecl.getMethods()) {
            method.accept(this, par);
        }
        return null;
    }

    @Override
    public Object visit(AttributeDecl attributeDecl, CodeGenDTO par) {
        Clazz clazz = par.modelManager.haveClass(attributeDecl.getOwner().getName());
        Type type = attributeDecl.getType();
        if (type instanceof ListType) {
            Type elementType = ((ListType)type).getElementType();
            Type wrappedType = PrimitiveType.primitiveToWrapper(elementType);
            par.modelManager.haveAttribute(clazz, attributeDecl.getName(), wrappedType.accept(TypeGenerator.INSTANCE, par)).setCollectionType(CollectionType.ArrayList);
        } else {
            par.modelManager.haveAttribute(clazz, attributeDecl.getName(), type.accept(TypeGenerator.INSTANCE, par));
        }
        return null;
    }

    @Override
    public Object visit(AssociationDecl associationDecl, CodeGenDTO par) {
        Clazz clazz = par.modelManager.haveClass(associationDecl.getOwner().getName());
        AssociationDecl other = associationDecl.getOther();
        String targetType = associationDecl.getTarget().accept(TypeGenerator.INSTANCE, par);
        if (other != null) {
            Clazz otherClazz = par.modelManager.haveClass(targetType);
            par.modelManager.associate(clazz, associationDecl.getName(), associationDecl.getCardinality(), otherClazz, other.getName(), other.getCardinality());
        } else if (associationDecl.getCardinality() == 1) {
            par.modelManager.haveAttribute(clazz, associationDecl.getName(), targetType);
        } else {
            par.modelManager.haveAttribute(clazz, associationDecl.getName(), targetType).setCollectionType(CollectionType.LinkedHashSet);
        }
        return null;
    }

    @Override
    public Object visit(MethodDecl methodDecl, CodeGenDTO par) {
        Clazz clazz = par.modelManager.haveClass(methodDecl.getOwner().getName());
        FMethod method = new FMethod();
        method.setClazz(clazz);
        method.setName(methodDecl.getName());
        method.setReturnType(methodDecl.getType().accept(TypeGenerator.INSTANCE, par));
        for (ParameterDecl parameter : methodDecl.getParameters()) {
            String name = parameter.getName();
            if ("this".equals(name)) continue;
            method.getParams().put(name, parameter.getType().accept(TypeGenerator.INSTANCE, par));
        }
        par.bodyBuilder = new StringBuilder();
        methodDecl.getBody().accept(SentenceGenerator.INSTANCE, par);
        method.setMethodBody(par.bodyBuilder.toString());
        par.bodyBuilder = null;
        return null;
    }

    @Override
    public Object visit(ParameterDecl parameterDecl, CodeGenDTO par) {
        throw new AssertionError((Object)"handled by visit(MethodDecl, ...)");
    }

    @Override
    public Object visit(VarDecl varDecl, CodeGenDTO par) {
        par.emitIndent();
        par.bodyBuilder.append(varDecl.getType().accept(TypeGenerator.INSTANCE, par)).append(' ').append(varDecl.getName());
        Expr expr = varDecl.getExpr();
        if (expr != null) {
            par.bodyBuilder.append(" = ");
            expr.accept(ExprGenerator.INSTANCE, par);
        }
        par.bodyBuilder.append(";\n");
        return null;
    }
}

