/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.tool;

import java.io.PrintWriter;
import java.util.BitSet;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;

public class ErrorListener
extends BaseErrorListener {
    private final PrintWriter out;

    public ErrorListener(PrintWriter out) {
        this.out = out;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        String sourceName = recognizer.getInputStream().getSourceName();
        this.report(sourceName, line, charPositionInLine, "syntax", msg);
    }

    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        String sourceName = recognizer.getInputStream().getSourceName();
        Token startToken = recognizer.getInputStream().get(startIndex);
        int line = startToken.getLine();
        int column = startToken.getCharPositionInLine();
        String[] ruleNames = recognizer.getRuleNames();
        String altString = ambigAlts.stream().mapToObj(i -> ruleNames[i]).sorted().collect(Collectors.joining(", "));
        this.report(sourceName, line, column, "warning", "parser ambiguity with alternatives: " + altString);
    }

    private void report(String file, int line, int column, String type, String msg) {
        this.out.println(file + ":" + line + ":" + column + ": " + type + ": " + msg);
    }
}

