/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.pattern.Pattern;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.sentence.AssignSentence;
import org.fulib.scenarios.ast.sentence.ExprSentence;
import org.fulib.scenarios.ast.sentence.FlattenSentenceList;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.MatchSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.visitor.ExtractClassDecl;

public enum SymbolCollector implements Sentence.Visitor<Map<String, Decl>, Object>
{
    INSTANCE;


    public static ListExpr getRoots(Scenario scenario) {
        return SymbolCollector.getRoots(scenario, (Sentence)null);
    }

    public static ListExpr getRoots(Scenario scenario, Sentence before) {
        List<Sentence> sentences = scenario.getBody().getItems();
        if (sentences.isEmpty()) {
            return null;
        }
        TreeMap<String, Decl> symbolTable = new TreeMap<String, Decl>();
        for (Sentence item : sentences) {
            if (item == before) break;
            item.accept(INSTANCE, symbolTable);
        }
        return SymbolCollector.getRoots(symbolTable, scenario.getFile().getGroup().getClasses());
    }

    public static Expr getRoots(Scope par) {
        HashMap<String, ClassDecl> classes = new HashMap<String, ClassDecl>();
        HashMap<String, Decl> variables = new HashMap<String, Decl>();
        par.list((name, decl) -> {
            if (decl instanceof VarDecl) {
                variables.put((String)name, (Decl)decl);
            } else if (decl instanceof ClassDecl) {
                classes.put((String)name, (ClassDecl)decl);
            }
        });
        return SymbolCollector.getRoots(variables, classes);
    }

    private static ListExpr getRoots(Map<String, Decl> symbolTable, Map<String, ClassDecl> classes) {
        if (symbolTable.isEmpty()) {
            return null;
        }
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        for (Decl it : symbolTable.values()) {
            Type type = it.getType();
            ClassDecl classDecl = type.accept(ExtractClassDecl.INSTANCE, null);
            if (type != PrimitiveType.OBJECT && (classDecl == null || !classes.containsValue(classDecl))) continue;
            exprs.add(NameAccess.of(ResolvedName.of(it)));
        }
        if (exprs.isEmpty()) {
            return null;
        }
        return ListExpr.of(exprs);
    }

    @Override
    public Object visit(Sentence sentence, Map<String, Decl> par) {
        return null;
    }

    @Override
    public Object visit(SentenceList sentenceList, Map<String, Decl> par) {
        if (!(sentenceList instanceof FlattenSentenceList)) {
            return null;
        }
        for (Sentence sentence : sentenceList.getItems()) {
            sentence.accept(this, par);
        }
        return null;
    }

    @Override
    public Object visit(IsSentence isSentence, Map<String, Decl> par) {
        VarDecl varDecl = isSentence.getDescriptor();
        String name = varDecl.getName();
        this.addAnswerVar(par, varDecl, isSentence.getDescriptor().getExpr());
        par.put(name, varDecl);
        return null;
    }

    @Override
    public Object visit(MatchSentence matchSentence, Map<String, Decl> par) {
        for (Pattern pattern : matchSentence.getPatterns()) {
            Decl decl = pattern.getName().getDecl();
            par.put(decl.getName(), decl);
        }
        return null;
    }

    @Override
    public Object visit(AssignSentence assignSentence, Map<String, Decl> par) {
        this.addAnswerVar(par, assignSentence.getTarget(), assignSentence.getValue());
        return null;
    }

    @Override
    public Object visit(ExprSentence exprSentence, Map<String, Decl> par) {
        this.addAnswerVar(par, null, exprSentence.getExpr());
        return null;
    }

    private void addAnswerVar(Map<String, Decl> par, Decl varDecl, Expr expr) {
        if (!(expr instanceof CallExpr)) {
            return;
        }
        if (varDecl != null) {
            par.put("<answer-var>", varDecl);
        } else {
            par.remove("<answer-var>");
        }
    }
}

