/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.ast.scope;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.fulib.scenarios.ast.CompilationContext;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.ExternalClassDecl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.type.ClassType;
import org.fulib.scenarios.diagnostic.Marker;
import org.fulib.scenarios.library.ClassModelVisitor;
import org.fulib.scenarios.library.Library;
import org.fulib.scenarios.visitor.resolve.DeclResolver;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class GlobalScope
implements Scope {
    private final CompilationContext context;
    private final List<ScenarioGroup> importedGroups;

    public GlobalScope(CompilationContext context) {
        this.context = context;
        this.importedGroups = context.getConfig().getImports().stream().map(i -> DeclResolver.resolveGroup(context, i.replace('.', '/'))).collect(Collectors.toList());
    }

    @Override
    public void report(Marker marker) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Decl resolve(String name) {
        int nameSeparator = name.lastIndexOf(47);
        if (nameSeparator >= 0) {
            return this.resolveClass(name.substring(0, nameSeparator), name.substring(nameSeparator + 1), name);
        }
        for (ScenarioGroup importGroup : this.importedGroups) {
            ClassDecl importedClass = GlobalScope.resolveClass(importGroup, name, null);
            if (importedClass == null) continue;
            return importedClass;
        }
        return null;
    }

    @Override
    public void list(BiConsumer<? super String, ? super Decl> consumer) {
        for (ScenarioGroup group : this.importedGroups) {
            group.getClasses().forEach(consumer);
        }
    }

    private ClassDecl resolveClass(String packageDir, String simpleName, String fullName) {
        ScenarioGroup group = DeclResolver.resolveGroup(this.context, packageDir);
        return GlobalScope.resolveClass(group, simpleName, fullName);
    }

    private static ClassDecl resolveClass(ScenarioGroup group, String simpleName, String fullName) {
        return group.getClasses().computeIfAbsent(simpleName, s -> GlobalScope.loadClass(group, fullName != null ? fullName : group.getPackageDir() + '/' + simpleName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClassDecl loadClass(ScenarioGroup group, String fullName) {
        Iterator<Library> iterator = group.getContext().getLibraries().iterator();
        while (iterator.hasNext()) {
            Library library = iterator.next();
            try {
                InputStream input = library.loadClass(fullName);
                Throwable throwable = null;
                try {
                    if (input == null) continue;
                    ClassDecl classDecl = GlobalScope.loadClass(group, input);
                    return classDecl;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static ClassDecl loadClass(ScenarioGroup group, InputStream data) throws IOException {
        ExternalClassDecl classDecl = new ExternalClassDecl(group, null, null, null, new HashMap<String, AttributeDecl>(), new HashMap<String, AssociationDecl>(), new ArrayList<MethodDecl>());
        classDecl.setType(ClassType.of(classDecl));
        classDecl.setExternal(true);
        ClassReader reader = new ClassReader(data);
        reader.accept((ClassVisitor)new ClassModelVisitor(classDecl), 1);
        return classDecl;
    }
}

