/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.library;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.fulib.scenarios.library.Library;

public class DirLibrary
extends Library {
    public DirLibrary(File source) {
        super(source);
    }

    private File getValidFileOrNull(String className) {
        String canonicalFile;
        String classFileName = className.replace('/', File.separatorChar) + ".class";
        File file = new File(this.getSource(), classFileName);
        if (!file.exists()) {
            return null;
        }
        try {
            canonicalFile = file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
        if (!canonicalFile.endsWith(classFileName)) {
            return null;
        }
        return file;
    }

    @Override
    public boolean hasClass(String name) {
        return this.getValidFileOrNull(name) != null;
    }

    @Override
    public InputStream loadClass(String name) throws IOException {
        File file = this.getValidFileOrNull(name);
        return file != null ? new FileInputStream(file) : null;
    }
}

