/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.codegen;

import java.util.ArrayList;
import java.util.List;
import org.fulib.StrUtil;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.collection.FilterExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.collection.MapAccessExpr;
import org.fulib.scenarios.ast.expr.collection.RangeExpr;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.visitor.Namer;
import org.fulib.scenarios.visitor.codegen.CodeGenDTO;
import org.fulib.scenarios.visitor.codegen.ExprGenerator;

public enum StreamGenerator implements Expr.Visitor<CodeGenDTO, Void>
{
    INSTANCE;


    @Override
    public Void visit(Expr expr, CodeGenDTO par) {
        expr.accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(".stream()");
        return null;
    }

    @Override
    public Void visit(ListExpr listExpr, CodeGenDTO par) {
        par.addImport("java.util.stream.Stream");
        List<Expr> elements = listExpr.getElements();
        if (elements.isEmpty()) {
            par.bodyBuilder.append("Stream.empty()");
            return null;
        }
        if (elements.stream().noneMatch(it -> it.getType() instanceof ListType)) {
            par.bodyBuilder.append("Stream.of(");
            ExprGenerator.INSTANCE.emitList(par, elements);
            par.bodyBuilder.append(')');
            return null;
        }
        List<Expr> grouped = StreamGenerator.group(elements);
        if (grouped.size() == 1) {
            grouped.get(0).accept(this, par);
            return null;
        }
        if (grouped.size() == 2) {
            par.bodyBuilder.append("Stream.concat(");
            grouped.get(0).accept(this, par);
            par.bodyBuilder.append(", ");
            grouped.get(1).accept(this, par);
            par.bodyBuilder.append(')');
            return null;
        }
        par.bodyBuilder.append("Stream.of(");
        grouped.get(0).accept(this, par);
        for (int i = 1; i < grouped.size(); ++i) {
            par.bodyBuilder.append(", ");
            grouped.get(i).accept(this, par);
        }
        par.addImport("java.util.function.Function");
        par.bodyBuilder.append(").flatMap(Function.identity())");
        return null;
    }

    private static List<Expr> group(List<Expr> elements) {
        int size = elements.size();
        ArrayList<Expr> result = new ArrayList<Expr>(size);
        int start = 0;
        while (start < size) {
            int end;
            for (end = start; end < size && !(elements.get(end).getType() instanceof ListType); ++end) {
            }
            if (end > start) {
                result.add(ListExpr.of(elements.subList(start, end)));
                start = end;
                continue;
            }
            result.add(elements.get(start));
            ++start;
        }
        return result;
    }

    @Override
    public Void visit(RangeExpr rangeExpr, CodeGenDTO par) {
        Type type = rangeExpr.getStart().getType();
        if (!(type instanceof PrimitiveType)) {
            par.bodyBuilder.append("error");
            return null;
        }
        PrimitiveType primitiveType = (PrimitiveType)type;
        switch (primitiveType) {
            case BYTE: 
            case BYTE_WRAPPER: 
            case SHORT: 
            case SHORT_WRAPPER: 
            case CHAR: 
            case CHAR_WRAPPER: {
                this.emitRangeStream(rangeExpr, par, "IntStream");
                par.bodyBuilder.append(".mapToObj(i -> (");
                par.bodyBuilder.append(primitiveType.getJavaName());
                par.bodyBuilder.append(") i)");
                return null;
            }
            case INT: 
            case INT_WRAPPER: {
                this.emitRangeStream(rangeExpr, par, "IntStream");
                par.bodyBuilder.append(".boxed()");
                return null;
            }
            case LONG: 
            case LONG_WRAPPER: {
                this.emitRangeStream(rangeExpr, par, "LongStream");
                par.bodyBuilder.append(".boxed()");
                return null;
            }
        }
        par.bodyBuilder.append("error");
        return null;
    }

    private void emitRangeStream(RangeExpr rangeExpr, CodeGenDTO par, String streamClass) {
        par.addImport("java.util.stream." + streamClass);
        par.addImport("java.util.stream.Collectors");
        par.bodyBuilder.append(streamClass);
        par.bodyBuilder.append(".rangeClosed(");
        rangeExpr.getStart().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(", ");
        rangeExpr.getEnd().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(")");
    }

    @Override
    public Void visit(MapAccessExpr listAttributeAccess, CodeGenDTO par) {
        Type listType = listAttributeAccess.getReceiver().getType();
        Type elementType = ((ListType)listType).getElementType();
        String elementTypeName = elementType.accept(Namer.INSTANCE, elementType);
        Name name = listAttributeAccess.getName();
        Decl attribute = name.getDecl();
        listAttributeAccess.getReceiver().accept(this, par);
        par.bodyBuilder.append(".map(");
        par.bodyBuilder.append(elementTypeName);
        par.bodyBuilder.append(attribute != null && attribute.getType() == PrimitiveType.BOOLEAN ? "::is" : "::get");
        par.bodyBuilder.append(StrUtil.cap((String)name.getValue()));
        par.bodyBuilder.append(')');
        if (attribute != null && attribute.getType() instanceof ListType) {
            par.addImport("java.util.List");
            par.bodyBuilder.append(".flatMap(List::stream)");
        }
        return null;
    }

    @Override
    public Void visit(FilterExpr filterExpr, CodeGenDTO par) {
        filterExpr.getSource().accept(this, par);
        par.bodyBuilder.append(".filter(it -> ");
        filterExpr.getPredicate().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(')');
        return null;
    }
}

