/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.describe;

import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.diagnostic.Marker;

public enum DeclDescriber implements Decl.Visitor<Void, String>
{
    INSTANCE;


    @Override
    public String visit(AttributeDecl attributeDecl, Void par) {
        return DeclDescriber.describeAttribute(attributeDecl.getType());
    }

    @Override
    public String visit(AssociationDecl associationDecl, Void par) {
        return DeclDescriber.describeAssociation(associationDecl.getCardinality(), associationDecl.getTarget());
    }

    public static String describeAttribute(Type type) {
        if (type instanceof ListType) {
            Type elementType = ((ListType)type).getElementType();
            return Marker.localize("attribute.desc.*", elementType.getDescription());
        }
        return Marker.localize("attribute.desc.1", type.getDescription());
    }

    public static String describeAssociation(int cardinality, ClassDecl target) {
        return Marker.localize(cardinality == 1 ? "association.desc.1" : "association.desc.*", target.getName());
    }
}

