/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.patterns;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fulib.FulibTables;
import org.fulib.patterns.PatternMatcher;
import org.fulib.patterns.model.AttributeConstraint;
import org.fulib.patterns.model.MatchConstraint;
import org.fulib.patterns.model.Pattern;
import org.fulib.patterns.model.PatternObject;
import org.fulib.patterns.model.RoleObject;

public class PatternBuilder {
    private final Pattern pattern = new Pattern();

    public PatternBuilder() {
    }

    @Deprecated
    public PatternBuilder(String packageName) {
        this();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public PatternObject buildPatternObject(String name) {
        PatternObject patternObject = new PatternObject().setName(name);
        this.pattern.withObjects(patternObject);
        return patternObject;
    }

    public PatternObject buildPatternObject(String name, Class<?> type) {
        PatternObject object = this.buildPatternObject(name);
        this.buildInstanceOfConstraint(object, type);
        return object;
    }

    public PatternBuilder buildPatternLink(PatternObject src, PatternObject tgt) {
        return this.buildPatternLink(src, "*", "*", tgt);
    }

    public PatternBuilder buildPatternLink(PatternObject src, String attrName, PatternObject tgt) {
        return this.buildPatternLink(src, null, attrName, tgt);
    }

    public PatternBuilder buildPatternLink(PatternObject src, String srcRoleName, String tgtRoleName, PatternObject tgt) {
        RoleObject srcRole = new RoleObject().setName(srcRoleName).setObject(src).setPattern(this.pattern);
        new RoleObject().setName(tgtRoleName).setObject(tgt).setOther(srcRole).setPattern(this.pattern);
        return this;
    }

    @Deprecated
    public PatternBuilder buildAttibuteConstraint(Predicate<? super Object> predicate, PatternObject object) {
        return this.buildAttributeConstraint(object, predicate);
    }

    public <T> PatternBuilder buildAttributeConstraint(PatternObject object, Predicate<? super T> predicate) {
        new AttributeConstraint().setPredicate(predicate).setObject(object).setPattern(this.pattern);
        return this;
    }

    public <T> PatternBuilder buildAttributeConstraint(PatternObject object, Class<T> type, Predicate<? super T> predicate) {
        new AttributeConstraint().setPredicate(o -> type.isInstance(o) && predicate.test((Object)type.cast(o))).setObject(object).setPattern(this.pattern);
        return this;
    }

    public PatternBuilder buildEqualityConstraint(PatternObject object, final Object value) {
        return this.buildAttributeConstraint(object, new Predicate<Object>(){

            @Override
            public boolean test(Object o) {
                return Objects.equals(value, o);
            }

            public String toString() {
                return "equals(" + value + ")";
            }
        });
    }

    public PatternBuilder buildInstanceOfConstraint(PatternObject object, final Class<?> type) {
        return this.buildAttributeConstraint(object, new Predicate<Object>(){

            @Override
            public boolean test(Object o) {
                return type.isInstance(o);
            }

            public String toString() {
                return "instanceof " + type.getCanonicalName();
            }
        });
    }

    public PatternBuilder buildMatchConstraint(Predicate<? super Map<String, Object>> predicate, PatternObject ... objects) {
        new MatchConstraint().setPredicate(predicate).withObjects((Object[])objects).setPattern(this.pattern);
        return this;
    }

    public PatternBuilder buildDistinctConstraint(final PatternObject ... objects) {
        return this.buildMatchConstraint((Predicate<? super Map<String, Object>>)new Predicate<Map<String, Object>>(){

            @Override
            public boolean test(Map<String, Object> map) {
                return Stream.of(objects).map(PatternObject::getName).map(map::get).distinct().count() == (long)objects.length;
            }

            public String toString() {
                return "distinct(" + Arrays.stream(objects).map(Object::toString).collect(Collectors.joining(", ")) + ")";
            }
        }, objects);
    }

    public PatternMatcher matcher() {
        return FulibTables.matcher(this.getPattern());
    }
}

