/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tables;

import java.io.IOException;
import java.util.List;
import org.fulib.tables.Renderer;
import org.fulib.tables.Table;

public class HtmlRenderer
implements Renderer {
    public static final String DEFAULT_INDENT = "    ";
    private String caption;
    private String indent = "    ";

    public String getCaption() {
        return this.caption;
    }

    public HtmlRenderer setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public String getIndent() {
        return this.indent;
    }

    public HtmlRenderer setIndent(String indent) {
        this.indent = indent;
        return this;
    }

    @Override
    public void render(Table<?> table, Appendable out) throws IOException {
        String i = this.indent;
        out.append("<table>\n");
        if (this.caption != null) {
            out.append(i).append("<caption>\n");
            out.append(i).append(i).append(this.caption).append('\n');
            out.append(i).append("</caption>\n");
        }
        out.append(i).append("<tr>\n");
        for (String string : table.columns) {
            out.append(i).append(i).append("<th>").append(string).append("</th>\n");
        }
        out.append(i).append("</tr>\n");
        for (List list : table.table) {
            out.append(i).append("<tr>\n");
            for (Object cell : list) {
                out.append(i).append(i).append("<td>").append(String.valueOf(cell)).append("</td>\n");
            }
            out.append(i).append("</tr>\n");
        }
        out.append("</table>\n");
    }
}

