/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tables;

import java.util.ArrayList;
import java.util.Collections;
import org.fulib.tables.IncrementalTable;
import org.fulib.tables.ListeningTable;

public class IncrementalDoubleTable
extends IncrementalTable {
    private String columnName = null;

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public IncrementalDoubleTable(Double ... start) {
        this.setTable(new ArrayList<ArrayList<Object>>());
        this.setListeningTable(new ListeningTable(this, this.getTable()));
        this.getAllObjectTables().add(this);
        this.setAllListeningTables(new ArrayList<ListeningTable>());
        this.setAllListeningTables(this.getAllObjectTables().get(0).getAllListeningTables());
        this.getAllListeningTables().add(this.getListeningTable());
        this.setColumnName("A");
        this.getColumnMap().put(this.columnName, 0);
        for (Double current : start) {
            ArrayList<Double> row = new ArrayList<Double>();
            row.add(current);
            this.getTable().add(row);
        }
    }

    public double sum() {
        double result = 0.0;
        for (ArrayList<Object> row : this.getTable()) {
            result += ((Double)row.get(this.getColumnMap().get(this.columnName))).doubleValue();
        }
        return result;
    }

    public double min() {
        double result = Double.MAX_VALUE;
        for (ArrayList<Object> row : this.getTable()) {
            double value = (Double)row.get(this.getColumnMap().get(this.columnName));
            if (!(value < result)) continue;
            result = value;
        }
        return result;
    }

    public double max() {
        double result = Double.MIN_VALUE;
        for (ArrayList<Object> row : this.getTable()) {
            double value = (Double)row.get(this.getColumnMap().get(this.columnName));
            if (!(value > result)) continue;
            result = value;
        }
        return result;
    }

    public double median() {
        ArrayList<Double> list = this.toList();
        Collections.sort(list);
        int index = list.size() / 2;
        double result = list.get(index);
        return result;
    }

    public ArrayList<Double> toList() {
        ArrayList<Double> result = new ArrayList<Double>();
        for (ArrayList<Object> row : this.getTable()) {
            double value = (Double)row.get(this.getColumnMap().get(this.columnName));
            result.add(value);
        }
        return result;
    }

    public String toString() {
        if (this.getColumnMap() == null) {
            return "|empty|\n";
        }
        StringBuilder buf = new StringBuilder();
        for (String string : this.getColumnMap().keySet()) {
            buf.append(string).append(" \t");
        }
        buf.append("\n");
        for (ArrayList arrayList : this.getTable()) {
            for (Object cell : arrayList) {
                buf.append(cell).append(" \t");
            }
            buf.append("\n");
        }
        buf.append("\n");
        return buf.toString();
    }
}

