/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tables;

import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fulib.tables.LinkChangeListener;
import org.fulib.tables.ListeningTable;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.ReflectorMap;

public class IncrementalTable {
    private LinkedHashMap<String, Integer> columnMap = new LinkedHashMap();
    private ReflectorMap reflectorMap;
    private ListeningTable listeningTable = null;
    private ArrayList<ArrayList<Object>> table;
    private ArrayList<ListeningTable> allListeningTables = null;
    private ArrayList<IncrementalTable> allObjectTables = null;

    public LinkedHashMap<String, Integer> getColumnMap() {
        return this.columnMap;
    }

    public IncrementalTable setColumnMap(LinkedHashMap<String, Integer> value) {
        this.columnMap = value;
        return this;
    }

    public ReflectorMap getReflectorMap() {
        return this.reflectorMap;
    }

    public void setReflectorMap(ReflectorMap reflectorMap) {
        this.reflectorMap = reflectorMap;
    }

    public ListeningTable getListeningTable() {
        return this.listeningTable;
    }

    public void setListeningTable(ListeningTable listeningTable) {
        this.listeningTable = listeningTable;
    }

    public ArrayList<ArrayList<Object>> getTable() {
        if (this.table == null) {
            this.table = new ArrayList();
        }
        return this.table;
    }

    public IncrementalTable setTable(ArrayList<ArrayList<Object>> value) {
        this.table = value;
        return this;
    }

    public void setAllListeningTables(ArrayList<ListeningTable> allListeningTables) {
        this.allListeningTables = allListeningTables;
    }

    public ArrayList<ListeningTable> getAllListeningTables() {
        return this.allListeningTables;
    }

    public void setAllObjectTables(ArrayList<IncrementalTable> allObjectTables) {
        this.allObjectTables = allObjectTables;
    }

    public ArrayList<IncrementalTable> getAllObjectTables() {
        if (this.allObjectTables == null) {
            this.allObjectTables = new ArrayList();
        }
        return this.allObjectTables;
    }

    public void updateAllObjectTables(ListeningTable newTable) {
        for (IncrementalTable previousTable : this.getAllObjectTables()) {
            previousTable.setListeningTable(newTable);
            previousTable.setTable(newTable.getBaseTable());
        }
    }

    public void addRowsForLink(String linkName, String startColumnName, ListeningTable newListeningTable, ListeningTable oldListeningTable, ArrayList<Object> row) {
        Integer index = this.columnMap.get(startColumnName);
        Object start = row.get(index);
        Reflector reflector = this.reflectorMap.getReflector(start);
        Object value = reflector.getValue(start, linkName);
        LinkChangeListener linkChangeListener = new LinkChangeListener(start, row, linkName, newListeningTable);
        try {
            Method addPropertyChangeListenerMethod = start.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
            addPropertyChangeListenerMethod.invoke(start, linkName, linkChangeListener);
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.SEVERE, "could not add property change listener to " + start, e);
        }
        oldListeningTable.addRowListener(row, linkChangeListener);
        this.addRowsForLinkValues(linkName, newListeningTable, row, start, value, linkChangeListener);
    }

    public void addRowsForLinkValues(String linkName, ListeningTable newListeningTable, ArrayList<Object> row, Object start, Object value, LinkChangeListener linkChangeListener) {
        if (value instanceof Collection) {
            for (Object current : (Collection)value) {
                ArrayList newRow = (ArrayList)row.clone();
                newRow.add(current);
                newListeningTable.addRow(newRow);
                linkChangeListener.addTargetRow(current, newRow);
            }
        } else if (value != null) {
            ArrayList newRow = (ArrayList)row.clone();
            newRow.add(value);
            newListeningTable.addRow(newRow);
            linkChangeListener.addTargetRow(value, newRow);
        }
    }

    public void removeRowsForLink(ArrayList<Object> oldRow, Object oldStart, ListeningTable newListeningTable, ListeningTable oldListeningTable) {
        PropertyChangeListener o = oldListeningTable.getRowListeners().get(oldRow);
        if (!(o instanceof LinkChangeListener)) {
            return;
        }
        LinkChangeListener oldLinkChangeListener = (LinkChangeListener)o;
        LinkedHashMap<Object, ArrayList<Object>> rowList = oldLinkChangeListener.getTargetRows();
        for (ArrayList<Object> row : rowList.values()) {
            newListeningTable.removeRow(row, oldStart);
        }
        oldLinkChangeListener.getTargetRows().clear();
        oldListeningTable.getRowListeners().remove(oldLinkChangeListener);
        try {
            Method removePropertyChangeListenerMethod = oldStart.getClass().getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
            removePropertyChangeListenerMethod.invoke(oldStart, oldLinkChangeListener.getLinkName(), oldLinkChangeListener);
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.SEVERE, "could not remove property change listener from " + oldStart, e);
        }
    }
}

