/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fulib.tables.BooleanTable;
import org.fulib.tables.StringTable;
import org.fulib.tables.Table;
import org.fulib.tables.doubleTable;
import org.fulib.tables.floatTable;
import org.fulib.tables.intTable;
import org.fulib.tables.longTable;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.ReflectorMap;

public class ObjectTable<T>
extends Table<T> {
    private ReflectorMap reflectorMap;

    @SafeVarargs
    public ObjectTable(T ... start) {
        super(start);
        this.initReflector(start);
    }

    @SafeVarargs
    public ObjectTable(String colName, T ... start) {
        super(colName, start);
        this.initReflector(start);
    }

    ObjectTable(Table<?> base) {
        super(base);
        if (base instanceof ObjectTable) {
            this.reflectorMap = ((ObjectTable)base).getReflectorMap();
        }
    }

    @SafeVarargs
    private final void initReflector(T ... start) {
        if (start.length == 0) {
            return;
        }
        Set packageNames = Arrays.stream(start).map(o -> o.getClass().getPackage().getName()).collect(Collectors.toSet());
        this.reflectorMap = new ReflectorMap(packageNames);
    }

    public ReflectorMap getReflectorMap() {
        return this.reflectorMap;
    }

    public void setReflectorMap(ReflectorMap reflectorMap) {
        this.reflectorMap = reflectorMap;
    }

    private void checkSameData(ObjectTable<?> otherTable) {
        if (this.table != otherTable.table) {
            throw new IllegalArgumentException("other table does not share the same underlying data");
        }
    }

    public ObjectTable<T> hasLink(String linkName, ObjectTable<?> otherTable) {
        this.checkSameData(otherTable);
        return this.hasLink(this.getColumnName(), otherTable.getColumnName(), linkName);
    }

    public ObjectTable<T> hasLink(String sourceColumn, String targetColumn, String linkName) {
        int thisColumn = this.getColumnIndex(sourceColumn);
        int otherColumn = this.getColumnIndex(targetColumn);
        this.table.removeIf(row -> {
            Object source = row.get(thisColumn);
            Object target = row.get(otherColumn);
            if (!this.reflectorMap.canReflect(source)) {
                return true;
            }
            Reflector reflector = this.reflectorMap.getReflector(source);
            Object linkValue = reflector.getValue(source, linkName);
            boolean keep = linkValue == target || linkValue instanceof Collection && ((Collection)linkValue).contains(target);
            return !keep;
        });
        return this;
    }

    public ObjectTable<T> hasAnyLink(ObjectTable<?> otherTable) {
        this.checkSameData(otherTable);
        return this.hasAnyLink(this.getColumnName(), otherTable.getColumnName());
    }

    public ObjectTable<T> hasAnyLink(String sourceColumn, String targetColumn) {
        int thisColumn = this.getColumnIndex(sourceColumn);
        int otherColumn = this.getColumnIndex(targetColumn);
        this.table.removeIf(row -> {
            Object start = row.get(thisColumn);
            Object other = row.get(otherColumn);
            if (!this.reflectorMap.canReflect(start)) {
                return true;
            }
            Reflector reflector = this.reflectorMap.getReflector(start);
            for (String property : reflector.getAllProperties()) {
                Object value = reflector.getValue(start, property);
                if (value != other && (!(value instanceof Collection) || !((Collection)value).contains(other))) continue;
                return false;
            }
            return true;
        });
        return this;
    }

    private <U> ObjectTable<U> view(String targetColumn) {
        ObjectTable<T> result = new ObjectTable<T>(this);
        result.setColumnName_(targetColumn);
        return result;
    }

    public <U> ObjectTable<U> expandLink(String targetColumn, String linkName) {
        return this.expandLink(this.getColumnName(), targetColumn, linkName);
    }

    public <U> ObjectTable<U> expandLink(String sourceColumn, String targetColumn, String linkName) {
        return this.expandAll(sourceColumn, targetColumn, (T start) -> {
            if (!this.reflectorMap.canReflect(start)) {
                return Collections.emptySet();
            }
            Reflector reflector = this.reflectorMap.getReflector(start);
            Object value = reflector.getValue(start, linkName);
            if (value instanceof Collection) {
                return (Collection)value;
            }
            if (value != null) {
                return Collections.singleton(value);
            }
            return Collections.emptySet();
        });
    }

    public <U> ObjectTable<U> expandAll(String targetColumn) {
        return this.expandAll(this.getColumnName(), targetColumn);
    }

    public <U> ObjectTable<U> expandAll(String sourceColumn, String targetColumn) {
        return this.expandAll(sourceColumn, targetColumn, (T start) -> {
            if (!this.reflectorMap.canReflect(start)) {
                return Collections.emptyList();
            }
            Reflector reflector = this.reflectorMap.getReflector(start);
            ArrayList<Object> result = new ArrayList<Object>();
            for (String propertyName : reflector.getAllProperties()) {
                Object value = reflector.getValue(start, propertyName);
                if (value instanceof Collection) {
                    result.addAll((Collection)value);
                    continue;
                }
                if (value == null) continue;
                result.add(value);
            }
            return result;
        });
    }

    public <U> Table<U> expandAttribute(String targetColumn, String attrName) {
        return this.expandAttribute(this.getColumnName(), targetColumn, attrName);
    }

    public <U> Table<U> expandAttribute(String sourceColumn, String targetColumn, String attrName) {
        this.expandAttributeImpl(sourceColumn, targetColumn, attrName);
        Table result = new Table(this);
        result.setColumnName_(targetColumn);
        return result;
    }

    public doubleTable expandDouble(String targetColumn, String attrName) {
        this.expandAttributeImpl(targetColumn, attrName);
        doubleTable result = new doubleTable(this);
        result.setColumnName_(targetColumn);
        return result;
    }

    public floatTable expandFloat(String targetColumn, String attrName) {
        this.expandAttributeImpl(targetColumn, attrName);
        floatTable result = new floatTable(this);
        result.setColumnName_(targetColumn);
        return result;
    }

    public intTable expandInt(String targetColumn, String attrName) {
        this.expandAttributeImpl(targetColumn, attrName);
        intTable result = new intTable(this);
        result.setColumnName_(targetColumn);
        return result;
    }

    public longTable expandLong(String targetColumn, String attrName) {
        this.expandAttributeImpl(targetColumn, attrName);
        longTable result = new longTable(this);
        result.setColumnName_(targetColumn);
        return result;
    }

    public StringTable expandString(String targetColumn, String attrName) {
        this.expandAttributeImpl(targetColumn, attrName);
        StringTable result = new StringTable(this);
        result.setColumnName_(targetColumn);
        return result;
    }

    public BooleanTable expandBoolean(String targetColumn, String attrName) {
        this.expandAttributeImpl(targetColumn, attrName);
        BooleanTable result = new BooleanTable(this);
        result.setColumnName_(targetColumn);
        return result;
    }

    private void expandAttributeImpl(String targetColumn, String attrName) {
        this.expandAttributeImpl(this.getColumnName(), targetColumn, attrName);
    }

    private void expandAttributeImpl(String sourceColumn, String targetColumn, String attrName) {
        this.expandImpl(sourceColumn, targetColumn, start -> {
            if (!this.reflectorMap.canReflect(start)) {
                return null;
            }
            Reflector reflector = this.reflectorMap.getReflector(start);
            return reflector.getValue(start, attrName);
        });
    }

    @Override
    public <U> ObjectTable<U> expand(String targetColumn, Function<? super T, ? extends U> function) {
        return this.expand(this.getColumnName(), targetColumn, function);
    }

    @Override
    public <V, U> ObjectTable<U> expand(String sourceColumn, String targetColumn, Function<? super V, ? extends U> function) {
        this.expandImpl(sourceColumn, targetColumn, function);
        return this.view(targetColumn);
    }

    @Override
    public <U> ObjectTable<U> expandAll(String targetColumn, Function<? super T, ? extends Collection<? extends U>> function) {
        return this.expandAll(this.getColumnName(), targetColumn, function);
    }

    @Override
    public <V, U> ObjectTable<U> expandAll(String sourceColumn, String targetColumn, Function<? super V, ? extends Collection<? extends U>> function) {
        this.expandAllImpl(sourceColumn, targetColumn, function);
        return this.view(targetColumn);
    }

    @Override
    public ObjectTable<T> selectColumns(String ... columnNames) {
        super.selectColumns(columnNames);
        return this;
    }

    @Override
    public ObjectTable<T> dropColumns(String ... columnNames) {
        super.dropColumns(columnNames);
        return this;
    }

    @Override
    public ObjectTable<T> filter(Predicate<? super T> predicate) {
        super.filter(predicate);
        return this;
    }

    @Override
    public <V> ObjectTable<T> filter(String sourceColumn, Predicate<? super V> predicate) {
        super.filter(sourceColumn, predicate);
        return this;
    }

    @Override
    public LinkedHashSet<T> toSet() {
        return this.stream().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Deprecated
    public ObjectTable<T> setColumnName(String columnName) {
        this.setColumnName_(columnName);
        return this;
    }

    @Deprecated
    public ObjectTable<T> setTable(ArrayList<ArrayList<Object>> table) {
        this.table = new ArrayList<ArrayList<Object>>(table);
        return this;
    }

    @Deprecated
    public ObjectTable<T> setColumnMap(LinkedHashMap<String, Integer> columnMap) {
        this.setColumnMap_(columnMap);
        return this;
    }

    @Deprecated
    public void addColumn(String columnName, Function<LinkedHashMap<String, Object>, Object> function) {
        this.deriveImpl(columnName, function);
    }

    @Deprecated
    public ObjectTable<T> filterRow(Predicate<LinkedHashMap<String, Object>> predicate) {
        this.filterRowsImpl(predicate);
        return this;
    }
}

