/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tools;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Objects;

public class Tables {
    public String toHtml(Object table) {
        Objects.requireNonNull(table);
        StringBuilder buf = new StringBuilder();
        Class<?> clazz = table.getClass();
        try {
            Method getTable = clazz.getMethod("getTable", new Class[0]);
            Method getColumnMap = clazz.getMethod("getColumnMap", new Class[0]);
            Object object = getTable.invoke(table, new Object[0]);
            ArrayList baseTable = (ArrayList)object;
            object = getColumnMap.invoke(table, new Object[0]);
            LinkedHashMap columnMap = (LinkedHashMap)object;
            this.genHeader(buf, columnMap, (ArrayList)baseTable.get(0));
            for (ArrayList row : baseTable) {
                this.genRow(buf, row);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return buf.toString();
    }

    private void genHeader(StringBuilder buf, LinkedHashMap<String, Integer> columnMap, ArrayList<Object> row) {
        buf.append("<table>\n");
        buf.append("<tr>");
        for (String key : columnMap.keySet()) {
            buf.append("<th>");
            buf.append(key);
            buf.append("</th>");
        }
        buf.append("</tr>\n");
        buf.append("</table>\n");
    }

    private void genRow(StringBuilder buf, ArrayList<Object> row) {
        buf.append("<tr>");
        for (Object value : row) {
            buf.append("<td>");
            buf.append(value);
            buf.append("</td>");
        }
        buf.append("</tr>\n");
    }
}

