/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fulib.tools.pipe.CodeFencePipe;
import org.fulib.tools.pipe.HtmlPipe;
import org.fulib.tools.pipe.IndentPipe;
import org.fulib.tools.pipe.JavaDocPipe;
import org.fulib.tools.pipe.Pipe;

public class CodeFragments {
    private static final Pattern START_PATTERN = Pattern.compile("^(\\s*)// start_code_fragment: ([\\w.]+)\\s*$");
    private static final Pattern END_PATTERN = Pattern.compile("^\\s*// end_code_fragment:.*$");
    private static final Pattern INSERT_START_PATTERN = Pattern.compile("^([\\s*>]*)<!-- insert_code_fragment: ([\\w.]+)\\s*(?:\\|\\s*(\\w\\S*)\\s*)?-->\\s*$");
    private static final Pattern INSERT_END_PATTERN = Pattern.compile("^[\\s*>]*<!-- end_code_fragment:.*$");
    private static final Map<String, Pipe> DEFAULT_PIPES;
    private final LinkedHashMap<String, String> fragmentMap = new LinkedHashMap();
    private final Map<String, Pipe> pipes = new HashMap<String, Pipe>(DEFAULT_PIPES);

    @Deprecated
    public LinkedHashMap<String, String> getFragmentMap() {
        return this.fragmentMap;
    }

    public Map<String, String> getFragments() {
        return Collections.unmodifiableMap(this.fragmentMap);
    }

    public String getFragment(String key) {
        return this.fragmentMap.get(key);
    }

    public void addFragment(String key, String content) {
        this.fragmentMap.put(key, content);
    }

    public Pipe getPipe(String name) {
        return this.pipes.get(name);
    }

    public void addPipe(String name, Pipe pipe) {
        this.pipes.put(name, pipe);
    }

    public void removePipe(String name) {
        this.pipes.remove(name);
    }

    public void load(String ... folders) {
        try {
            for (String folder : folders) {
                this.walkFiles(Paths.get(folder, new String[0]), this::fetchFromFile);
            }
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.WARNING, "file walk problem", e);
        }
    }

    public void write(String ... folders) {
        try {
            for (String folder : folders) {
                this.walkFiles(Paths.get(folder, new String[0]), this::insertFragments);
            }
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.WARNING, "file walk problem", e);
        }
    }

    public void update(String ... folders) {
        this.load(folders);
        this.write(folders);
    }

    @Deprecated
    public Map<String, String> updateCodeFragments(String ... folders) {
        this.update(folders);
        return this.getFragments();
    }

    private void walkFiles(Path path, final Consumer<? super Path> consumer) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                consumer.accept(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void fetchFromFile(Path file) {
        String fileName = file.toString();
        if (!(fileName.endsWith(".java") || fileName.endsWith(".md") || fileName.endsWith("build.gradle"))) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(file);){
            String line;
            String key = null;
            String indent = null;
            StringBuilder contentBuf = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (key == null) {
                    Matcher startMatcher = START_PATTERN.matcher(line);
                    if (!startMatcher.find()) continue;
                    indent = startMatcher.group(1);
                    key = startMatcher.group(2);
                    continue;
                }
                if (END_PATTERN.matcher(line).find()) {
                    if (this.fragmentMap.containsKey(key)) {
                        System.out.printf("%s: warning: fragment '%s' was already defined, using content from this file%n", fileName, key);
                    }
                    String fragmentText = contentBuf.toString();
                    this.fragmentMap.put(key, fragmentText);
                    key = null;
                    contentBuf.setLength(0);
                    continue;
                }
                int start = CodeFragments.commonPrefixLength(line, indent);
                contentBuf.append(line, start, line.length()).append(System.lineSeparator());
            }
            if (key != null) {
                throw new IllegalArgumentException("could not find <!-- end_code_fragment: in " + fileName);
            }
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.WARNING, "file read problem", e);
        }
    }

    private static int commonPrefixLength(String a, String b) {
        int i;
        for (i = 0; i < a.length() && i < b.length() && a.charAt(i) == b.charAt(i); ++i) {
        }
        return i;
    }

    private void insertFragments(Path file) {
        boolean hadInserts;
        String fileName = file.toString();
        if (!fileName.endsWith(".java") && !fileName.endsWith(".md")) {
            return;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MessageDigest inputDigest = CodeFragments.createDigest();
        try (BufferedReader reader = CodeFragments.newDigestReader(file, inputDigest);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));){
            hadInserts = this.insertFragments(fileName, reader, writer);
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.WARNING, "file read problem", e);
            return;
        }
        if (!hadInserts) {
            return;
        }
        byte[] bytes = outputStream.toByteArray();
        MessageDigest outputDigest = CodeFragments.createDigest();
        outputDigest.update(bytes);
        if (Arrays.equals(inputDigest.digest(), outputDigest.digest())) {
            return;
        }
        try {
            Files.write(file, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.WARNING, "file write problem", e);
        }
    }

    private boolean insertFragments(String fileName, BufferedReader reader, BufferedWriter writer) throws IOException {
        String line;
        boolean hadInserts = false;
        String key = null;
        int lineNum = 1;
        while ((line = reader.readLine()) != null) {
            if (key != null) {
                if (INSERT_END_PATTERN.matcher(line).find()) {
                    CodeFragments.writeLine(writer, line);
                    key = null;
                }
            } else {
                CodeFragments.writeLine(writer, line);
                Matcher startMatcher = INSERT_START_PATTERN.matcher(line);
                if (startMatcher.find()) {
                    key = startMatcher.group(2);
                    String content = this.fragmentMap.get(key);
                    if (content == null) {
                        System.err.printf("%s:%d: warning: undefined fragment '%s' was not inserted%n", fileName, lineNum, key);
                        key = null;
                    } else {
                        for (int i = 3; i <= startMatcher.groupCount(); ++i) {
                            String arg = startMatcher.group(i);
                            if (arg == null) continue;
                            String pipeName = CodeFragments.getPipeName(arg);
                            Pipe pipe = this.getPipe(pipeName);
                            if (pipe != null) {
                                content = pipe.apply(content, arg);
                                continue;
                            }
                            System.err.printf("%s:%d: warning: unknown pipe '%s', skipping%n", fileName, lineNum, pipeName);
                        }
                        hadInserts = true;
                        String indent = startMatcher.group(1);
                        this.writeFragment(writer, indent, content);
                    }
                }
            }
            ++lineNum;
        }
        if (key != null) {
            throw new IllegalArgumentException("could not find <!-- end_code_fragment: in " + fileName);
        }
        return hadInserts;
    }

    private static String getPipeName(String arg) {
        int colonIndex = arg.indexOf(58);
        if (colonIndex >= 0) {
            arg = arg.substring(0, colonIndex);
        }
        return arg;
    }

    private static void writeLine(BufferedWriter writer, String line) throws IOException {
        writer.write(line);
        writer.write(System.lineSeparator());
    }

    private void writeFragment(BufferedWriter writer, String indent, String content) throws IOException {
        for (String contentLine : content.split(System.lineSeparator())) {
            writer.write(indent);
            CodeFragments.writeLine(writer, contentLine);
        }
    }

    private static BufferedReader newDigestReader(Path file, MessageDigest inputDigest) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new DigestInputStream(Files.newInputStream(file, new OpenOption[0]), inputDigest), StandardCharsets.UTF_8));
    }

    private static MessageDigest createDigest() {
        MessageDigest inputDigest;
        try {
            inputDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return inputDigest;
    }

    static {
        HashMap<String, Pipe> defaultPipes = new HashMap<String, Pipe>();
        defaultPipes.put("indent", new IndentPipe());
        defaultPipes.put("javadoc", new JavaDocPipe());
        defaultPipes.put("fenced", new CodeFencePipe());
        defaultPipes.put("html", new HtmlPipe());
        DEFAULT_PIPES = Collections.unmodifiableMap(defaultPipes);
    }
}

