/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import org.fulib.yaml.YamlGenerator;
import org.fulib.yaml.Yamler;

public class EventSource {
    public static final String EVENT_KEY = ".eventKey";
    public static final String EVENT_TIMESTAMP = ".eventTimestamp";
    public static final String EVENT_TYPE = "eventType";
    private final Yamler yamler = new Yamler();
    private final List<Consumer<? super Map<String, String>>> eventListeners = new ArrayList<Consumer<? super Map<String, String>>>();
    private final Map<String, Long> keyToTimeStampMap = new HashMap<String, Long>();
    private final SortedMap<Long, Map<String, String>> timeStampToEventMap = new TreeMap<Long, Map<String, String>>();
    private long lastEventTime;
    private long oldEventTimeStamp = 0L;
    public DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public long getLastEventTime() {
        return this.lastEventTime;
    }

    @Deprecated
    public SortedMap<Long, LinkedHashMap<String, String>> pull(long since) {
        return this.pull(since, (Function<Map.Entry<Long, LinkedHashMap<String, String>>, Boolean>)null);
    }

    @Deprecated
    public SortedMap<Long, LinkedHashMap<String, String>> pull(long since, String ... relevantEventTypes) {
        HashSet<String> eventTypes = new HashSet<String>(Arrays.asList(relevantEventTypes));
        return this.pull(since, (Map.Entry<Long, LinkedHashMap<String, String>> e) -> eventTypes.contains(((LinkedHashMap)e.getValue()).get(EVENT_KEY)));
    }

    @Deprecated
    public SortedMap<Long, LinkedHashMap<String, String>> pull(long since, Function<Map.Entry<Long, LinkedHashMap<String, String>>, Boolean> filterOp) {
        SortedMap<Long, Map<String, String>> tailMap = this.timeStampToEventMap.tailMap(since);
        TreeMap<Long, LinkedHashMap<String, String>> resultMap = new TreeMap<Long, LinkedHashMap<String, String>>();
        for (Map.Entry<Long, Map<String, String>> entry : tailMap.entrySet()) {
            LinkedHashMap<String, String> linkedEvent = EventSource.makeLinked(entry.getValue());
            if (filterOp != null && !filterOp.apply(new AbstractMap.SimpleEntry<Long, LinkedHashMap<String, String>>(entry.getKey(), linkedEvent)).booleanValue()) continue;
            resultMap.put(entry.getKey(), linkedEvent);
        }
        return resultMap;
    }

    public SortedMap<Long, Map<String, String>> getEvents() {
        return Collections.unmodifiableSortedMap(this.timeStampToEventMap);
    }

    public SortedMap<Long, Map<String, String>> getEvents(long since) {
        return Collections.unmodifiableSortedMap(this.timeStampToEventMap.tailMap(since));
    }

    public SortedMap<Long, Map<String, String>> getEvents(long since, String ... relevantEventTypes) {
        HashSet<String> eventTypes = new HashSet<String>(Arrays.asList(relevantEventTypes));
        return this.getEvents(since, (? super Long k, ? super Map<String, String> v) -> eventTypes.contains(v.get(EVENT_KEY)));
    }

    public SortedMap<Long, Map<String, String>> getEvents(long since, BiPredicate<? super Long, ? super Map<String, String>> filterOp) {
        SortedMap<Long, Map<String, String>> events = this.timeStampToEventMap.tailMap(since);
        if (filterOp == null) {
            return events;
        }
        TreeMap<Long, Map<String, String>> result = new TreeMap<Long, Map<String, String>>();
        for (Map.Entry<Long, Map<String, String>> entry : events.entrySet()) {
            Map<String, String> value;
            Long key = entry.getKey();
            if (!filterOp.test(key, value = entry.getValue())) continue;
            result.put(key, value);
        }
        return result;
    }

    @Deprecated
    public LinkedHashMap<String, String> getEvent(String eventKey) {
        return EventSource.makeLinked(this.getNewestEvent(eventKey));
    }

    public Map<String, String> getNewestEvent(String eventKey) {
        Long timeStamp = this.keyToTimeStampMap.get(eventKey);
        return timeStamp != null ? (Map)this.timeStampToEventMap.get(timeStamp) : null;
    }

    @Deprecated
    public boolean isOverwritten(LinkedHashMap<String, String> event) {
        return this.isOverwritten((Map<String, String>)event);
    }

    public boolean isOverwritten(Map<String, String> event) {
        String eventKey = event.get(EVENT_KEY);
        String eventTimeTxt = event.get(EVENT_TIMESTAMP);
        Long storedTime = this.keyToTimeStampMap.get(eventKey);
        if (storedTime == null) {
            return false;
        }
        String storedTimeTxt = this.dateFormat.format(storedTime);
        return storedTimeTxt.compareTo(eventTimeTxt) >= 0;
    }

    public void addEventListener(Consumer<? super Map<String, String>> listener) {
        this.eventListeners.add(listener);
    }

    @Deprecated
    public EventSource setOldEventTimeStamp(String oldEventTimeStamp) {
        if (oldEventTimeStamp == null) {
            return this;
        }
        long oldTimeStamp = 0L;
        try {
            oldTimeStamp = this.dateFormat.parse(oldEventTimeStamp).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return this.setOldEventTimeStamp(oldTimeStamp);
    }

    public EventSource setOldEventTimeStamp(long oldEventTimeStamp) {
        this.oldEventTimeStamp = oldEventTimeStamp;
        return this;
    }

    @Deprecated
    public EventSource append(LinkedHashMap<String, String> event) {
        return this.append((Map<String, String>)event);
    }

    public EventSource append(Map<String, String> event) {
        Long oldNum;
        long currentTime;
        this.setOldEventTimeStamp(event.get(EVENT_TIMESTAMP));
        this.lastEventTime = this.oldEventTimeStamp > this.lastEventTime ? this.oldEventTimeStamp : ((currentTime = System.currentTimeMillis()) > this.lastEventTime ? currentTime : ++this.lastEventTime);
        String timestampString = this.dateFormat.format(this.lastEventTime);
        this.oldEventTimeStamp = 0L;
        event.put(EVENT_TIMESTAMP, timestampString);
        String key = event.get(EVENT_KEY);
        if (key != null && (oldNum = this.keyToTimeStampMap.get(key)) != null) {
            this.timeStampToEventMap.remove(oldNum);
        }
        this.keyToTimeStampMap.put(key, this.lastEventTime);
        this.timeStampToEventMap.put(this.lastEventTime, event);
        for (Consumer<? super Map<String, String>> listener : this.eventListeners) {
            listener.accept(event);
        }
        return this;
    }

    @Deprecated
    public EventSource append(String yaml) {
        if (yaml == null) {
            return this;
        }
        ArrayList<LinkedHashMap<String, String>> list = this.yamler.decodeList(yaml);
        for (LinkedHashMap<String, String> event : list) {
            this.append(event);
        }
        return this;
    }

    public String encodeYaml() {
        return YamlGenerator.serialize(this.timeStampToEventMap.values());
    }

    public void encodeYaml(Writer writer) throws IOException {
        YamlGenerator.serialize(this.timeStampToEventMap.values(), (Appendable)writer);
    }

    @Deprecated
    private static LinkedHashMap<String, String> makeLinked(Map<String, String> event) {
        return event instanceof LinkedHashMap ? (LinkedHashMap<Object, Object>)event : new LinkedHashMap<String, String>(event);
    }

    @Deprecated
    public static String encodeYaml(SortedMap<Long, ? extends Map<String, String>> events) {
        return YamlGenerator.serialize(events.values());
    }

    @Deprecated
    public static String encodeYaml(List<? extends Map<String, String>> events) {
        return YamlGenerator.serialize(events);
    }

    @Deprecated
    public static String encodeYaml(LinkedHashMap<String, String> event) {
        return YamlGenerator.serialize(event);
    }
}

