/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.beans.PropertyChangeEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.YamlGenerator;
import org.fulib.yaml.YamlIdMap;
import org.fulib.yaml.Yamler;

public class EventYamler {
    public static final String TIME = "time";
    public static final String SOURCE = "source";
    public static final String SOURCE_TYPE = "sourceType";
    public static final String PROPERTY = "property";
    public static final String OLD_VALUE = "oldValue";
    public static final String OLD_VALUE_TYPE = "oldValueType";
    public static final String NEW_VALUE = "newValue";
    public static final String NEW_VALUE_TYPE = "newValueType";
    public static final String HISTORY_KEY = "historyKey";
    private YamlIdMap yamlIdMap;

    public EventYamler(String packageName) {
        this(new YamlIdMap(packageName));
    }

    public EventYamler(YamlIdMap idMap) {
        this.yamlIdMap = idMap;
    }

    public YamlIdMap getYamlIdMap() {
        return this.yamlIdMap;
    }

    public EventYamler setYamlIdMap(YamlIdMap yamlIdMap) {
        this.yamlIdMap = yamlIdMap;
        return this;
    }

    public String encode(PropertyChangeEvent e) {
        Object newValue;
        Object source = e.getSource();
        StringBuilder buf = new StringBuilder("- ");
        long timeMillis = System.currentTimeMillis();
        Date date = new Date(timeMillis);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        String timeString = dateFormat.format(date);
        buf.append("time: ").append(timeString).append("\n");
        String sourceKey = this.yamlIdMap.putObject(source);
        buf.append("  source: ").append(sourceKey).append("\n");
        String className = source.getClass().getSimpleName();
        buf.append("  sourceType: ").append(className).append("\n");
        String prop = e.getPropertyName();
        buf.append("  property: ").append(prop).append("\n");
        String historyKey = sourceKey + "/" + prop;
        Object oldValue = e.getOldValue();
        if (oldValue != null) {
            Class<?> valueClass = oldValue.getClass();
            if (valueClass == String.class) {
                String encapsulted = YamlGenerator.encapsulate((String)oldValue);
                buf.append("  oldValue: ").append(encapsulted).append("\n");
            } else if (valueClass.getName().startsWith("java.lang.")) {
                buf.append("  oldValue: ").append(oldValue).append("\n");
            } else {
                String valueKey = this.yamlIdMap.putObject(oldValue);
                buf.append("  oldValue: ").append(valueKey).append("\n");
                historyKey = historyKey + "/" + valueKey;
                className = oldValue.getClass().getSimpleName();
                buf.append("  oldValueType: ").append(className).append("\n");
            }
        }
        if ((newValue = e.getNewValue()) != null) {
            Class<?> valueClass = newValue.getClass();
            if (valueClass == String.class) {
                String encapsulted = YamlGenerator.encapsulate((String)newValue);
                buf.append("  newValue: ").append(encapsulted).append("\n");
            } else if (valueClass.getName().startsWith("java.lang.")) {
                buf.append("  newValue: ").append(newValue).append("\n");
            } else {
                String valueKey = this.yamlIdMap.putObject(newValue);
                buf.append("  newValue: ").append(valueKey).append("\n");
                Reflector reflector = this.yamlIdMap.getReflector(className);
                Object attrValue = reflector.getValue(source, prop);
                if (attrValue != null && Collection.class.isAssignableFrom(attrValue.getClass())) {
                    historyKey = historyKey + "/" + valueKey;
                }
                className = newValue.getClass().getSimpleName();
                buf.append("  newValueType: ").append(className).append("\n");
            }
        }
        buf.append("  historyKey: ").append(historyKey).append("\n");
        buf.append("\n");
        return buf.toString();
    }

    public Object decode(Object rootObject, String content) {
        Yamler yamler = new Yamler();
        ArrayList<LinkedHashMap<String, String>> list = yamler.decodeList(content);
        String firstKey = null;
        for (LinkedHashMap<String, String> map : list) {
            Object oldObject;
            String sourceKey = map.get(SOURCE);
            if (firstKey == null && (oldObject = this.yamlIdMap.getObject(firstKey = sourceKey)) == null) {
                this.yamlIdMap.putNameObject(firstKey, rootObject);
            }
            Object sourceObject = this.yamlIdMap.getObject(sourceKey);
            String className = map.get(SOURCE_TYPE);
            Reflector reflector = this.yamlIdMap.getReflector(className);
            if (sourceObject == null) {
                sourceObject = reflector.newInstance();
                this.yamlIdMap.putNameObject(sourceKey, sourceObject);
            }
            String property = map.get(PROPERTY);
            String newValue = map.get(NEW_VALUE);
            String newValueType = map.get(NEW_VALUE_TYPE);
            if (newValueType == null) {
                reflector.setValue(sourceObject, property, newValue);
                continue;
            }
            Object newValueObject = this.yamlIdMap.getObject(newValue);
            if (newValueObject == null) {
                Reflector newValueReflector = this.yamlIdMap.getReflector(newValueType);
                newValueObject = newValueReflector.newInstance();
                this.yamlIdMap.putNameObject(newValue, newValueObject);
            }
            reflector.setValue(sourceObject, property, newValueObject);
        }
        return this.yamlIdMap.getObject(firstKey);
    }
}

