/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.ReflectorMap;
import org.fulib.yaml.StrUtil;
import org.fulib.yaml.YamlObject;

public class IdMap {
    protected final ReflectorMap reflectorMap;
    protected String userId;
    protected int maxUsedIdNum = 0;
    protected final LinkedHashMap<String, Object> objIdMap = new LinkedHashMap();
    protected final LinkedHashMap<Object, String> idObjMap = new LinkedHashMap();

    public IdMap(ReflectorMap reflectorMap) {
        this.reflectorMap = reflectorMap;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Reflector getReflector(Object object) {
        return this.reflectorMap.getReflector(object);
    }

    public String getId(Object object) {
        return this.idObjMap.get(object);
    }

    public Object getObject(String id) {
        return this.objIdMap.get(id);
    }

    public String putObject(Object object) {
        String key = this.idObjMap.get(object);
        if (key == null) {
            key = this.addToObjIdMap(object);
        }
        return key;
    }

    public void putObject(String id, Object object) {
        String oldKey = this.idObjMap.get(object);
        if (oldKey != null) {
            this.objIdMap.remove(oldKey);
            this.idObjMap.remove(object);
        }
        this.objIdMap.put(id, object);
        this.idObjMap.put(object, id);
    }

    public void discoverObjects(Object root) {
        this.reflectorMap.discoverObjects(root).forEach(this::putObject);
    }

    public void discoverObjects(Object ... roots) {
        this.reflectorMap.discoverObjects(roots).forEach(this::putObject);
    }

    public void discoverObjects(Collection<?> roots) {
        this.reflectorMap.discoverObjects(roots).forEach(this::putObject);
    }

    private String addToObjIdMap(Object obj) {
        String key = this.generateUniqueKey(obj);
        this.objIdMap.put(key, obj);
        this.idObjMap.put(obj, key);
        return key;
    }

    private String generateUniqueKey(Object obj) {
        if (obj instanceof YamlObject) {
            YamlObject yamlObj = (YamlObject)obj;
            return yamlObj.getId();
        }
        String key = this.getIntrinsicKey(obj);
        key = (key = key.replaceAll("\\W+", "_")).isEmpty() ? "_" : StrUtil.downFirstChar(key);
        key = this.makeUnique(key);
        key = this.addUserId(key);
        return key;
    }

    private String getIntrinsicKey(Object obj) {
        Reflector reflector = this.getReflector(obj);
        Object id = reflector.getValue(obj, "id");
        if (id != null) {
            return id.toString();
        }
        Object name = reflector.getValue(obj, "name");
        if (name != null) {
            return name.toString();
        }
        return obj.getClass().getSimpleName().substring(0, 1);
    }

    private String makeUnique(String key) {
        if (this.objIdMap.get(key) != null) {
            ++this.maxUsedIdNum;
            key = key + this.maxUsedIdNum;
        }
        return key;
    }

    private String addUserId(String key) {
        if (this.maxUsedIdNum > 1 && this.userId != null) {
            key = this.userId + "." + key;
        }
        return key;
    }
}

