/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.fulib.yaml.StrUtil;

public class Reflector {
    private static final Object INCOMPATIBLE = new Object();
    private String className = "";
    private Method emfCreateMethod;
    private Object emfFactory;
    private Class<?> eObjectClass;
    private Class<?> clazz;
    private transient Set<String> ownProperties;
    private transient Set<String> allProperties;
    private final transient Map<String, Method> getterCache = new HashMap<String, Method>();
    private final transient Map<String, List<Method>> setterCache = new HashMap<String, List<Method>>();
    private final transient Map<String, List<Method>> unsetterCache = new HashMap<String, List<Method>>();

    public Class<?> getClazz() {
        if (this.clazz == null) {
            try {
                this.clazz = Class.forName(this.className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.clazz;
    }

    public Reflector setClazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public Reflector setClassName(String className) {
        this.className = className;
        return this;
    }

    public Reflector setUseEMF() {
        String packageName = this.className;
        int pos = packageName.lastIndexOf(46);
        String simpleClassName = packageName.substring(pos + 1);
        simpleClassName = simpleClassName.substring(0, simpleClassName.length() - "Impl".length());
        packageName = packageName.substring(0, pos);
        packageName = packageName.substring(0, packageName.length() - ".impl".length());
        pos = packageName.lastIndexOf(46);
        String lastPart = packageName.substring(pos + 1);
        String simpleFactoryName = StrUtil.cap(lastPart) + "Factory";
        try {
            Class<?> factoryClass = Class.forName(packageName + "." + simpleFactoryName);
            Field eInstanceField = factoryClass.getField("eINSTANCE");
            this.emfFactory = eInstanceField.get(null);
            this.emfCreateMethod = this.emfFactory.getClass().getMethod("create" + simpleClassName, new Class[0]);
            this.eObjectClass = Class.forName("org.eclipse.emf.ecore.EObject");
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.SEVERE, "could not find EMF Factory createXY method", e);
        }
        return this;
    }

    @Deprecated
    public String[] getProperties() {
        return this.getOwnProperties().toArray(new String[0]);
    }

    public Set<String> getOwnProperties() {
        if (this.ownProperties != null) {
            return this.ownProperties;
        }
        TreeSet<String> ownProperties = new TreeSet<String>();
        Reflector.addProperties(this.getClazz(), false, ownProperties);
        this.ownProperties = Collections.unmodifiableSet(ownProperties);
        return this.ownProperties;
    }

    public Set<String> getAllProperties() {
        if (this.allProperties != null) {
            return this.allProperties;
        }
        TreeSet<String> ownProperties = new TreeSet<String>();
        Reflector.addProperties(this.getClazz(), true, ownProperties);
        this.allProperties = Collections.unmodifiableSet(ownProperties);
        return this.allProperties;
    }

    private static void addProperties(Class<?> clazz, boolean inherited, Set<String> fieldNames) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (method.getParameterCount() != 0 || methodName.length() <= 3 || !inherited && method.getDeclaringClass() != clazz || !methodName.startsWith("get") || "getClass".equals(methodName)) continue;
            String attributeName = StrUtil.downFirstChar(methodName.substring(3));
            fieldNames.add(attributeName);
        }
    }

    public Object newInstance() {
        try {
            if (this.emfCreateMethod != null) {
                return this.emfCreateMethod.invoke(this.emfFactory, new Object[0]);
            }
            Class<?> clazz = this.getClazz();
            return clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getValue(Object object, String attribute) {
        if (object == null) {
            return null;
        }
        Method getter = this.resolveGetter(attribute);
        if (getter == null) {
            return null;
        }
        try {
            return getter.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw Reflector.handleIllegalAccess(e);
        }
    }

    private Method resolveGetter(String propertyName) {
        return this.getterCache.computeIfAbsent(propertyName, this::loadGetter);
    }

    private Method loadGetter(String propertyName) {
        Class<?> clazz = this.getClazz();
        String uppercasePropertyName = StrUtil.cap(propertyName);
        try {
            return clazz.getMethod("get" + uppercasePropertyName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return clazz.getMethod(uppercasePropertyName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                try {
                    return clazz.getMethod("is" + uppercasePropertyName, new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    return null;
                }
            }
        }
    }

    @Deprecated
    public Object setValue(Object object, String attribute, Object value, String type) {
        return this.setValue(object, attribute, value);
    }

    public Object setValue(Object object, String attribute, Object value) {
        if (object == null) {
            return null;
        }
        for (Method setter : this.resolveSetters(attribute)) {
            Object result = this.invokeSetter(object, setter, value);
            if (result == INCOMPATIBLE) continue;
            return result;
        }
        if (this.emfCreateMethod != null) {
            try {
                Method getMethod = this.clazz.getMethod("get" + StrUtil.cap(attribute), new Class[0]);
                Object collection = getMethod.invoke(object, new Object[0]);
                Method addMethod = collection.getClass().getMethod("add", Object.class);
                return addMethod.invoke(collection, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Object invokeSetter(Object object, Method setter, Object value) {
        Object param;
        Class<?> targetType = setter.getParameterTypes()[0];
        if (setter.isVarArgs()) {
            targetType = targetType.getComponentType();
        }
        if ((param = this.coerce(value, targetType)) == INCOMPATIBLE) {
            return INCOMPATIBLE;
        }
        if (setter.isVarArgs()) {
            Object array = Array.newInstance(targetType, 1);
            Array.set(array, 0, param);
            param = array;
        }
        try {
            return setter.invoke(object, param);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw Reflector.handleIllegalAccess(e);
        }
    }

    private static AssertionError handleIllegalAccess(IllegalAccessException e) {
        throw new AssertionError("this should not occur since we only search for public methods", e);
    }

    private Object coerce(Object value, Class<?> targetType) {
        if (value == null) {
            return targetType.isPrimitive() ? INCOMPATIBLE : null;
        }
        if (targetType.isInstance(value)) {
            return value;
        }
        if (value instanceof String) {
            return this.coerce((String)value, targetType);
        }
        return INCOMPATIBLE;
    }

    private Object coerce(String value, Class<?> targetType) {
        switch (targetType.getName()) {
            case "boolean": 
            case "java.lang.Boolean": {
                return Boolean.valueOf(value);
            }
            case "byte": 
            case "java.lang.Byte": {
                return Byte.valueOf(value);
            }
            case "short": 
            case "java.lang.Short": {
                return Short.valueOf(value);
            }
            case "char": 
            case "java.lang.Character": {
                if (value.length() != 1) {
                    return INCOMPATIBLE;
                }
                return Character.valueOf(value.charAt(0));
            }
            case "int": 
            case "java.lang.Integer": {
                return Integer.valueOf(value);
            }
            case "long": 
            case "java.lang.Long": {
                return Long.valueOf(value);
            }
            case "float": 
            case "java.lang.Float": {
                return Float.valueOf(value);
            }
            case "double": 
            case "java.lang.Double": {
                return Double.valueOf(value);
            }
        }
        if (Enum.class.isAssignableFrom(targetType)) {
            return this.coerceToEnum(value, targetType);
        }
        return INCOMPATIBLE;
    }

    private Object coerceToEnum(String value, Class targetType) {
        Class<?> enumClass;
        int dotIndex = value.lastIndexOf(46);
        if (dotIndex < 0) {
            try {
                return Enum.valueOf(targetType, value);
            }
            catch (IllegalArgumentException ignored) {
                return INCOMPATIBLE;
            }
        }
        String className = value.substring(0, dotIndex);
        String constantName = value.substring(dotIndex + 1);
        try {
            enumClass = Class.forName(className);
        }
        catch (ClassNotFoundException ignored) {
            return INCOMPATIBLE;
        }
        if (Enum.class.isAssignableFrom(enumClass)) {
            return Enum.valueOf(enumClass, constantName);
        }
        return INCOMPATIBLE;
    }

    private List<Method> resolveSetters(String propertyName) {
        return this.setterCache.computeIfAbsent(propertyName, this::loadSetters);
    }

    private List<Method> loadSetters(String propertyName) {
        String uppercasedPropertyName = StrUtil.cap(propertyName);
        HashSet<String> names = new HashSet<String>(2);
        names.add("set" + uppercasedPropertyName);
        names.add("with" + uppercasedPropertyName);
        return this.loadMethods(names);
    }

    public void removeValue(Object object, String attribute, Object target) {
        if (object == null) {
            return;
        }
        Iterator<Method> iterator = this.resolveUnsetters(attribute).iterator();
        while (iterator.hasNext()) {
            Method setter;
            Object result = this.invokeSetter(object, setter, (setter = iterator.next()).getName().startsWith("set") ? null : target);
            if (result == INCOMPATIBLE) continue;
            return;
        }
    }

    private List<Method> resolveUnsetters(String propertyName) {
        return this.unsetterCache.computeIfAbsent(propertyName, this::loadUnsetters);
    }

    private List<Method> loadUnsetters(String propertyName) {
        String uppercasedPropertyName = StrUtil.cap(propertyName);
        HashSet<String> names = new HashSet<String>(2);
        names.add("set" + uppercasedPropertyName);
        names.add("without" + uppercasedPropertyName);
        return this.loadMethods(names);
    }

    private List<Method> loadMethods(Set<String> names) {
        return Arrays.stream(this.getClazz().getMethods()).filter(method -> method.getParameterCount() == 1 && names.contains(method.getName())).collect(Collectors.toList());
    }

    public void removeObject(Object object) {
        try {
            Class<?> clazz = this.getClazz();
            Method removeYou = clazz.getMethod("removeYou", new Class[0]);
            removeYou.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

