/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;

public class YamlGenerator {
    private static final Pattern SIMPLE_VALUE_PATTERN = Pattern.compile("[a-zA-Z0-9_.]+");

    public static String serialize(Iterable<? extends Map<String, String>> events) {
        StringBuilder builder = new StringBuilder();
        try {
            YamlGenerator.serialize(events, (Appendable)builder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.toString();
    }

    public static void serialize(Iterable<? extends Map<String, String>> events, Appendable writer) throws IOException {
        for (Map<String, String> map : events) {
            YamlGenerator.serialize(map, writer);
        }
    }

    public static String serialize(Map<String, String> event) {
        StringBuilder writer = new StringBuilder();
        try {
            YamlGenerator.serialize(event, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static void serialize(Map<String, String> event, Appendable writer) throws IOException {
        String prefix = "- ";
        for (Map.Entry<String, String> keyValuePair : event.entrySet()) {
            writer.append(prefix);
            writer.append(keyValuePair.getKey());
            writer.append(": ");
            YamlGenerator.encapsulate(keyValuePair.getValue(), writer);
            writer.append('\n');
            prefix = "  ";
        }
        writer.append('\n');
    }

    public static String encapsulate(String value) {
        if (SIMPLE_VALUE_PATTERN.matcher(value).matches()) {
            return value;
        }
        return YamlGenerator.quote(value);
    }

    public static void encapsulate(String value, Appendable writer) throws IOException {
        if (SIMPLE_VALUE_PATTERN.matcher(value).matches()) {
            writer.append(value);
            return;
        }
        YamlGenerator.quote(value, writer);
    }

    public static String quote(String value) {
        return "\"" + value.replace("\"", "\\\"") + "\"";
    }

    public static void quote(String value, Appendable writer) throws IOException {
        writer.append('\"');
        writer.append(value.replace("\"", "\\\""));
        writer.append('\"');
    }
}

