/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.encoder;

import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.codegen.CodeGenerator;
import io.fury.codegen.CodegenContext;
import io.fury.codegen.Expression;
import io.fury.codegen.ExpressionUtils;
import io.fury.format.encoder.ArrayDataForEach;
import io.fury.format.encoder.BaseBinaryEncoderBuilder;
import io.fury.format.encoder.GeneratedArrayEncoder;
import io.fury.format.row.binary.BinaryArray;
import io.fury.format.row.binary.writer.BinaryArrayWriter;
import io.fury.format.type.TypeInference;
import io.fury.type.TypeUtils;
import io.fury.util.LoggerFactory;
import io.fury.util.StringUtils;
import io.fury.util.function.SerializableBiFunction;
import io.fury.util.function.SerializableFunction;
import java.io.Serializable;
import org.apache.arrow.vector.types.pojo.Field;
import org.slf4j.Logger;

public class ArrayEncoderBuilder
extends BaseBinaryEncoderBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ArrayEncoderBuilder.class);
    private static final String FIELD_NAME = "field";
    private static final String ROOT_ARRAY_NAME = "array";
    private static final String ROOT_ARRAY_WRITER_NAME = "arrayWriter";
    private static final TypeToken<Field> ARROW_FIELD_TYPE = TypeToken.of(Field.class);
    private final TypeToken<?> arrayToken;

    public ArrayEncoderBuilder(Class<?> arrayCls, Class<?> beanClass) {
        this(TypeToken.of(arrayCls), TypeToken.of(beanClass));
    }

    public ArrayEncoderBuilder(TypeToken<?> clsType, TypeToken<?> beanType) {
        super(new CodegenContext(), beanType);
        this.arrayToken = clsType;
        this.ctx.reserveName(ROOT_ARRAY_WRITER_NAME);
        this.ctx.reserveName(ROOT_ARRAY_NAME);
        Expression.Literal clsExpr = new Expression.Literal((Object)TypeUtils.getRawType(this.arrayToken), TypeUtils.CLASS_TYPE);
        this.ctx.addField(true, Class.class.getName(), "arrayClass", (Expression)clsExpr);
    }

    public String genCode() {
        this.ctx.setPackage(CodeGenerator.getPackage((Class)this.beanClass));
        String className = this.codecClassName(this.beanClass, TypeInference.inferTypeName(this.arrayToken));
        this.ctx.setClassName(className);
        this.ctx.implementsInterfaces(new String[]{this.ctx.type(GeneratedArrayEncoder.class)});
        String constructorCode = StringUtils.format((String)"${field} = (${fieldType})${references}[0];\n${arrayWriter} = (${arrayWriterType})${references}[1];\n${fury} = (${furyType})${references}[2];\n", (Object[])new Object[]{"references", "references", FIELD_NAME, FIELD_NAME, "fieldType", this.ctx.type(Field.class), ROOT_ARRAY_WRITER_NAME, ROOT_ARRAY_WRITER_NAME, "arrayWriterType", this.ctx.type(BinaryArrayWriter.class), "fury", "fury", "furyType", this.ctx.type(Fury.class)});
        this.ctx.addField(this.ctx.type(Field.class), FIELD_NAME);
        this.ctx.addField(this.ctx.type(BinaryArrayWriter.class), ROOT_ARRAY_WRITER_NAME);
        this.ctx.addField(this.ctx.type(Fury.class), "fury");
        Expression encodeExpr = this.buildEncodeExpression();
        String encodeCode = encodeExpr.genCode(this.ctx).code();
        this.ctx.overrideMethod("toArray", encodeCode, BinaryArray.class, new Object[]{Object.class, "obj"});
        Expression decodeExpr = this.buildDecodeExpression();
        String decodeCode = decodeExpr.genCode(this.ctx).code();
        this.ctx.overrideMethod("fromArray", decodeCode, Object.class, new Object[]{BinaryArray.class, ROOT_ARRAY_NAME});
        this.ctx.addConstructor(constructorCode, new Object[]{Object[].class, "references"});
        long startTime = System.nanoTime();
        String code = this.ctx.genCode();
        long durationMs = (System.nanoTime() - startTime) / 1000000L;
        LOG.debug("Generate array codec for class {} take {} us", (Object)this.beanClass, (Object)durationMs);
        return code;
    }

    public Expression buildEncodeExpression() {
        Expression.Reference arrayWriter = new Expression.Reference(ROOT_ARRAY_WRITER_NAME, arrayWriterTypeToken, false);
        Expression.ListExpression expressions = new Expression.ListExpression(new Expression[0]);
        Expression.Reference inputObject = new Expression.Reference("obj", TypeUtils.COLLECTION_TYPE, false);
        Expression.Cast array = new Expression.Cast((Expression)inputObject, this.arrayToken, this.ctx.newName(TypeUtils.getRawType(this.arrayToken)));
        expressions.add((Expression)array);
        Expression.Reference fieldExpr = new Expression.Reference(FIELD_NAME, ARROW_FIELD_TYPE, false);
        Expression listExpression = this.serializeForArray((Expression)array, (Expression)arrayWriter, this.arrayToken, (Expression)fieldExpr);
        expressions.add(listExpression);
        expressions.add((Expression)new Expression.Return((Expression)new Expression.Invoke((Expression)arrayWriter, "toArray", TypeToken.of(BinaryArray.class))));
        return expressions;
    }

    public Expression buildDecodeExpression() {
        Expression.ListExpression expressions = new Expression.ListExpression(new Expression[0]);
        Expression collection = this.newCollection(this.arrayToken);
        Expression.Reference arrayRef = new Expression.Reference(ROOT_ARRAY_NAME, binaryArrayTypeToken, false);
        Expression value = this.deserializeForCollection((Expression)arrayRef, collection, TypeUtils.getElementType(this.arrayToken));
        expressions.add(value);
        expressions.add((Expression)new Expression.Return(collection));
        return expressions;
    }

    private Expression deserializeForCollection(Expression arrayData, Expression collection, TypeToken<?> elemType) {
        ArrayDataForEach addElemsOp = new ArrayDataForEach(arrayData, elemType, (SerializableBiFunction<Expression, Expression, Expression>)(SerializableBiFunction & Serializable)(i, value) -> new Expression.Invoke(collection, "add", new Expression[]{this.deserializeFor((Expression)value, elemType)}), (SerializableFunction<Expression, Expression>)(SerializableFunction & Serializable)i -> new Expression.Invoke(collection, "add", new Expression[]{ExpressionUtils.nullValue((TypeToken)elemType)}));
        return new Expression.ListExpression(new Expression[]{collection, addElemsOp, collection});
    }
}

