/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.encoder;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.fury.builder.CodecBuilder;
import io.fury.codegen.CodeGenerator;
import io.fury.codegen.CodegenContext;
import io.fury.codegen.Expression;
import io.fury.codegen.ExpressionUtils;
import io.fury.format.encoder.ArrayDataForEach;
import io.fury.format.encoder.GeneratedRowEncoder;
import io.fury.format.row.Row;
import io.fury.format.row.binary.BinaryArray;
import io.fury.format.row.binary.BinaryRow;
import io.fury.format.row.binary.writer.BinaryArrayWriter;
import io.fury.format.row.binary.writer.BinaryRowWriter;
import io.fury.format.row.binary.writer.BinaryWriter;
import io.fury.format.type.DataTypes;
import io.fury.memory.MemoryBuffer;
import io.fury.type.TypeUtils;
import io.fury.util.DateTimeUtils;
import io.fury.util.ReflectionUtils;
import io.fury.util.StringUtils;
import io.fury.util.function.SerializableBiFunction;
import io.fury.util.function.SerializableFunction;
import io.fury.util.function.SerializableTriFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;

public abstract class BaseBinaryEncoderBuilder
extends CodecBuilder {
    protected static final String REFERENCES_NAME = "references";
    protected static final TypeToken<Schema> SCHEMA_TYPE = TypeToken.of(Schema.class);
    protected static final TypeToken<Field> ARROW_FIELD_TYPE = TypeToken.of(Field.class);
    protected static TypeToken<Schema> schemaTypeToken = TypeToken.of(Schema.class);
    protected static TypeToken<BinaryWriter> writerTypeToken = TypeToken.of(BinaryWriter.class);
    protected static TypeToken<BinaryRowWriter> rowWriterTypeToken = TypeToken.of(BinaryRowWriter.class);
    protected static TypeToken<BinaryArrayWriter> arrayWriterTypeToken = TypeToken.of(BinaryArrayWriter.class);
    protected static TypeToken<Row> rowTypeToken = TypeToken.of(Row.class);
    protected static TypeToken<BinaryRow> binaryRowTypeToken = TypeToken.of(BinaryRow.class);
    protected static TypeToken<BinaryArray> binaryArrayTypeToken = TypeToken.of(BinaryArray.class);
    protected final Map<TypeToken<?>, Expression.Reference> arrayWriterMap = new HashMap();
    protected final Map<TypeToken<?>, Expression.Reference> beanEncoderMap = new HashMap();
    protected final Map<TypeToken<?>, Expression.Reference> rowWriterMap = new HashMap();

    public BaseBinaryEncoderBuilder(CodegenContext context, Class<?> beanClass) {
        this(context, TypeToken.of(beanClass));
    }

    public BaseBinaryEncoderBuilder(CodegenContext context, TypeToken<?> beanType) {
        super(context, beanType);
        this.ctx.reserveName(REFERENCES_NAME);
        this.ctx.addImport(BinaryRow.class.getPackage().getName() + ".*");
        this.ctx.addImport(BinaryWriter.class.getPackage().getName() + ".*");
        this.ctx.addImport(Schema.class.getPackage().getName() + ".*");
    }

    public String codecClassName(Class<?> beanClass) {
        return this.codecClassName(beanClass, "");
    }

    public String codecClassName(Class<?> beanClass, String prefix) {
        String name = ReflectionUtils.getClassNameWithoutPackage(beanClass) + prefix + this.codecSuffix() + CodeGenerator.getClassUniqueId(beanClass);
        return name.replace("$", "_");
    }

    protected String codecSuffix() {
        return "RowCodec";
    }

    public String codecQualifiedClassName(Class<?> beanClass) {
        return CodeGenerator.getPackage(beanClass) + "." + this.codecClassName(beanClass);
    }

    public String codecQualifiedClassName(Class<?> beanClass, String prefix) {
        return CodeGenerator.getPackage(beanClass) + "." + this.codecClassName(beanClass, prefix);
    }

    protected Expression serializeFor(Expression ordinal, Expression inputObject, Expression writer, TypeToken<?> typeToken, Expression arrowField) {
        Class rawType = TypeUtils.getRawType(typeToken);
        if (TypeUtils.isPrimitive((Class)rawType)) {
            return new Expression.ListExpression(new Expression[]{new Expression.Invoke(writer, "write", new Expression[]{ordinal, inputObject})});
        }
        if (TypeUtils.isBoxed((Class)rawType)) {
            return this.setValueOrNull(writer, ordinal, inputObject, inputObject);
        }
        if (rawType == BigDecimal.class) {
            return this.setValueOrNull(writer, ordinal, inputObject, inputObject);
        }
        if (rawType == BigInteger.class) {
            Expression.Invoke value = new Expression.Invoke(inputObject, "toByteArray", TypeToken.of(byte[].class));
            return this.setValueOrNull(writer, ordinal, inputObject, (Expression)value);
        }
        if (rawType == LocalDate.class) {
            Expression.StaticInvoke value = new Expression.StaticInvoke(DateTimeUtils.class, "localDateToDays", TypeUtils.PRIMITIVE_INT_TYPE, false, new Expression[]{inputObject});
            return this.setValueOrNull(writer, ordinal, inputObject, (Expression)value);
        }
        if (rawType == Date.class) {
            Expression.StaticInvoke value = new Expression.StaticInvoke(DateTimeUtils.class, "fromJavaDate", TypeUtils.PRIMITIVE_INT_TYPE, false, new Expression[]{inputObject});
            return this.setValueOrNull(writer, ordinal, inputObject, (Expression)value);
        }
        if (rawType == Timestamp.class) {
            Expression.StaticInvoke value = new Expression.StaticInvoke(DateTimeUtils.class, "fromJavaTimestamp", TypeUtils.PRIMITIVE_LONG_TYPE, false, new Expression[]{inputObject});
            return this.setValueOrNull(writer, ordinal, inputObject, (Expression)value);
        }
        if (rawType == Instant.class) {
            Expression.StaticInvoke value = new Expression.StaticInvoke(DateTimeUtils.class, "instantToMicros", TypeUtils.PRIMITIVE_LONG_TYPE, false, new Expression[]{inputObject});
            return this.setValueOrNull(writer, ordinal, inputObject, (Expression)value);
        }
        if (rawType == String.class) {
            return this.setValueOrNull(writer, ordinal, inputObject, inputObject);
        }
        if (rawType.isEnum()) {
            Expression.Invoke value = new Expression.Invoke(inputObject, "name", TypeUtils.STRING_TYPE);
            return this.setValueOrNull(writer, ordinal, inputObject, (Expression)value);
        }
        if (rawType.isArray() || TypeUtils.ITERABLE_TYPE.isSupertypeOf(typeToken)) {
            Expression.Invoke offset = new Expression.Invoke(writer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE);
            Expression serializeArray = this.serializeForArray(inputObject, writer, typeToken, arrowField);
            Expression.Arithmetic size = ExpressionUtils.subtract((Expression)new Expression.Invoke(writer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE), (Expression)offset);
            Expression.Invoke setOffsetAndSize = new Expression.Invoke(writer, "setOffsetAndSize", new Expression[]{ordinal, offset, size});
            Expression.ListExpression expression = new Expression.ListExpression(new Expression[]{offset, serializeArray, size, setOffsetAndSize});
            return new Expression.If(ExpressionUtils.eqNull((Expression)inputObject), (Expression)new Expression.Invoke(writer, "setNullAt", new Expression[]{ordinal}), (Expression)expression);
        }
        if (TypeUtils.MAP_TYPE.isSupertypeOf(typeToken)) {
            return this.serializeForMap(ordinal, writer, inputObject, typeToken, arrowField);
        }
        if (TypeUtils.isBean((Class)rawType)) {
            return this.serializeForBean(ordinal, writer, inputObject, typeToken, arrowField);
        }
        return this.serializeForObject(ordinal, writer, inputObject);
    }

    protected Expression serializeForArray(Expression inputObject, Expression writer, TypeToken<?> typeToken, Expression arrowField) {
        return this.serializeForArray(inputObject, writer, typeToken, arrowField, false);
    }

    protected Expression serializeForArray(Expression inputObject, Expression writer, TypeToken<?> typeToken, Expression arrowField, boolean reuse) {
        Expression.Reference arrayWriter = this.getOrCreateArrayWriter(typeToken, arrowField, writer, reuse);
        Expression.StaticInvoke arrayElementField = new Expression.StaticInvoke(DataTypes.class, "arrayElementField", "elemField", ARROW_FIELD_TYPE, false, new Expression[]{arrowField});
        Class rawType = TypeUtils.getRawType(typeToken);
        if (rawType.isArray()) {
            Expression.FieldValue length = new Expression.FieldValue(inputObject, "length", TypeUtils.PRIMITIVE_INT_TYPE);
            Expression.Invoke reset = new Expression.Invoke((Expression)arrayWriter, "reset", new Expression[]{length});
            if (rawType.getComponentType().isPrimitive()) {
                return new Expression.ListExpression(new Expression[]{reset, new Expression.Invoke((Expression)arrayWriter, "fromPrimitiveArray", new Expression[]{inputObject}), arrayWriter});
            }
            Expression.ForEach forEach = new Expression.ForEach(inputObject, (SerializableBiFunction & Serializable)(i, value) -> this.serializeFor((Expression)i, (Expression)value, (Expression)arrayWriter, (TypeToken<?>)Objects.requireNonNull(typeToken.getComponentType()), (Expression)arrayElementField));
            return new Expression.ListExpression(new Expression[]{reset, forEach, arrayWriter});
        }
        if (TypeUtils.getRawType(typeToken) == Iterable.class) {
            Expression.ListFromIterable listFromIterable = new Expression.ListFromIterable(inputObject);
            Expression.Invoke size = new Expression.Invoke((Expression)listFromIterable, "size", TypeUtils.PRIMITIVE_INT_TYPE);
            Expression.Invoke reset = new Expression.Invoke((Expression)arrayWriter, "reset", new Expression[]{size});
            Expression.ForEach forEach = new Expression.ForEach((Expression)listFromIterable, (SerializableBiFunction & Serializable)(i, value) -> this.serializeFor((Expression)i, (Expression)value, (Expression)arrayWriter, (TypeToken<?>)TypeUtils.getElementType((TypeToken)typeToken), (Expression)arrayElementField));
            return new Expression.ListExpression(new Expression[]{reset, forEach, arrayWriter});
        }
        Expression.Invoke size = new Expression.Invoke(inputObject, "size", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke reset = new Expression.Invoke((Expression)arrayWriter, "reset", new Expression[]{size});
        Expression.ForEach forEach = new Expression.ForEach(inputObject, (SerializableBiFunction & Serializable)(i, value) -> this.serializeFor((Expression)i, (Expression)value, (Expression)arrayWriter, (TypeToken<?>)TypeUtils.getElementType((TypeToken)typeToken), (Expression)arrayElementField));
        return new Expression.ListExpression(new Expression[]{reset, forEach, arrayWriter});
    }

    protected Expression.Reference getOrCreateArrayWriter(TypeToken<?> typeToken, Expression arrayDataType, Expression writer) {
        return this.getOrCreateArrayWriter(typeToken, arrayDataType, writer, false);
    }

    protected Expression.Reference getOrCreateArrayWriter(TypeToken<?> typeToken, Expression arrayDataType, Expression writer, boolean reuse) {
        if (reuse) {
            return (Expression.Reference)writer;
        }
        return this.arrayWriterMap.computeIfAbsent(typeToken, t -> {
            String name = this.ctx.newName("arrayWriter");
            this.ctx.addField(this.ctx.type(BinaryArrayWriter.class), name, (Expression)new Expression.NewInstance(arrayWriterTypeToken, new Expression[]{arrayDataType, writer}));
            return new Expression.Reference(name, arrayWriterTypeToken, false);
        });
    }

    protected Expression serializeForMap(Expression ordinal, Expression writer, Expression inputObject, TypeToken<?> typeToken, Expression arrowField) {
        Expression.StaticInvoke keyArrayField = new Expression.StaticInvoke(DataTypes.class, "keyArrayFieldForMap", "keyArrayField", ARROW_FIELD_TYPE, false, new Expression[]{arrowField});
        Expression.StaticInvoke valueArrayField = new Expression.StaticInvoke(DataTypes.class, "itemArrayFieldForMap", "valueArrayField", ARROW_FIELD_TYPE, false, new Expression[]{arrowField});
        TypeToken supertype = typeToken.getSupertype(Map.class);
        TypeToken keySetType = supertype.resolveType(TypeUtils.KEY_SET_RETURN_TYPE);
        TypeToken valuesType = supertype.resolveType(TypeUtils.VALUES_RETURN_TYPE);
        Expression.Invoke keySet = new Expression.Invoke(inputObject, "keySet", keySetType);
        Expression keySerializationExpr = this.serializeForArray((Expression)keySet, writer, keySetType, (Expression)keyArrayField);
        Expression.Invoke values = new Expression.Invoke(inputObject, "values", valuesType);
        Expression valueSerializationExpr = this.serializeForArray((Expression)values, writer, valuesType, (Expression)valueArrayField);
        Expression.Invoke offset = new Expression.Invoke(writer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke preserve = new Expression.Invoke(writer, "writeDirectly", new Expression[]{new Expression.Literal((Object)-1, TypeUtils.PRIMITIVE_INT_TYPE)});
        Expression.Invoke writeKeyArrayNumBytes = new Expression.Invoke(writer, "writeDirectly", new Expression[]{offset, new Expression.Invoke(keySerializationExpr, "size", TypeUtils.PRIMITIVE_INT_TYPE)});
        Expression.Arithmetic size = ExpressionUtils.subtract((Expression)new Expression.Invoke(writer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE), (Expression)offset);
        Expression.Invoke setOffsetAndSize = new Expression.Invoke(writer, "setOffsetAndSize", new Expression[]{ordinal, offset, size});
        Expression.ListExpression expression = new Expression.ListExpression(new Expression[]{offset, preserve, keySerializationExpr, writeKeyArrayNumBytes, valueSerializationExpr, setOffsetAndSize});
        return new Expression.If(ExpressionUtils.eqNull((Expression)inputObject), (Expression)new Expression.Invoke(writer, "setNullAt", new Expression[]{ordinal}), (Expression)expression);
    }

    protected Expression serializeForBean(Expression ordinal, Expression writer, Expression inputObject, TypeToken<?> typeToken, Expression structField) {
        Expression.Reference rowWriter;
        Class rawType = TypeUtils.getRawType(typeToken);
        Expression.Reference beanEncoder = this.beanEncoderMap.get(typeToken);
        if (beanEncoder == null) {
            Expression.StaticInvoke schema = new Expression.StaticInvoke(DataTypes.class, "schemaFromStructField", "schema", SCHEMA_TYPE, false, new Expression[]{structField});
            String rowWriterName = this.ctx.newName(StringUtils.uncapitalize((String)(rawType.getSimpleName() + "RowWriter")));
            Expression.NewInstance newRowWriter = new Expression.NewInstance(rowWriterTypeToken, new Expression[]{schema, writer});
            this.ctx.addField(this.ctx.type(rowWriterTypeToken), rowWriterName, (Expression)newRowWriter);
            Preconditions.checkArgument((!this.codecClassName(rawType).contains(".") ? 1 : 0) != 0);
            String encoderName = this.ctx.newName(StringUtils.uncapitalize((String)this.codecClassName(rawType)));
            String encoderClass = this.codecQualifiedClassName(rawType);
            TypeToken codecTypeToken = TypeToken.of(GeneratedRowEncoder.class);
            Expression.NewInstance newEncoder = new Expression.NewInstance(codecTypeToken, encoderClass, new Expression[]{ExpressionUtils.newObjectArray((Expression[])new Expression[]{schema, newRowWriter, this.furyRef})});
            this.ctx.addField(encoderClass, encoderName, (Expression)newEncoder);
            rowWriter = new Expression.Reference(rowWriterName, rowWriterTypeToken);
            this.rowWriterMap.put(typeToken, rowWriter);
            beanEncoder = new Expression.Reference(encoderName, codecTypeToken);
            this.beanEncoderMap.put(typeToken, beanEncoder);
        }
        rowWriter = this.rowWriterMap.get(typeToken);
        Expression.Invoke reset = new Expression.Invoke((Expression)rowWriter, "reset", new Expression[0]);
        Expression.Invoke offset = new Expression.Invoke(writer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke toRow = new Expression.Invoke((Expression)beanEncoder, "toRow", new Expression[]{inputObject});
        Expression.Arithmetic size = ExpressionUtils.subtract((Expression)new Expression.Invoke(writer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE), (Expression)offset);
        Expression.Invoke setOffsetAndSize = new Expression.Invoke(writer, "setOffsetAndSize", new Expression[]{ordinal, offset, size});
        Expression.ListExpression expression = new Expression.ListExpression(new Expression[]{offset, reset, toRow, size, setOffsetAndSize});
        return new Expression.If(ExpressionUtils.eqNull((Expression)inputObject), (Expression)new Expression.Invoke(writer, "setNullAt", new Expression[]{ordinal}), (Expression)expression);
    }

    protected Expression serializeForObject(Expression ordinal, Expression writer, Expression inputObject) {
        Expression.Invoke offset = new Expression.Invoke(writer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Invoke buffer = new Expression.Invoke(writer, "getBuffer", "buffer", TypeToken.of(MemoryBuffer.class));
        Expression.Invoke setWriterIndex = new Expression.Invoke((Expression)buffer, "writerIndex", new Expression[]{offset});
        Expression.Invoke serialize = new Expression.Invoke((Expression)this.furyRef, "serialize", new Expression[]{buffer, inputObject});
        Expression.Invoke newWriterIndex = new Expression.Invoke((Expression)buffer, "writerIndex", "writerIndex", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.Arithmetic size = ExpressionUtils.subtract((Expression)newWriterIndex, (Expression)offset, (String)"size");
        Expression.Invoke increaseWriterIndexToAligned = new Expression.Invoke(writer, "increaseWriterIndexToAligned", new Expression[]{size});
        Expression.Invoke setOffsetAndSize = new Expression.Invoke(writer, "setOffsetAndSize", new Expression[]{ordinal, offset, size});
        Expression.ListExpression expression = new Expression.ListExpression(new Expression[]{offset, buffer, setWriterIndex, serialize, increaseWriterIndexToAligned, setOffsetAndSize});
        return new Expression.If(ExpressionUtils.eqNull((Expression)inputObject), (Expression)new Expression.Invoke(writer, "setNullAt", new Expression[]{ordinal}), (Expression)expression);
    }

    protected Expression setValueOrNull(Expression writer, Expression ordinal, Expression inputObject, Expression value) {
        Expression.Invoke action = new Expression.Invoke(writer, "write", new Expression[]{ordinal, value});
        return new Expression.If(ExpressionUtils.eqNull((Expression)inputObject), (Expression)new Expression.Invoke(writer, "setNullAt", new Expression[]{ordinal}), (Expression)action);
    }

    protected Expression deserializeFor(Expression value, TypeToken<?> typeToken) {
        Class rawType = TypeUtils.getRawType(typeToken);
        if (TypeUtils.isPrimitive((Class)rawType) || TypeUtils.isBoxed((Class)rawType)) {
            return value;
        }
        if (rawType == BigDecimal.class) {
            return value;
        }
        if (rawType == BigInteger.class) {
            return new Expression.NewInstance(TypeUtils.BIG_INTEGER_TYPE, new Expression[]{value});
        }
        if (rawType == LocalDate.class) {
            return new Expression.StaticInvoke(DateTimeUtils.class, "daysToLocalDate", TypeUtils.LOCAL_DATE_TYPE, false, new Expression[]{value});
        }
        if (rawType == Date.class) {
            return new Expression.StaticInvoke(DateTimeUtils.class, "toJavaDate", TypeUtils.DATE_TYPE, false, new Expression[]{value});
        }
        if (rawType == Timestamp.class) {
            return new Expression.StaticInvoke(DateTimeUtils.class, "toJavaTimestamp", TypeUtils.TIMESTAMP_TYPE, false, new Expression[]{value});
        }
        if (rawType == Instant.class) {
            return new Expression.StaticInvoke(DateTimeUtils.class, "microsToInstant", TypeUtils.INSTANT_TYPE, false, new Expression[]{value});
        }
        if (rawType == String.class) {
            return value;
        }
        if (rawType.isEnum()) {
            return ExpressionUtils.valueOf(typeToken, (Expression)value);
        }
        if (rawType.isArray()) {
            return this.deserializeForArray(value, typeToken);
        }
        if (TypeUtils.ITERABLE_TYPE.isSupertypeOf(typeToken)) {
            return this.deserializeForCollection(value, typeToken);
        }
        if (TypeUtils.MAP_TYPE.isSupertypeOf(typeToken)) {
            return this.deserializeForMap(value, typeToken);
        }
        if (TypeUtils.isBean((Class)rawType)) {
            return this.deserializeForBean(value, typeToken);
        }
        return this.deserializeForObject(value, typeToken);
    }

    protected Expression deserializeForBean(Expression row, TypeToken<?> typeToken) {
        Expression.Reference beanEncoder = this.beanEncoderMap.get(typeToken);
        if (beanEncoder == null) {
            throw new IllegalStateException("beanEncoder should have be added in serializeForBean()");
        }
        Expression.Invoke beanObj = new Expression.Invoke((Expression)beanEncoder, "fromRow", TypeUtils.OBJECT_TYPE, false, new Expression[]{row});
        return new Expression.Cast((Expression)beanObj, typeToken, "bean");
    }

    protected Expression deserializeForMap(Expression mapData, TypeToken<?> typeToken) {
        Expression javaMap = this.newMap(typeToken);
        TypeToken supertype = typeToken.getSupertype(Map.class);
        TypeToken keySetType = supertype.resolveType(TypeUtils.KEY_SET_RETURN_TYPE);
        TypeToken keysType = TypeUtils.getCollectionType((TypeToken)keySetType);
        TypeToken valuesType = supertype.resolveType(TypeUtils.VALUES_RETURN_TYPE);
        Expression.Invoke keyArray = new Expression.Invoke(mapData, "keyArray", binaryArrayTypeToken, false, new Expression[0]);
        Expression.Invoke valueArray = new Expression.Invoke(mapData, "valueArray", binaryArrayTypeToken, false, new Expression[0]);
        Expression keyJavaArray = TypeUtils.ITERABLE_TYPE.isSupertypeOf(keysType) ? this.deserializeForCollection((Expression)keyArray, keysType) : this.deserializeForArray((Expression)keyArray, keysType);
        Expression valueJavaArray = TypeUtils.ITERABLE_TYPE.isSupertypeOf(valuesType) ? this.deserializeForCollection((Expression)valueArray, valuesType) : this.deserializeForArray((Expression)valueArray, valuesType);
        Expression.ZipForEach put = new Expression.ZipForEach(keyJavaArray, valueJavaArray, (SerializableTriFunction & Serializable)(i, key, value) -> new Expression.If(ExpressionUtils.notNull((Expression)key), (Expression)new Expression.Invoke(javaMap, "put", new Expression[]{key, value})));
        return new Expression.ListExpression(new Expression[]{javaMap, put, javaMap});
    }

    protected Expression deserializeForCollection(Expression arrayData, TypeToken<?> typeToken) {
        Expression collection = this.newCollection(typeToken);
        try {
            TypeToken elemType = TypeUtils.getElementType(typeToken);
            ArrayDataForEach addElemsOp = new ArrayDataForEach(arrayData, elemType, (SerializableBiFunction<Expression, Expression, Expression>)(SerializableBiFunction & Serializable)(i, value) -> new Expression.Invoke(collection, "add", new Expression[]{this.deserializeFor((Expression)value, (TypeToken<?>)elemType)}), (SerializableFunction<Expression, Expression>)(SerializableFunction & Serializable)i -> new Expression.Invoke(collection, "add", new Expression[]{ExpressionUtils.nullValue((TypeToken)elemType)}));
            return new Expression.ListExpression(new Expression[]{collection, addElemsOp, collection});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Expression newCollection(TypeToken<?> typeToken) {
        Expression.NewInstance collection;
        Class clazz = TypeUtils.getRawType(typeToken);
        if (TypeToken.of((Class)clazz).isSupertypeOf(TypeToken.of(ArrayList.class))) {
            collection = new Expression.NewInstance(TypeToken.of(ArrayList.class), new Expression[0]);
        } else if (TypeToken.of((Class)clazz).isSupertypeOf(TypeToken.of(HashSet.class))) {
            collection = new Expression.NewInstance(TypeToken.of(HashSet.class), new Expression[0]);
        } else {
            if (ReflectionUtils.isAbstract((Class)clazz) || clazz.isInterface()) {
                String msg = String.format("class %s can't be abstract or interface", clazz);
                throw new UnsupportedOperationException(msg);
            }
            collection = new Expression.NewInstance(typeToken, new Expression[0]);
        }
        return collection;
    }

    protected Expression newMap(TypeToken<?> typeToken) {
        Expression.NewInstance javaMap;
        Class clazz = TypeUtils.getRawType(typeToken);
        if (TypeToken.of((Class)clazz).isSupertypeOf(TypeToken.of(HashMap.class))) {
            javaMap = new Expression.NewInstance(TypeToken.of(HashMap.class), new Expression[0]);
        } else {
            if (ReflectionUtils.isAbstract((Class)clazz) || clazz.isInterface()) {
                String msg = String.format("class %s can't be abstract or interface", clazz);
                throw new UnsupportedOperationException(msg);
            }
            javaMap = new Expression.NewInstance(typeToken, new Expression[0]);
        }
        return javaMap;
    }

    protected Expression deserializeForMultiDimensionArray(Expression arrayData, Expression rootJavaArray, int numDimensions, TypeToken<?> typeToken, Expression[] indexes) {
        Preconditions.checkArgument((numDimensions > 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)typeToken.isArray());
        TypeToken elemType = typeToken.getComponentType();
        if (numDimensions == 2) {
            return new ArrayDataForEach(arrayData, elemType, (SerializableBiFunction<Expression, Expression, Expression>)(SerializableBiFunction & Serializable)(i, value) -> {
                Expression[] newIndexes = Arrays.copyOf(indexes, indexes.length + 1);
                newIndexes[indexes.length] = i;
                Expression elemArr = this.deserializeForArray((Expression)value, (TypeToken<?>)Objects.requireNonNull(typeToken.getComponentType()));
                return new Expression.AssignArrayElem(rootJavaArray, elemArr, newIndexes);
            });
        }
        return new ArrayDataForEach(arrayData, elemType, (SerializableBiFunction<Expression, Expression, Expression>)(SerializableBiFunction & Serializable)(i, value) -> {
            Expression[] newIndexes = Arrays.copyOf(indexes, indexes.length + 1);
            newIndexes[indexes.length] = i;
            return this.deserializeForMultiDimensionArray((Expression)value, rootJavaArray, numDimensions - 1, (TypeToken<?>)elemType, newIndexes);
        });
    }

    protected Expression deserializeForArray(Expression arrayData, TypeToken<?> typeToken) {
        int numDimensions = TypeUtils.getArrayDimensions(typeToken);
        if (numDimensions > 1) {
            Expression.StaticInvoke dimensions = new Expression.StaticInvoke(BinaryArray.class, "getDimensions", "dims", TypeToken.of(int[].class), true, new Expression[]{arrayData, new Expression.Literal((Object)numDimensions, TypeUtils.INT_TYPE)});
            TypeToken innerElemType = TypeUtils.getMultiDimensionArrayElementType(typeToken);
            Class innerElemClass = TypeUtils.getRawType((TypeToken)innerElemType);
            Expression.NewArray rootJavaMultiDimArray = new Expression.NewArray(innerElemClass, numDimensions, (Expression)dimensions);
            Expression op = this.deserializeForMultiDimensionArray(arrayData, (Expression)rootJavaMultiDimArray, numDimensions, typeToken, new Expression[0]);
            return new Expression.If(ExpressionUtils.notNull((Expression)dimensions), (Expression)new Expression.ListExpression(new Expression[]{rootJavaMultiDimArray, op, rootJavaMultiDimArray}), (Expression)ExpressionUtils.nullValue((TypeToken)rootJavaMultiDimArray.type()), false);
        }
        TypeToken elemType = typeToken.getComponentType();
        Class innerElemClass = TypeUtils.getRawType((TypeToken)Objects.requireNonNull(elemType));
        if (Byte.TYPE == innerElemClass) {
            return new Expression.Invoke(arrayData, "toByteArray", TypeUtils.PRIMITIVE_BYTE_ARRAY_TYPE);
        }
        if (Boolean.TYPE == innerElemClass) {
            return new Expression.Invoke(arrayData, "toBooleanArray", TypeUtils.PRIMITIVE_BOOLEAN_ARRAY_TYPE);
        }
        if (Short.TYPE == innerElemClass) {
            return new Expression.Invoke(arrayData, "toShortArray", TypeUtils.PRIMITIVE_SHORT_ARRAY_TYPE);
        }
        if (Integer.TYPE == innerElemClass) {
            return new Expression.Invoke(arrayData, "toIntArray", TypeUtils.PRIMITIVE_INT_ARRAY_TYPE);
        }
        if (Long.TYPE == innerElemClass) {
            return new Expression.Invoke(arrayData, "toLongArray", TypeUtils.PRIMITIVE_LONG_ARRAY_TYPE);
        }
        if (Float.TYPE == innerElemClass) {
            return new Expression.Invoke(arrayData, "toFloatArray", TypeUtils.PRIMITIVE_FLOAT_ARRAY_TYPE);
        }
        if (Double.TYPE == innerElemClass) {
            return new Expression.Invoke(arrayData, "toDoubleArray", TypeUtils.PRIMITIVE_DOUBLE_ARRAY_TYPE);
        }
        Expression.Invoke dim = new Expression.Invoke(arrayData, "numElements", TypeUtils.PRIMITIVE_INT_TYPE);
        Expression.NewArray javaArray = new Expression.NewArray(innerElemClass, (Expression)dim);
        ArrayDataForEach op = new ArrayDataForEach(arrayData, elemType, (SerializableBiFunction<Expression, Expression, Expression>)(SerializableBiFunction & Serializable)(i, value) -> {
            Expression elemValue = this.deserializeFor((Expression)value, (TypeToken<?>)elemType);
            return new Expression.AssignArrayElem((Expression)javaArray, elemValue, new Expression[]{i});
        });
        return new Expression.ListExpression(new Expression[]{javaArray, op, javaArray});
    }

    protected Expression deserializeForObject(Expression value, TypeToken<?> typeToken) {
        return new Expression.Invoke((Expression)this.furyRef, "deserialize", typeToken, new Expression[]{value});
    }
}

