/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.encoder;

import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.codegen.CodeGenerator;
import io.fury.codegen.CompileUnit;
import io.fury.collection.Tuple2;
import io.fury.exception.ClassNotCompatibleException;
import io.fury.format.encoder.ArrayEncoder;
import io.fury.format.encoder.ArrayEncoderBuilder;
import io.fury.format.encoder.EncoderException;
import io.fury.format.encoder.GeneratedArrayEncoder;
import io.fury.format.encoder.GeneratedMapEncoder;
import io.fury.format.encoder.GeneratedRowEncoder;
import io.fury.format.encoder.MapEncoder;
import io.fury.format.encoder.MapEncoderBuilder;
import io.fury.format.encoder.RowEncoder;
import io.fury.format.encoder.RowEncoderBuilder;
import io.fury.format.row.binary.BinaryArray;
import io.fury.format.row.binary.BinaryMap;
import io.fury.format.row.binary.BinaryRow;
import io.fury.format.row.binary.writer.BinaryArrayWriter;
import io.fury.format.row.binary.writer.BinaryRowWriter;
import io.fury.format.type.DataTypes;
import io.fury.format.type.TypeInference;
import io.fury.memory.MemoryBuffer;
import io.fury.memory.MemoryUtils;
import io.fury.type.TypeUtils;
import io.fury.util.LoggerFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.slf4j.Logger;

public class Encoders {
    private static final Logger LOG = LoggerFactory.getLogger(Encoders.class);

    public static <T> RowEncoder<T> bean(Class<T> beanClass) {
        return Encoders.bean(beanClass, 16);
    }

    public static <T> RowEncoder<T> bean(Class<T> beanClass, int initialBufferSize) {
        return Encoders.bean(beanClass, null, initialBufferSize);
    }

    public static <T> RowEncoder<T> bean(Class<T> beanClass, Fury fury) {
        return Encoders.bean(beanClass, fury, 16);
    }

    public static <T> RowEncoder<T> bean(Class<T> beanClass, Fury fury, final int initialBufferSize) {
        Schema schema = TypeInference.inferSchema(beanClass);
        final BinaryRowWriter writer = new BinaryRowWriter(schema);
        final RowEncoder<T> encoder = Encoders.bean(beanClass, writer, fury);
        return new RowEncoder<T>(){

            @Override
            public Schema schema() {
                return encoder.schema();
            }

            @Override
            public T fromRow(BinaryRow row) {
                return encoder.fromRow(row);
            }

            @Override
            public BinaryRow toRow(T obj) {
                writer.setBuffer(MemoryUtils.buffer((int)initialBufferSize));
                writer.reset();
                return encoder.toRow(obj);
            }

            @Override
            public T decode(byte[] bytes) {
                return encoder.decode(bytes);
            }

            @Override
            public byte[] encode(T obj) {
                return encoder.encode(obj);
            }
        };
    }

    public static <T> RowEncoder<T> bean(Class<T> beanClass, BinaryRowWriter writer) {
        return Encoders.bean(beanClass, writer, null);
    }

    public static <T> RowEncoder<T> bean(Class<T> beanClass, final BinaryRowWriter writer, Fury fury) {
        final Schema schema = writer.getSchema();
        try {
            Class<?> rowCodecClass = Encoders.loadOrGenRowCodecClass(beanClass);
            Object[] references = new Object[]{schema, writer, fury};
            final GeneratedRowEncoder codec = rowCodecClass.asSubclass(GeneratedRowEncoder.class).getConstructor(Object[].class).newInstance(new Object[]{references});
            final long schemaHash = DataTypes.computeSchemaHash(schema);
            return new RowEncoder<T>(){
                private final MemoryBuffer buffer = MemoryUtils.buffer((int)16);

                @Override
                public Schema schema() {
                    return schema;
                }

                @Override
                public T fromRow(BinaryRow row) {
                    return codec.fromRow(row);
                }

                @Override
                public BinaryRow toRow(T obj) {
                    return codec.toRow(obj);
                }

                @Override
                public T decode(byte[] bytes) {
                    MemoryBuffer buffer = MemoryUtils.wrap((byte[])bytes);
                    long peerSchemaHash = buffer.readLong();
                    if (peerSchemaHash != schemaHash) {
                        throw new ClassNotCompatibleException(String.format("Schema is not consistent, encoder schema is %s. self/peer schema hash are %s/%s. Please check writer schema.", schema, schemaHash, peerSchemaHash));
                    }
                    BinaryRow row = new BinaryRow(schema);
                    row.pointTo(buffer, buffer.readerIndex(), buffer.size());
                    return this.fromRow(row);
                }

                @Override
                public byte[] encode(T obj) {
                    this.buffer.writerIndex(0);
                    this.buffer.writeLong(schemaHash);
                    writer.setBuffer(this.buffer);
                    writer.reset();
                    BinaryRow row = this.toRow(obj);
                    return this.buffer.getBytes(0, 8 + row.getSizeInBytes());
                }
            };
        }
        catch (Exception e) {
            String msg = String.format("Create encoder failed, \nbeanClass: %s", beanClass);
            throw new EncoderException(msg, e);
        }
    }

    public static <T extends Collection> ArrayEncoder<T> arrayEncoder(TypeToken<T> token) {
        return Encoders.arrayEncoder(token, (Fury)null);
    }

    public static <T extends Collection> ArrayEncoder<T> arrayEncoder(TypeToken<T> token, Fury fury) {
        Schema schema = TypeInference.inferSchema(token, false);
        Field field = DataTypes.fieldOfSchema(schema, 0);
        BinaryArrayWriter writer = new BinaryArrayWriter(field);
        HashSet set = new HashSet();
        Encoders.findBeanToken(token, set);
        if (set.isEmpty()) {
            throw new IllegalArgumentException("can not find bean class.");
        }
        TypeToken typeToken = null;
        for (TypeToken typeToken2 : set) {
            typeToken = (TypeToken)set.iterator().next();
            Encoders.loadOrGenRowCodecClass(TypeUtils.getRawType((TypeToken)typeToken2));
        }
        final ArrayEncoder<T> encoder = Encoders.arrayEncoder(token, typeToken, writer, fury);
        return new ArrayEncoder<T>(){

            @Override
            public Field field() {
                return encoder.field();
            }

            @Override
            public T fromArray(BinaryArray array) {
                return (Collection)encoder.fromArray(array);
            }

            @Override
            public BinaryArray toArray(T obj) {
                return encoder.toArray(obj);
            }

            @Override
            public T decode(byte[] bytes) {
                return (Collection)encoder.decode(bytes);
            }

            @Override
            public byte[] encode(T obj) {
                return encoder.encode(obj);
            }
        };
    }

    public static <T extends Collection, B> ArrayEncoder<T> arrayEncoder(Class<? extends Collection> arrayCls, Class<B> elementType) {
        Preconditions.checkNotNull(elementType);
        return Encoders.arrayEncoder(TypeUtils.listOf(elementType), null);
    }

    public static <T extends Collection, B> ArrayEncoder<T> arrayEncoder(TypeToken<? extends Collection> arrayToken, TypeToken<B> elementType, final BinaryArrayWriter writer, Fury fury) {
        final Field field = writer.getField();
        try {
            Class<?> rowCodecClass = Encoders.loadOrGenArrayCodecClass(arrayToken, elementType);
            Object[] references = new Object[]{field, writer, fury};
            final GeneratedArrayEncoder codec = rowCodecClass.asSubclass(GeneratedArrayEncoder.class).getConstructor(Object[].class).newInstance(new Object[]{references});
            return new ArrayEncoder<T>(){

                @Override
                public Field field() {
                    return field;
                }

                @Override
                public T fromArray(BinaryArray array) {
                    return (Collection)codec.fromArray(array);
                }

                @Override
                public BinaryArray toArray(T obj) {
                    return codec.toArray(obj);
                }

                @Override
                public T decode(byte[] bytes) {
                    MemoryBuffer buffer = MemoryUtils.wrap((byte[])bytes);
                    BinaryArray array = new BinaryArray(field);
                    array.pointTo(buffer, buffer.readerIndex(), buffer.size());
                    return this.fromArray(array);
                }

                @Override
                public byte[] encode(T obj) {
                    writer.reset(obj.size());
                    BinaryArray array = this.toArray((T)obj);
                    return writer.getBuffer().getBytes(0, 8 + array.getSizeInBytes());
                }
            };
        }
        catch (Exception e) {
            String msg = String.format("Create encoder failed, \nelementType: %s", elementType);
            throw new EncoderException(msg, e);
        }
    }

    public static <T extends Map> MapEncoder<T> mapEncoder(TypeToken<T> token) {
        return Encoders.mapEncoder(token, null);
    }

    public static <T extends Map, K, V> MapEncoder<T> mapEncoder(Class<? extends Map> mapCls, Class<K> keyType, Class<V> valueType) {
        Preconditions.checkNotNull(keyType);
        Preconditions.checkNotNull(valueType);
        return Encoders.mapEncoder(TypeUtils.mapOf(keyType, valueType), null);
    }

    public static <T extends Map> MapEncoder<T> mapEncoder(TypeToken<T> token, Fury fury) {
        Preconditions.checkNotNull(token);
        Tuple2 tuple2 = TypeUtils.getMapKeyValueType(token);
        Set<TypeToken<?>> set1 = Encoders.beanSet((TypeToken)tuple2.f0);
        Set<TypeToken<?>> set2 = Encoders.beanSet((TypeToken)tuple2.f1);
        LOG.debug("Find beans to load: {}, {}", set1, set2);
        if (set1.isEmpty() && set2.isEmpty()) {
            throw new IllegalArgumentException("can not find bean class.");
        }
        TypeToken<?> keyToken = Encoders.token4BeanLoad(set1, (TypeToken)tuple2.f0);
        TypeToken<?> valToken = Encoders.token4BeanLoad(set2, (TypeToken)tuple2.f1);
        MapEncoder<T> encoder = Encoders.mapEncoder(token, keyToken, valToken, fury);
        return Encoders.createMapEncoder(encoder);
    }

    public static <T extends Map, K, V> MapEncoder<T> mapEncoder(TypeToken<? extends Map> mapToken, TypeToken<K> keyToken, TypeToken<V> valToken, Fury fury) {
        Preconditions.checkNotNull(mapToken);
        Preconditions.checkNotNull(keyToken);
        Preconditions.checkNotNull(valToken);
        Schema schema = TypeInference.inferSchema(mapToken, false);
        final Field field = DataTypes.fieldOfSchema(schema, 0);
        final Field keyField = DataTypes.keyArrayFieldForMap(field);
        final Field valField = DataTypes.itemArrayFieldForMap(field);
        BinaryArrayWriter keyWriter = new BinaryArrayWriter(keyField);
        BinaryArrayWriter valWriter = new BinaryArrayWriter(valField);
        try {
            Class<?> rowCodecClass = Encoders.loadOrGenMapCodecClass(mapToken, keyToken, valToken);
            Object[] references = new Object[]{keyField, valField, keyWriter, valWriter, fury, field};
            final GeneratedMapEncoder codec = rowCodecClass.asSubclass(GeneratedMapEncoder.class).getConstructor(Object[].class).newInstance(new Object[]{references});
            return new MapEncoder<T>(){

                @Override
                public Field keyField() {
                    return keyField;
                }

                @Override
                public Field valueField() {
                    return valField;
                }

                @Override
                public T fromMap(BinaryArray key, BinaryArray value) {
                    return (Map)codec.fromMap(key, value);
                }

                @Override
                public BinaryMap toMap(T obj) {
                    return codec.toMap(obj);
                }

                @Override
                public T decode(byte[] bytes) {
                    MemoryBuffer buffer = MemoryUtils.wrap((byte[])bytes);
                    BinaryMap map = new BinaryMap(field);
                    map.pointTo(buffer, 0, buffer.size());
                    return (Map)this.fromMap(map);
                }

                @Override
                public byte[] encode(T obj) {
                    BinaryMap map = this.toMap((T)obj);
                    return map.getBuf().readBytes(map.getBuf().size());
                }
            };
        }
        catch (Exception e) {
            String msg = String.format("Create encoder failed, \nkeyType: %s, valueType: %s", keyToken, valToken);
            throw new EncoderException(msg, e);
        }
    }

    private static Set<TypeToken<?>> beanSet(TypeToken<?> token) {
        HashSet set = new HashSet();
        if (TypeUtils.isBean(token)) {
            set.add(token);
            return set;
        }
        Encoders.findBeanToken(token, set);
        return set;
    }

    private static TypeToken<?> token4BeanLoad(Set<TypeToken<?>> set, TypeToken<?> init) {
        TypeToken<?> keyToken = init;
        for (TypeToken<?> tt : set) {
            keyToken = tt;
            Encoders.loadOrGenRowCodecClass(TypeUtils.getRawType(tt));
            LOG.debug("bean {} load finished", (Object)TypeUtils.getRawType(tt));
        }
        return keyToken;
    }

    private static <T> MapEncoder<T> createMapEncoder(final MapEncoder<T> encoder) {
        return new MapEncoder<T>(){

            @Override
            public Field keyField() {
                return encoder.keyField();
            }

            @Override
            public Field valueField() {
                return encoder.valueField();
            }

            @Override
            public T fromMap(BinaryArray key, BinaryArray value) {
                return encoder.fromMap(key, value);
            }

            @Override
            public BinaryMap toMap(T obj) {
                return encoder.toMap(obj);
            }

            @Override
            public T decode(byte[] bytes) {
                return encoder.decode(bytes);
            }

            @Override
            public byte[] encode(T obj) {
                return encoder.encode(obj);
            }
        };
    }

    private static void findBeanToken(TypeToken<?> typeToken, Set<TypeToken<?>> set) {
        while (TypeUtils.ITERABLE_TYPE.isSupertypeOf(typeToken) || TypeUtils.MAP_TYPE.isSupertypeOf(typeToken)) {
            if (TypeUtils.ITERABLE_TYPE.isSupertypeOf(typeToken)) {
                if (!TypeUtils.isBean((TypeToken)(typeToken = TypeUtils.getElementType(typeToken)))) continue;
                set.add(typeToken);
                continue;
            }
            Tuple2 tuple2 = TypeUtils.getMapKeyValueType(typeToken);
            if (TypeUtils.isBean((TypeToken)((TypeToken)tuple2.f0))) {
                set.add((TypeToken)tuple2.f0);
            } else {
                typeToken = (TypeToken)tuple2.f0;
                Encoders.findBeanToken((TypeToken)tuple2.f0, set);
            }
            if (TypeUtils.isBean((TypeToken)((TypeToken)tuple2.f1))) {
                set.add((TypeToken)tuple2.f1);
                continue;
            }
            typeToken = (TypeToken)tuple2.f1;
            Encoders.findBeanToken((TypeToken)tuple2.f1, set);
        }
    }

    public static Class<?> loadOrGenRowCodecClass(Class<?> beanClass) {
        LinkedHashSet classes = TypeUtils.listBeansRecursiveInclusive(beanClass);
        LOG.debug("Create RowCodec for classes {}", (Object)classes);
        CompileUnit[] compileUnits = (CompileUnit[])classes.stream().map(cls -> {
            RowEncoderBuilder codecBuilder = new RowEncoderBuilder((Class<?>)cls);
            return new CompileUnit(CodeGenerator.getPackage((Class)cls), codecBuilder.codecClassName((Class<?>)cls), codecBuilder::genCode);
        }).toArray(CompileUnit[]::new);
        return Encoders.loadCls(compileUnits);
    }

    private static <B> Class<?> loadOrGenArrayCodecClass(TypeToken<? extends Collection> arrayCls, TypeToken<B> elementType) {
        LOG.debug("Create ArrayCodec for classes {}", elementType);
        Class cls = TypeUtils.getRawType(elementType);
        String prefix = TypeInference.inferTypeName(arrayCls);
        ArrayEncoderBuilder codecBuilder = new ArrayEncoderBuilder(arrayCls, elementType);
        CompileUnit compileUnit = new CompileUnit(CodeGenerator.getPackage((Class)cls), codecBuilder.codecClassName(cls, prefix), codecBuilder::genCode);
        return Encoders.loadCls(compileUnit);
    }

    private static <K, V> Class<?> loadOrGenMapCodecClass(TypeToken<? extends Map> mapCls, TypeToken<K> keyToken, TypeToken<V> valueToken) {
        Object beanToken;
        Class cls;
        LOG.debug("Create MapCodec for classes {}, {}", keyToken, valueToken);
        boolean keyIsBean = TypeUtils.isBean(keyToken);
        boolean valIsBean = TypeUtils.isBean(valueToken);
        if (keyIsBean) {
            cls = TypeUtils.getRawType(keyToken);
            beanToken = keyToken;
        } else if (valIsBean) {
            cls = TypeUtils.getRawType(valueToken);
            beanToken = valueToken;
        } else {
            throw new IllegalArgumentException("not find bean class.");
        }
        String prefix = TypeInference.inferTypeName(mapCls);
        MapEncoderBuilder codecBuilder = new MapEncoderBuilder(mapCls, (TypeToken<?>)beanToken);
        CompileUnit compileUnit = new CompileUnit(CodeGenerator.getPackage((Class)cls), codecBuilder.codecClassName(cls, prefix), codecBuilder::genCode);
        return Encoders.loadCls(compileUnit);
    }

    private static Class<?> loadCls(CompileUnit ... compileUnit) {
        CodeGenerator codeGenerator = CodeGenerator.getSharedCodeGenerator((ClassLoader)Thread.currentThread().getContextClassLoader());
        ClassLoader classLoader = codeGenerator.compile(compileUnit);
        String className = compileUnit[0].getQualifiedClassName();
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Impossible because we just compiled class", e);
        }
    }
}

