/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.row;

import io.fury.format.row.Getters;
import io.fury.format.type.DefaultTypeVisitor;
import java.util.function.Function;
import org.apache.arrow.vector.types.pojo.ArrowType;

class ValueVisitor
extends DefaultTypeVisitor<Function<Integer, Object>> {
    private final Getters getters;

    ValueVisitor(Getters getters) {
        this.getters = getters;
    }

    @Override
    public Function<Integer, Object> visit(ArrowType.Bool type) {
        return this.getters::getBoolean;
    }

    @Override
    public Function<Integer, Object> visit(ArrowType.Int type) {
        if (type.getIsSigned()) {
            int byteWidth = type.getBitWidth() / 8;
            switch (byteWidth) {
                case 1: {
                    return this.getters::getByte;
                }
                case 2: {
                    return this.getters::getShort;
                }
                case 4: {
                    return this.getters::getInt;
                }
                case 8: {
                    return this.getters::getLong;
                }
            }
            return (Function)this.unsupported((ArrowType)type);
        }
        return (Function)this.unsupported((ArrowType)type);
    }

    @Override
    public Function<Integer, Object> visit(ArrowType.FloatingPoint type) {
        switch (type.getPrecision()) {
            case SINGLE: {
                return this.getters::getFloat;
            }
            case DOUBLE: {
                return this.getters::getDouble;
            }
        }
        return (Function)this.unsupported((ArrowType)type);
    }

    @Override
    public Function<Integer, Object> visit(ArrowType.Date type) {
        switch (type.getUnit()) {
            case DAY: {
                return this.getters::getDate;
            }
        }
        return (Function)this.unsupported((ArrowType)type);
    }

    @Override
    public Function<Integer, Object> visit(ArrowType.Timestamp type) {
        return this.getters::getTimestamp;
    }

    @Override
    public Function<Integer, Object> visit(ArrowType.Binary type) {
        return this.getters::getBinary;
    }

    @Override
    public Function<Integer, Object> visit(ArrowType.Decimal type) {
        return this.getters::getDecimal;
    }

    @Override
    public Function<Integer, Object> visit(ArrowType.Utf8 type) {
        return this.getters::getString;
    }

    @Override
    public Function<Integer, Object> visit(ArrowType.Struct type) {
        return this.getters::getStruct;
    }

    @Override
    public Function<Integer, Object> visit(ArrowType.List type) {
        return this.getters::getArray;
    }

    @Override
    public Function<Integer, Object> visit(ArrowType.Map type) {
        return this.getters::getMap;
    }
}

