/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.row.binary;

import com.google.common.base.MoreObjects;
import io.fury.format.row.MapData;
import io.fury.format.row.binary.BinaryArray;
import io.fury.format.type.DataTypes;
import io.fury.memory.MemoryBuffer;
import io.fury.memory.MemoryUtils;
import io.fury.util.Platform;
import java.nio.ByteBuffer;
import org.apache.arrow.vector.types.pojo.Field;

public class BinaryMap
implements MapData {
    private final BinaryArray keys;
    private final BinaryArray values;
    private final Field field;
    private MemoryBuffer buf;
    private int baseOffset;
    private int sizeInBytes;

    public BinaryMap(Field field) {
        this.field = field;
        this.keys = new BinaryArray(DataTypes.keyArrayFieldForMap(field));
        this.values = new BinaryArray(DataTypes.itemArrayFieldForMap(field));
    }

    public BinaryMap(BinaryArray keys, BinaryArray values, Field field) {
        this.keys = keys;
        this.values = values;
        this.field = field;
        this.baseOffset = 0;
        this.sizeInBytes = keys.getSizeInBytes() + values.getSizeInBytes() + 8;
        MemoryBuffer copyBuf = MemoryUtils.buffer((int)this.sizeInBytes);
        copyBuf.putInt(0, keys.getSizeInBytes());
        copyBuf.putInt(4, 0);
        keys.getBuffer().copyTo(this.baseOffset, copyBuf, 8, keys.getSizeInBytes());
        values.getBuffer().copyTo(this.baseOffset, copyBuf, keys.getSizeInBytes() + 8, values.getSizeInBytes());
        this.buf = copyBuf;
    }

    public void pointTo(MemoryBuffer buf, int offset, int sizeInBytes) {
        this.buf = buf;
        this.baseOffset = offset;
        this.sizeInBytes = sizeInBytes;
        int keyArrayBytes = buf.getInt(offset);
        assert (keyArrayBytes >= 0) : "keyArrayBytes (" + keyArrayBytes + ") should >= 0";
        int valueArrayBytes = sizeInBytes - keyArrayBytes - 8;
        assert (valueArrayBytes >= 0) : "valueArraySize (" + valueArrayBytes + ") should >= 0";
        this.keys.pointTo(buf, offset + 8, keyArrayBytes);
        this.values.pointTo(buf, offset + 8 + keyArrayBytes, valueArrayBytes);
        assert (this.keys.numElements() == this.values.numElements());
    }

    public MemoryBuffer getBuf() {
        return this.buf;
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public int numElements() {
        return this.keys.numElements();
    }

    @Override
    public BinaryArray keyArray() {
        return this.keys;
    }

    @Override
    public BinaryArray valueArray() {
        return this.values;
    }

    @Override
    public MapData copy() {
        MemoryBuffer copyBuf = MemoryUtils.buffer((int)this.sizeInBytes);
        this.buf.copyTo(this.baseOffset, copyBuf, 0, this.sizeInBytes);
        BinaryMap mapCopy = new BinaryMap(this.field);
        mapCopy.pointTo(copyBuf, 0, this.sizeInBytes);
        return mapCopy;
    }

    public void writeToMemory(Object target, long targetOffset) {
        this.buf.copyToUnsafe((long)this.baseOffset, target, targetOffset, this.sizeInBytes);
    }

    public void writeTo(ByteBuffer buffer) {
        assert (buffer.hasArray());
        byte[] target = buffer.array();
        int offset = buffer.arrayOffset();
        int pos = buffer.position();
        this.writeToMemory(target, Platform.BYTE_ARRAY_OFFSET + offset + pos);
        buffer.position(pos + this.sizeInBytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("keys", (Object)this.keys).add("values", (Object)this.values).add("sizeInBytes", this.sizeInBytes).toString();
    }
}

