/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.row.binary;

import io.fury.format.row.Row;
import io.fury.format.row.binary.BinaryArray;
import io.fury.format.row.binary.BinaryMap;
import io.fury.format.row.binary.UnsafeTrait;
import io.fury.format.type.DataTypes;
import io.fury.memory.BitUtils;
import io.fury.memory.MemoryBuffer;
import io.fury.memory.MemoryUtils;
import io.fury.util.Preconditions;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;

public class BinaryRow
extends UnsafeTrait
implements Row {
    private final Schema schema;
    private final int numFields;
    private final int bitmapWidthInBytes;
    private MemoryBuffer buffer;
    private int baseOffset;
    private int sizeInBytes;

    public BinaryRow(Schema schema) {
        this.schema = schema;
        this.numFields = schema.getFields().size();
        com.google.common.base.Preconditions.checkArgument((this.numFields > 0 ? 1 : 0) != 0);
        this.bitmapWidthInBytes = BitUtils.calculateBitmapWidthInBytes((int)this.numFields);
    }

    public void pointTo(MemoryBuffer buffer, int offset, int sizeInBytes) {
        this.buffer = buffer;
        this.baseOffset = offset;
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public int numFields() {
        return this.numFields;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public int getBaseOffset() {
        return this.baseOffset;
    }

    @Override
    public MemoryBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public int getOffset(int ordinal) {
        return this.baseOffset + this.bitmapWidthInBytes + (ordinal << 3);
    }

    @Override
    public void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        Preconditions.checkArgument((index < this.numFields ? 1 : 0) != 0, (String)"index (%d) should < %d", (Object)index, (Object[])new Object[]{this.numFields});
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return BitUtils.isSet((MemoryBuffer)this.buffer, (int)this.baseOffset, (int)ordinal);
    }

    @Override
    public boolean anyNull() {
        return BitUtils.anySet((MemoryBuffer)this.buffer, (int)this.baseOffset, (int)this.bitmapWidthInBytes);
    }

    @Override
    public void setNullAt(int ordinal) {
        this.assertIndexIsValid(ordinal);
        BitUtils.set((MemoryBuffer)this.buffer, (int)this.baseOffset, (int)ordinal);
        assert (DataTypes.getTypeWidth(((Field)this.schema.getFields().get(ordinal)).getType()) > 0) : "field[ " + ordinal + " " + ((Field)this.schema.getFields().get(ordinal)).getType() + " ] must be fixed-width";
        this.buffer.putLong(this.getOffset(ordinal), 0L);
    }

    @Override
    public void setNotNullAt(int ordinal) {
        this.assertIndexIsValid(ordinal);
        BitUtils.unset((MemoryBuffer)this.buffer, (int)this.baseOffset, (int)ordinal);
    }

    @Override
    public BigDecimal getDecimal(int ordinal) {
        return this.getDecimal(ordinal, (ArrowType.Decimal)((Field)this.schema.getFields().get(ordinal)).getType());
    }

    @Override
    public BinaryRow getStruct(int ordinal) {
        return this.getStruct(ordinal, (Field)this.schema.getFields().get(ordinal));
    }

    @Override
    public BinaryArray getArray(int ordinal) {
        return this.getArray(ordinal, (Field)this.schema.getFields().get(ordinal));
    }

    @Override
    public BinaryMap getMap(int ordinal) {
        return this.getMap(ordinal, (Field)this.schema.getFields().get(ordinal));
    }

    @Override
    public Row copy() {
        MemoryBuffer copyBuf = MemoryUtils.buffer((int)this.sizeInBytes);
        this.buffer.copyTo(this.baseOffset, copyBuf, 0, this.sizeInBytes);
        BinaryRow copyRow = new BinaryRow(this.schema);
        copyRow.pointTo(copyBuf, 0, this.sizeInBytes);
        return copyRow;
    }

    public String toString() {
        if (this.buffer == null) {
            return "null";
        }
        StringBuilder build = new StringBuilder("{");
        for (int i = 0; i < this.numFields; ++i) {
            if (i != 0) {
                build.append(", ");
            }
            Field field = (Field)this.schema.getFields().get(i);
            build.append(field.getName()).append("=");
            if (this.isNullAt(i)) {
                build.append("null");
                continue;
            }
            build.append(this.get(i, field));
        }
        build.append("}");
        return build.toString();
    }

    public String toDebugString() {
        if (this.buffer == null) {
            return "null";
        }
        StringBuilder build = new StringBuilder();
        for (int i = 0; i < this.bitmapWidthInBytes + 8 * this.numFields; i += 8) {
            if (i != 0) {
                build.append(',');
            }
            build.append(Long.toHexString(this.buffer.getLong(this.baseOffset + i)));
        }
        return build.toString();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < this.numFields; ++i) {
            Field field = (Field)this.schema.getFields().get(i);
            map.put(field.getName(), this.get(i, field));
        }
        return map;
    }

    public byte[] toBytes() {
        return this.buffer.getBytes(this.baseOffset, this.sizeInBytes);
    }

    public static boolean isFixedLength(ArrowType type) {
        return DataTypes.getTypeWidth(type) > 0;
    }
}

