/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.row.binary;

import com.google.common.reflect.TypeToken;
import io.fury.format.row.binary.BinaryArray;
import io.fury.format.row.binary.BinaryMap;
import io.fury.format.row.binary.BinaryRow;
import io.fury.memory.MemoryBuffer;
import io.fury.type.TypeUtils;

public class BinaryUtils {
    public static String getElemAccessMethodName(TypeToken type) {
        if (TypeUtils.PRIMITIVE_BYTE_TYPE.equals((Object)type) || TypeUtils.BYTE_TYPE.equals((Object)type)) {
            return "getByte";
        }
        if (TypeUtils.PRIMITIVE_BOOLEAN_TYPE.equals((Object)type) || TypeUtils.BOOLEAN_TYPE.equals((Object)type)) {
            return "getBoolean";
        }
        if (TypeUtils.PRIMITIVE_SHORT_TYPE.equals((Object)type) || TypeUtils.SHORT_TYPE.equals((Object)type)) {
            return "getShort";
        }
        if (TypeUtils.PRIMITIVE_INT_TYPE.equals((Object)type) || TypeUtils.INT_TYPE.equals((Object)type)) {
            return "getInt";
        }
        if (TypeUtils.PRIMITIVE_LONG_TYPE.equals((Object)type) || TypeUtils.LONG_TYPE.equals((Object)type)) {
            return "getLong";
        }
        if (TypeUtils.PRIMITIVE_FLOAT_TYPE.equals((Object)type) || TypeUtils.FLOAT_TYPE.equals((Object)type)) {
            return "getFloat";
        }
        if (TypeUtils.PRIMITIVE_DOUBLE_TYPE.equals((Object)type) || TypeUtils.DOUBLE_TYPE.equals((Object)type)) {
            return "getDouble";
        }
        if (TypeUtils.BIG_DECIMAL_TYPE.equals((Object)type)) {
            return "getDecimal";
        }
        if (TypeUtils.DATE_TYPE.equals((Object)type)) {
            return "getDate";
        }
        if (TypeUtils.TIMESTAMP_TYPE.equals((Object)type)) {
            return "getTimestamp";
        }
        if (TypeUtils.STRING_TYPE.equals((Object)type)) {
            return "getString";
        }
        if (type.isArray() || TypeUtils.ITERABLE_TYPE.isSupertypeOf(type)) {
            return "getArray";
        }
        if (TypeUtils.MAP_TYPE.isSupertypeOf(type)) {
            return "getMap";
        }
        if (TypeUtils.isBean((TypeToken)type)) {
            return "getStruct";
        }
        return "getBuffer";
    }

    public static TypeToken<?> getElemReturnType(TypeToken<?> type) {
        if (TypeUtils.PRIMITIVE_BYTE_TYPE.equals(type) || TypeUtils.BYTE_TYPE.equals(type)) {
            return TypeUtils.PRIMITIVE_BYTE_TYPE;
        }
        if (TypeUtils.PRIMITIVE_BOOLEAN_TYPE.equals(type) || TypeUtils.BOOLEAN_TYPE.equals(type)) {
            return TypeUtils.PRIMITIVE_BOOLEAN_TYPE;
        }
        if (TypeUtils.PRIMITIVE_SHORT_TYPE.equals(type) || TypeUtils.SHORT_TYPE.equals(type)) {
            return TypeUtils.PRIMITIVE_SHORT_TYPE;
        }
        if (TypeUtils.PRIMITIVE_INT_TYPE.equals(type) || TypeUtils.INT_TYPE.equals(type)) {
            return TypeUtils.PRIMITIVE_INT_TYPE;
        }
        if (TypeUtils.PRIMITIVE_LONG_TYPE.equals(type) || TypeUtils.LONG_TYPE.equals(type)) {
            return TypeUtils.PRIMITIVE_LONG_TYPE;
        }
        if (TypeUtils.PRIMITIVE_FLOAT_TYPE.equals(type) || TypeUtils.FLOAT_TYPE.equals(type)) {
            return TypeUtils.PRIMITIVE_FLOAT_TYPE;
        }
        if (TypeUtils.PRIMITIVE_DOUBLE_TYPE.equals(type) || TypeUtils.DOUBLE_TYPE.equals(type)) {
            return TypeUtils.PRIMITIVE_DOUBLE_TYPE;
        }
        if (TypeUtils.BIG_DECIMAL_TYPE.equals(type)) {
            return TypeUtils.BIG_DECIMAL_TYPE;
        }
        if (TypeUtils.DATE_TYPE.equals(type)) {
            return TypeUtils.INT_TYPE;
        }
        if (TypeUtils.TIMESTAMP_TYPE.equals(type)) {
            return TypeUtils.LONG_TYPE;
        }
        if (TypeUtils.STRING_TYPE.equals(type)) {
            return TypeUtils.STRING_TYPE;
        }
        if (type.isArray() || TypeUtils.ITERABLE_TYPE.isSupertypeOf(type)) {
            return TypeToken.of(BinaryArray.class);
        }
        if (TypeUtils.MAP_TYPE.isSupertypeOf(type)) {
            return TypeToken.of(BinaryMap.class);
        }
        if (TypeUtils.isBean(type)) {
            return TypeToken.of(BinaryRow.class);
        }
        return TypeToken.of(MemoryBuffer.class);
    }
}

