/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.row.binary;

import io.fury.format.row.Getters;
import io.fury.format.row.Setters;
import io.fury.format.row.binary.BinaryArray;
import io.fury.format.row.binary.BinaryMap;
import io.fury.format.row.binary.BinaryRow;
import io.fury.format.type.DataTypes;
import io.fury.format.vectorized.ArrowUtils;
import io.fury.memory.MemoryBuffer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.util.DecimalUtility;

abstract class UnsafeTrait
implements Getters,
Setters {
    UnsafeTrait() {
    }

    abstract MemoryBuffer getBuffer();

    @Override
    public MemoryBuffer getBuffer(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int relativeOffset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        return this.getBuffer().slice(this.getBaseOffset() + relativeOffset, size);
    }

    abstract int getBaseOffset();

    abstract void assertIndexIsValid(int var1);

    abstract int getOffset(int var1);

    @Override
    public boolean getBoolean(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getBoolean(this.getOffset(ordinal));
    }

    @Override
    public byte getByte(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().get(this.getOffset(ordinal));
    }

    @Override
    public short getShort(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getShort(this.getOffset(ordinal));
    }

    @Override
    public int getInt(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getInt(this.getOffset(ordinal));
    }

    @Override
    public long getLong(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getLong(this.getOffset(ordinal));
    }

    @Override
    public float getFloat(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getFloat(this.getOffset(ordinal));
    }

    @Override
    public double getDouble(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getDouble(this.getOffset(ordinal));
    }

    @Override
    public int getDate(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getInt(this.getOffset(ordinal));
    }

    @Override
    public long getTimestamp(int ordinal) {
        this.assertIndexIsValid(ordinal);
        return this.getBuffer().getLong(this.getOffset(ordinal));
    }

    @Override
    public String getString(int ordinal) {
        byte[] bytes = this.getBinary(ordinal);
        if (bytes != null) {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public byte[] getBinary(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int relativeOffset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        byte[] bytes = new byte[size];
        this.getBuffer().get(this.getBaseOffset() + relativeOffset, bytes, 0, size);
        return bytes;
    }

    BigDecimal getDecimal(int ordinal, ArrowType.Decimal decimalType) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        MemoryBuffer buffer = this.getBuffer(ordinal);
        ArrowBuf arrowBuf = ArrowUtils.decimalArrowBuf();
        buffer.copyToUnsafe(0L, null, arrowBuf.memoryAddress(), 32);
        BigDecimal decimal = DecimalUtility.getBigDecimalFromArrowBuf((ArrowBuf)arrowBuf, (int)0, (int)decimalType.getScale(), (int)32);
        return decimal;
    }

    BinaryRow getStruct(int ordinal, Field field) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int relativeOffset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        BinaryRow row = new BinaryRow(DataTypes.createSchema(field));
        row.pointTo(this.getBuffer(), this.getBaseOffset() + relativeOffset, size);
        return row;
    }

    BinaryArray getArray(int ordinal, Field field) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int relativeOffset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        BinaryArray array = new BinaryArray(field);
        array.pointTo(this.getBuffer(), this.getBaseOffset() + relativeOffset, size);
        return array;
    }

    BinaryMap getMap(int ordinal, Field field) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        long offsetAndSize = this.getLong(ordinal);
        int relativeOffset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        BinaryMap map = new BinaryMap(field);
        map.pointTo(this.getBuffer(), this.getBaseOffset() + relativeOffset, size);
        return map;
    }

    @Override
    public void setBoolean(int ordinal, boolean value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putBoolean(this.getOffset(ordinal), value);
    }

    @Override
    public void setByte(int ordinal, byte value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().put(this.getOffset(ordinal), value);
    }

    protected abstract void setNotNullAt(int var1);

    @Override
    public void setShort(int ordinal, short value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putShort(this.getOffset(ordinal), value);
    }

    @Override
    public void setInt(int ordinal, int value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putInt(this.getOffset(ordinal), value);
    }

    @Override
    public void setLong(int ordinal, long value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putLong(this.getOffset(ordinal), value);
    }

    @Override
    public void setFloat(int ordinal, float value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putFloat(this.getOffset(ordinal), value);
    }

    @Override
    public void setDouble(int ordinal, double value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putDouble(this.getOffset(ordinal), value);
    }

    @Override
    public void setDate(int ordinal, int value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putInt(this.getOffset(ordinal), value);
    }

    @Override
    public void setTimestamp(int ordinal, long value) {
        this.assertIndexIsValid(ordinal);
        this.setNotNullAt(ordinal);
        this.getBuffer().putLong(this.getOffset(ordinal), value);
    }
}

