/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.row.binary.writer;

import io.fury.format.row.binary.BinaryArray;
import io.fury.format.row.binary.writer.BinaryWriter;
import io.fury.format.type.DataTypes;
import io.fury.memory.MemoryBuffer;
import io.fury.memory.MemoryUtils;
import io.fury.util.Platform;
import java.math.BigDecimal;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public class BinaryArrayWriter
extends BinaryWriter {
    public static int MAX_ROUNDED_ARRAY_LENGTH = 0x7FFFFFF0;
    private final Field field;
    private final int elementSize;
    private int numElements;
    private int headerInBytes;

    public BinaryArrayWriter(Field field) {
        this(field, MemoryUtils.buffer((int)64));
        this.startIndex = 0;
    }

    public BinaryArrayWriter(Field field, BinaryWriter writer) {
        this(field, writer.buffer);
        writer.children.add(this);
    }

    private BinaryArrayWriter(Field field, MemoryBuffer buffer) {
        super(buffer, 8);
        this.field = field;
        int width = DataTypes.getTypeWidth(((Field)field.getChildren().get(0)).getType());
        this.elementSize = width < 0 ? 8 : width;
    }

    public void reset(int numElements) {
        int i;
        this.startIndex = this.writerIndex();
        this.numElements = numElements;
        this.headerInBytes = BinaryArray.calculateHeaderInBytes(numElements);
        long dataSize = (long)numElements * (long)this.elementSize;
        if (dataSize > (long)MAX_ROUNDED_ARRAY_LENGTH) {
            throw new UnsupportedOperationException("Can't alloc binary array, it's too big");
        }
        int fixedPartInBytes = BinaryArrayWriter.roundNumberOfBytesToNearestWord((int)dataSize);
        this.buffer.grow(this.headerInBytes + fixedPartInBytes);
        this.buffer.putLong(this.startIndex, (long)numElements);
        int end = this.startIndex + this.headerInBytes;
        for (i = this.startIndex + 8; i < end; i += 8) {
            this.buffer.putLong(i, 0L);
        }
        for (i = this.elementSize * numElements; i < fixedPartInBytes; ++i) {
            this.buffer.put(this.startIndex + this.headerInBytes + i, (byte)0);
        }
        this.buffer.increaseWriterIndexUnsafe(this.headerInBytes + fixedPartInBytes);
    }

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.numElements) : "index (" + index + ") should < " + this.numElements;
    }

    @Override
    public int getOffset(int ordinal) {
        return this.startIndex + this.headerInBytes + ordinal * this.elementSize;
    }

    @Override
    public void write(int ordinal, byte value) {
        this.setNotNullAt(ordinal);
        this.buffer.put(this.getOffset(ordinal), value);
    }

    @Override
    public void write(int ordinal, boolean value) {
        this.setNotNullAt(ordinal);
        this.buffer.putBoolean(this.getOffset(ordinal), value);
    }

    @Override
    public void write(int ordinal, short value) {
        this.setNotNullAt(ordinal);
        this.buffer.putShort(this.getOffset(ordinal), value);
    }

    @Override
    public void write(int ordinal, int value) {
        this.setNotNullAt(ordinal);
        this.buffer.putInt(this.getOffset(ordinal), value);
    }

    @Override
    public void write(int ordinal, float value) {
        this.setNotNullAt(ordinal);
        this.buffer.putFloat(this.getOffset(ordinal), value);
    }

    @Override
    public void write(int ordinal, BigDecimal value) {
        this.writeDecimal(ordinal, value, (ArrowType.Decimal)((Field)this.field.getChildren().get(0)).getType());
    }

    private void fromPrimitiveArray(Object arr, int offset, int numElements, Field type) {
        if (DataTypes.getTypeId(((Field)type.getChildren().get(0)).getType()) != DataTypes.getTypeId(((Field)this.field.getChildren().get(0)).getType())) {
            String msg = String.format("Element type %s is not %s", ((Field)type.getChildren().get(0)).getType(), ((Field)this.field.getChildren().get(0)).getType());
            throw new IllegalArgumentException(msg);
        }
        this.buffer.copyFromUnsafe((long)(this.startIndex + this.headerInBytes), arr, (long)offset, (long)numElements * (long)this.elementSize);
    }

    public void fromPrimitiveArray(byte[] arr) {
        this.fromPrimitiveArray(arr, Platform.BYTE_ARRAY_OFFSET, arr.length, DataTypes.PRIMITIVE_BYTE_ARRAY_FIELD);
    }

    public void fromPrimitiveArray(boolean[] arr) {
        this.fromPrimitiveArray(arr, Platform.BOOLEAN_ARRAY_OFFSET, arr.length, DataTypes.PRIMITIVE_BOOLEAN_ARRAY_FIELD);
    }

    public void fromPrimitiveArray(short[] arr) {
        this.fromPrimitiveArray(arr, Platform.SHORT_ARRAY_OFFSET, arr.length, DataTypes.PRIMITIVE_SHORT_ARRAY_FIELD);
    }

    public void fromPrimitiveArray(int[] arr) {
        this.fromPrimitiveArray(arr, Platform.INT_ARRAY_OFFSET, arr.length, DataTypes.PRIMITIVE_INT_ARRAY_FIELD);
    }

    public void fromPrimitiveArray(long[] arr) {
        this.fromPrimitiveArray(arr, Platform.LONG_ARRAY_OFFSET, arr.length, DataTypes.PRIMITIVE_LONG_ARRAY_FIELD);
    }

    public void fromPrimitiveArray(float[] arr) {
        this.fromPrimitiveArray(arr, Platform.FLOAT_ARRAY_OFFSET, arr.length, DataTypes.PRIMITIVE_FLOAT_ARRAY_FIELD);
    }

    public void fromPrimitiveArray(double[] arr) {
        this.fromPrimitiveArray(arr, Platform.DOUBLE_ARRAY_OFFSET, arr.length, DataTypes.PRIMITIVE_DOUBLE_ARRAY_FIELD);
    }

    public BinaryArray toArray() {
        BinaryArray array = new BinaryArray(this.field);
        int size = this.size();
        MemoryBuffer buffer = MemoryUtils.buffer((int)size);
        this.buffer.copyTo(this.startIndex, buffer, 0, size);
        array.pointTo(buffer, 0, size);
        return array;
    }

    public Field getField() {
        return this.field;
    }
}

