/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.row.binary.writer;

import io.fury.format.row.binary.BinaryArray;
import io.fury.format.row.binary.BinaryMap;
import io.fury.format.row.binary.BinaryRow;
import io.fury.format.vectorized.ArrowUtils;
import io.fury.memory.BitUtils;
import io.fury.memory.MemoryBuffer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.util.DecimalUtility;

public abstract class BinaryWriter {
    protected MemoryBuffer buffer;
    protected int startIndex;
    private final int bytesBeforeBitMap;
    protected final List<BinaryWriter> children;

    public static int roundNumberOfBytesToNearestWord(int numBytes) {
        int remainder = numBytes & 7;
        if (remainder == 0) {
            return numBytes;
        }
        return numBytes + (8 - remainder);
    }

    protected BinaryWriter(MemoryBuffer buffer, int bytesBeforeBitMap) {
        this.buffer = buffer;
        this.bytesBeforeBitMap = bytesBeforeBitMap;
        this.children = new ArrayList<BinaryWriter>();
    }

    public final MemoryBuffer getBuffer() {
        return this.buffer;
    }

    public final int writerIndex() {
        return this.buffer.writerIndex();
    }

    public final int size() {
        return this.buffer.writerIndex() - this.startIndex;
    }

    public final int getStartIndex() {
        return this.startIndex;
    }

    public final void increaseWriterIndex(int val) {
        this.buffer.increaseWriterIndex(val);
    }

    public final void increaseWriterIndexToAligned(int val) {
        int writerIndex = this.buffer.writerIndex();
        int maybeEnd = writerIndex + val;
        int remainder = maybeEnd & 7;
        if (remainder == 0) {
            this.buffer.increaseWriterIndex(val);
        } else {
            int end = maybeEnd - remainder + 8;
            int newVal = end - writerIndex;
            this.buffer.grow(newVal);
            for (int i = maybeEnd; i < end; ++i) {
                this.buffer.put(i, (byte)0);
            }
            this.buffer.increaseWriterIndex(newVal);
        }
    }

    protected final void grow(int neededSize) {
        this.buffer.grow(neededSize);
    }

    public final void setOffsetAndSize(int ordinal, int size) {
        this.setOffsetAndSize(ordinal, this.buffer.writerIndex(), size);
    }

    public final void setOffsetAndSize(int ordinal, int absoluteOffset, int size) {
        long relativeOffset = absoluteOffset - this.startIndex;
        long offsetAndSize = relativeOffset << 32 | (long)size;
        this.write(ordinal, offsetAndSize);
    }

    protected final void zeroOutPaddingBytes(int numBytes) {
        if ((numBytes & 7) > 0) {
            this.buffer.putLong(this.buffer.writerIndex() + (numBytes >> 3 << 3), 0L);
        }
    }

    public final void setNullAt(int ordinal) {
        BitUtils.set((MemoryBuffer)this.buffer, (int)(this.startIndex + this.bytesBeforeBitMap), (int)ordinal);
    }

    public final void setNotNullAt(int ordinal) {
        BitUtils.unset((MemoryBuffer)this.buffer, (int)(this.startIndex + this.bytesBeforeBitMap), (int)ordinal);
    }

    public final boolean isNullAt(int ordinal) {
        return BitUtils.isSet((MemoryBuffer)this.buffer, (int)(this.startIndex + this.bytesBeforeBitMap), (int)ordinal);
    }

    public abstract int getOffset(int var1);

    public abstract void write(int var1, byte var2);

    public abstract void write(int var1, boolean var2);

    public abstract void write(int var1, short var2);

    public abstract void write(int var1, int var2);

    public abstract void write(int var1, float var2);

    public abstract void write(int var1, BigDecimal var2);

    public final void write(int ordinal, long value) {
        this.buffer.putLong(this.getOffset(ordinal), value);
    }

    public final void write(int ordinal, double value) {
        this.buffer.putDouble(this.getOffset(ordinal), value);
    }

    public final void write(int ordinal, String input) {
        this.write(ordinal, input.getBytes(StandardCharsets.UTF_8));
    }

    public final void write(int ordinal, byte[] input) {
        this.writeUnaligned(ordinal, input, 0, input.length);
    }

    public final void write(int ordinal, BinaryRow row) {
        this.writeAlignedBytes(ordinal, row.getBuffer(), row.getBaseOffset(), row.getSizeInBytes());
    }

    public final void write(int ordinal, BinaryMap map) {
        this.writeAlignedBytes(ordinal, map.getBuf(), map.getBaseOffset(), map.getSizeInBytes());
    }

    public final void write(int ordinal, BinaryArray array) {
        this.writeAlignedBytes(ordinal, array.getBuffer(), array.getBaseOffset(), array.getSizeInBytes());
    }

    public final void writeUnaligned(int ordinal, byte[] input, int offset, int numBytes) {
        int roundedSize = BinaryWriter.roundNumberOfBytesToNearestWord(numBytes);
        this.buffer.grow(roundedSize);
        this.zeroOutPaddingBytes(numBytes);
        this.buffer.put(this.buffer.writerIndex(), input, offset, numBytes);
        this.setOffsetAndSize(ordinal, numBytes);
        this.buffer.increaseWriterIndexUnsafe(roundedSize);
    }

    public final void writeUnaligned(int ordinal, MemoryBuffer input, int offset, int numBytes) {
        int roundedSize = BinaryWriter.roundNumberOfBytesToNearestWord(numBytes);
        this.buffer.grow(roundedSize);
        this.zeroOutPaddingBytes(numBytes);
        this.buffer.copyFrom(this.buffer.writerIndex(), input, offset, numBytes);
        this.setOffsetAndSize(ordinal, numBytes);
        this.buffer.increaseWriterIndexUnsafe(roundedSize);
    }

    public final void writeAlignedBytes(int ordinal, MemoryBuffer input, int baseOffset, int numBytes) {
        this.buffer.grow(numBytes);
        this.buffer.copyFrom(this.buffer.writerIndex(), input, baseOffset, numBytes);
        this.setOffsetAndSize(ordinal, numBytes);
        this.buffer.increaseWriterIndex(numBytes);
    }

    protected final void writeDecimal(int ordinal, BigDecimal value, ArrowType.Decimal type) {
        if (value != null) {
            DecimalUtility.checkPrecisionAndScale((BigDecimal)value, (int)type.getPrecision(), (int)type.getScale());
            this.grow(32);
            ArrowBuf arrowBuf = ArrowUtils.buffer(32L);
            DecimalUtility.writeBigDecimalToArrowBuf((BigDecimal)value, (ArrowBuf)arrowBuf, (int)0, (int)32);
            this.buffer.copyFromUnsafe((long)this.writerIndex(), null, arrowBuf.memoryAddress(), 32L);
            arrowBuf.getReferenceManager().release();
            this.setOffsetAndSize(ordinal, this.writerIndex(), 32);
            this.increaseWriterIndex(32);
        } else {
            this.setNullAt(ordinal);
        }
    }

    public final void writeDirectly(long value) {
        this.buffer.grow(8);
        this.buffer.putLong(this.writerIndex(), value);
        this.buffer.increaseWriterIndexUnsafe(8);
    }

    public final void writeDirectly(int offset, long value) {
        this.buffer.putLong(offset, value);
    }

    public final void copyTo(BinaryWriter writer, int ordinal) {
        writer.writeAlignedBytes(ordinal, this.buffer, this.startIndex, this.buffer.writerIndex());
    }

    public final void setBuffer(MemoryBuffer buffer) {
        this.buffer = buffer;
        for (BinaryWriter child : this.children) {
            child.setBuffer(buffer);
        }
    }
}

