/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.type;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.fury.collection.Tuple2;
import io.fury.format.type.DataTypes;
import io.fury.type.Descriptor;
import io.fury.type.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class TypeInference {
    public static Schema inferSchema(Type type) {
        return TypeInference.inferSchema(TypeToken.of((Type)type));
    }

    public static Schema inferSchema(Class<?> clz) {
        return TypeInference.inferSchema(TypeToken.of(clz));
    }

    public static Schema inferSchema(TypeToken<?> typeToken) {
        return TypeInference.inferSchema(typeToken, true);
    }

    public static Schema inferSchema(TypeToken<?> typeToken, boolean forStruct) {
        Field field = TypeInference.inferField(typeToken);
        if (forStruct) {
            Preconditions.checkArgument((field.getType().getTypeID() == ArrowType.ArrowTypeID.Struct ? 1 : 0) != 0);
            return new Schema((Iterable)field.getChildren());
        }
        return new Schema(Arrays.asList(field));
    }

    public static Optional<ArrowType> getDataType(Class<?> cls) {
        return TypeInference.getDataType(TypeToken.of(cls));
    }

    public static Optional<ArrowType> getDataType(TypeToken<?> typeToken) {
        try {
            return Optional.of(TypeInference.inferDataType(typeToken));
        }
        catch (UnsupportedOperationException e) {
            return Optional.empty();
        }
    }

    public static ArrowType inferDataType(TypeToken<?> typeToken) {
        return TypeInference.inferField(typeToken).getType();
    }

    public static Field arrayInferField(Type arrayType, Type type) {
        return TypeInference.arrayInferField(TypeToken.of((Type)arrayType), TypeToken.of((Type)type));
    }

    public static Field arrayInferField(Class<?> arrayClz, Class<?> clz) {
        return TypeInference.arrayInferField(TypeToken.of(arrayClz), TypeToken.of(clz));
    }

    public static Field arrayInferField(TypeToken<?> arrayTypeToken, TypeToken<?> typeToken) {
        Field field = TypeInference.inferField(arrayTypeToken, typeToken);
        Preconditions.checkArgument((field.getType().getTypeID() == ArrowType.ArrowTypeID.List ? 1 : 0) != 0);
        return field;
    }

    private static Field inferField(TypeToken<?> typeToken) {
        return TypeInference.inferField(null, typeToken);
    }

    private static Field inferField(TypeToken<?> arrayTypeToken, TypeToken<?> typeToken) {
        LinkedHashSet seenTypeSet = new LinkedHashSet();
        String name = "";
        if (arrayTypeToken != null) {
            Field f = TypeInference.inferField("item", typeToken, seenTypeSet);
            return DataTypes.arrayField(name, f);
        }
        return TypeInference.inferField("", typeToken, seenTypeSet);
    }

    private static Field inferField(String name, TypeToken<?> typeToken, LinkedHashSet<Class<?>> seenTypeSet) {
        Class rawType = TypeUtils.getRawType(typeToken);
        if (rawType == Boolean.TYPE) {
            return DataTypes.field(name, DataTypes.notNullFieldType((ArrowType)ArrowType.Bool.INSTANCE));
        }
        if (rawType == Byte.TYPE) {
            return DataTypes.field(name, DataTypes.notNullFieldType((ArrowType)new ArrowType.Int(8, true)));
        }
        if (rawType == Short.TYPE) {
            return DataTypes.field(name, DataTypes.notNullFieldType((ArrowType)new ArrowType.Int(16, true)));
        }
        if (rawType == Integer.TYPE) {
            return DataTypes.field(name, DataTypes.notNullFieldType((ArrowType)new ArrowType.Int(32, true)));
        }
        if (rawType == Long.TYPE) {
            return DataTypes.field(name, DataTypes.notNullFieldType((ArrowType)new ArrowType.Int(64, true)));
        }
        if (rawType == Float.TYPE) {
            return DataTypes.field(name, DataTypes.notNullFieldType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)));
        }
        if (rawType == Double.TYPE) {
            return DataTypes.field(name, DataTypes.notNullFieldType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)));
        }
        if (rawType == Boolean.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)ArrowType.Bool.INSTANCE));
        }
        if (rawType == Byte.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Int(8, true)));
        }
        if (rawType == Short.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Int(16, true)));
        }
        if (rawType == Integer.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Int(32, true)));
        }
        if (rawType == Long.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Int(64, true)));
        }
        if (rawType == Float.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)));
        }
        if (rawType == Double.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)));
        }
        if (rawType == BigDecimal.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Decimal(38, 18)));
        }
        if (rawType == BigInteger.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Decimal(38, 0)));
        }
        if (rawType == LocalDate.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Date(DateUnit.DAY)));
        }
        if (rawType == Date.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Date(DateUnit.DAY)));
        }
        if (rawType == Timestamp.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, null)));
        }
        if (rawType == Instant.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, null)));
        }
        if (rawType == String.class) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE));
        }
        if (rawType.isEnum()) {
            return DataTypes.field(name, FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE));
        }
        if (rawType.isArray()) {
            Field f = TypeInference.inferField("item", Objects.requireNonNull(typeToken.getComponentType()), seenTypeSet);
            return DataTypes.arrayField(name, f);
        }
        if (TypeUtils.ITERABLE_TYPE.isSupertypeOf(typeToken)) {
            Field f = TypeInference.inferField("item", TypeUtils.getElementType(typeToken), seenTypeSet);
            return DataTypes.arrayField(name, f);
        }
        if (TypeUtils.MAP_TYPE.isSupertypeOf(typeToken)) {
            Tuple2 kvType = TypeUtils.getMapKeyValueType(typeToken);
            Field keyField = TypeInference.inferField("key", (TypeToken)kvType.f0, seenTypeSet);
            FieldType keyFieldType = new FieldType(false, keyField.getType(), keyField.getDictionary(), keyField.getMetadata());
            keyField = DataTypes.field(keyField.getName(), keyFieldType, keyField.getChildren());
            Field valueField = TypeInference.inferField("value", (TypeToken)kvType.f1, seenTypeSet);
            return DataTypes.mapField(name, keyField, valueField);
        }
        if (TypeUtils.isBean((Class)rawType)) {
            if (seenTypeSet.contains(rawType)) {
                String msg = String.format("circular references in bean class is not allowed, but got %s in %s", rawType, seenTypeSet);
                throw new UnsupportedOperationException(msg);
            }
            List<Field> fields = Descriptor.getDescriptors((Class)rawType).stream().map(descriptor -> {
                LinkedHashSet newSeenTypeSet = new LinkedHashSet(seenTypeSet);
                newSeenTypeSet.add(rawType);
                String n = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, descriptor.getName());
                return TypeInference.inferField(n, descriptor.getTypeToken(), newSeenTypeSet);
            }).collect(Collectors.toList());
            return DataTypes.structField(name, true, fields);
        }
        throw new UnsupportedOperationException(String.format("Unsupported type %s for field %s, seen type set is %s", typeToken, name, seenTypeSet));
    }

    public static String inferTypeName(TypeToken<?> token) {
        StringBuilder sb = new StringBuilder();
        TypeToken arrayToken = token;
        while (TypeUtils.ITERABLE_TYPE.isSupertypeOf(arrayToken) || TypeUtils.MAP_TYPE.isSupertypeOf(arrayToken)) {
            if (TypeUtils.ITERABLE_TYPE.isSupertypeOf(arrayToken)) {
                sb.append(TypeUtils.getRawType(arrayToken).getSimpleName());
                arrayToken = TypeUtils.getElementType(arrayToken);
                continue;
            }
            Tuple2 tuple2 = TypeUtils.getMapKeyValueType(arrayToken);
            sb.append("Map");
            if (!TypeUtils.isBean((TypeToken)((TypeToken)tuple2.f0))) {
                arrayToken = (TypeToken)tuple2.f0;
            }
            if (TypeUtils.isBean((TypeToken)((TypeToken)tuple2.f1))) continue;
            arrayToken = (TypeToken)tuple2.f1;
        }
        return sb.toString();
    }
}

