/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.vectorized;

import io.fury.Fury;
import io.fury.format.vectorized.ArrowSerializers;
import io.fury.format.vectorized.ArrowTable;
import io.fury.format.vectorized.ArrowUtils;
import io.fury.io.FuryReadableByteChannel;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.BufferObject;
import io.fury.serializer.Serializers;
import io.fury.type.Type;
import io.fury.util.Platform;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;

public class ArrowTableSerializer
extends Serializers.CrossLanguageCompatibleSerializer<ArrowTable> {
    private static final BufferAllocator defaultAllocator = ArrowUtils.allocator.newChildAllocator("arrow-table-reader", 64L, Long.MAX_VALUE);
    private final BufferAllocator allocator;

    public ArrowTableSerializer(Fury fury) {
        this(fury, defaultAllocator);
    }

    public ArrowTableSerializer(Fury fury, BufferAllocator allocator) {
        super(fury, ArrowTable.class, Type.FURY_ARROW_TABLE.getId());
        this.allocator = allocator;
    }

    public void write(MemoryBuffer buffer, ArrowTable value) {
        this.fury.writeBufferObject(buffer, (BufferObject)new ArrowSerializers.ArrowTableBufferObject(value));
    }

    public ArrowTable read(MemoryBuffer buffer) {
        MemoryBuffer buf = this.fury.readBufferObject(buffer);
        ArrayList<ArrowRecordBatch> recordBatches = new ArrayList<ArrowRecordBatch>();
        try {
            FuryReadableByteChannel channel = new FuryReadableByteChannel(buf);
            ArrowStreamReader reader = new ArrowStreamReader((ReadableByteChannel)channel, this.allocator);
            VectorSchemaRoot root = reader.getVectorSchemaRoot();
            while (reader.loadNextBatch()) {
                recordBatches.add(new VectorUnloader(root).getRecordBatch());
            }
            return new ArrowTable(root.getSchema(), recordBatches, this.allocator);
        }
        catch (Exception e) {
            Platform.throwException((Throwable)e);
            throw new RuntimeException("unreachable");
        }
    }
}

