/*
 * Decompiled with CFR 0.152.
 */
package io.fury.format.vectorized;

import io.fury.format.vectorized.ArrowWriter;
import io.fury.io.FuryInputStream;
import io.fury.io.FuryOutputStream;
import io.fury.memory.MemoryBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;

public class ArrowUtils {
    public static RootAllocator allocator = new RootAllocator();
    private static final ThreadLocal<ArrowBuf> decimalArrowBuf = ThreadLocal.withInitial(() -> ArrowUtils.buffer(32L));

    public static ArrowBuf buffer(long initialRequestSize) {
        return allocator.buffer(initialRequestSize);
    }

    public static ArrowBuf decimalArrowBuf() {
        return decimalArrowBuf.get();
    }

    public static VectorSchemaRoot createVectorSchemaRoot(Schema schema) {
        return VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
    }

    public static ArrowWriter createArrowWriter(Schema schema) {
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
        return new ArrowWriter(root);
    }

    public static void serializeRecordBatch(ArrowRecordBatch recordBatch, MemoryBuffer buffer) {
        try (WriteChannel channel = new WriteChannel(Channels.newChannel((OutputStream)new FuryOutputStream(buffer)));){
            MessageSerializer.serialize((WriteChannel)channel, (ArrowRecordBatch)recordBatch);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Serialize record batch %s failed", recordBatch), e);
        }
    }

    public static ArrowRecordBatch deserializeRecordBatch(MemoryBuffer recordBatchMessageBuffer) {
        ArrowRecordBatch arrowRecordBatch;
        ReadChannel channel = new ReadChannel(Channels.newChannel((InputStream)new FuryInputStream(recordBatchMessageBuffer)));
        try {
            arrowRecordBatch = MessageSerializer.deserializeRecordBatch((ReadChannel)channel, (BufferAllocator)allocator);
        }
        catch (Throwable throwable) {
            try {
                try {
                    channel.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Deserialize record batch failed", e);
            }
        }
        channel.close();
        return arrowRecordBatch;
    }
}

